/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChunkLoaderEntity
extends AbstractRecruitEntity {
    private Optional<RecruitsChunk> loadedChunk = Optional.empty();

    public AbstractChunkLoaderEntity(EntityType<? extends AbstractChunkLoaderEntity> entityType, Level world) {
        super((EntityType<? extends AbstractInventoryEntity>)entityType, world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.shouldLoadChunk()) {
            this.updateChunkLoading();
        }
    }

    public boolean shouldLoadChunk() {
        return true;
    }

    public void updateChunkLoading() {
        if (!this.m_20193_().m_5776_() && ((Boolean)RecruitsServerConfig.RecruitsChunkLoading.get()).booleanValue()) {
            RecruitsChunk currentChunk = new RecruitsChunk(this.m_146902_().f_45578_, this.m_146902_().f_45579_);
            if (this.loadedChunk.isEmpty()) {
                this.setForceChunk(currentChunk, true);
                this.loadedChunk = Optional.of(currentChunk);
            } else if (!currentChunk.equals(this.loadedChunk.get())) {
                Set<RecruitsChunk> toForce = this.getSetOfChunks(currentChunk);
                Set<RecruitsChunk> toUnForce = this.getSetOfChunks(this.loadedChunk.get());
                toUnForce.removeAll(toForce);
                Set<RecruitsChunk> forced = this.getSetOfChunks(this.loadedChunk.get());
                toForce.removeAll(forced);
                toUnForce.forEach(chunk -> this.setForceChunk((RecruitsChunk)chunk, false));
                toForce.forEach(chunk -> this.setForceChunk((RecruitsChunk)chunk, true));
                this.loadedChunk = Optional.of(currentChunk);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.loadedChunk.isPresent()) {
            nbt.m_128405_("chunkX", this.loadedChunk.get().x);
            nbt.m_128405_("chunkZ", this.loadedChunk.get().z);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("chunkX")) {
            int x = nbt.m_128451_("chunkX");
            int z = nbt.m_128451_("chunkZ");
            this.loadedChunk = Optional.of(new RecruitsChunk(x, z));
        }
    }

    private Set<RecruitsChunk> getSetOfChunks(RecruitsChunk chunk) {
        HashSet<RecruitsChunk> set = new HashSet<RecruitsChunk>();
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                set.add(new RecruitsChunk(chunk.x + i, chunk.z + k));
            }
        }
        return set;
    }

    private void setForceChunk(RecruitsChunk chunk, boolean add) {
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_20193_()), (String)"recruits", (Entity)this, (int)chunk.x, (int)chunk.z, (boolean)add, (boolean)false);
    }

    @Override
    public void m_6667_(DamageSource dmg) {
        super.m_6667_(dmg);
        if (!this.m_20193_().f_46443_) {
            this.loadedChunk.ifPresent(chunk -> this.getSetOfChunks((RecruitsChunk)chunk).forEach(chunk1 -> this.setForceChunk((RecruitsChunk)chunk1, false)));
        }
    }

    public static class RecruitsChunk {
        int x;
        int z;

        public RecruitsChunk(ChunkPos chunkPosition) {
            this(chunkPosition.f_45578_, chunkPosition.f_45579_);
        }

        public RecruitsChunk(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean isSame(RecruitsChunk otherChunk) {
            if (otherChunk != null) {
                return this.x == otherChunk.x && this.z == otherChunk.z;
            }
            return false;
        }

        public RecruitsChunk getNextChunk(Direction direction) {
            RecruitsChunk recruitsChunk = null;
            switch (direction) {
                case NORTH: {
                    recruitsChunk = new RecruitsChunk(this.x, this.z - 1);
                    break;
                }
                case EAST: {
                    recruitsChunk = new RecruitsChunk(this.x + 1, this.z);
                    break;
                }
                case SOUTH: {
                    recruitsChunk = new RecruitsChunk(this.x, this.z + 1);
                    break;
                }
                case WEST: {
                    recruitsChunk = new RecruitsChunk(this.x - 1, this.z);
                    break;
                }
            }
            return recruitsChunk;
        }

        public static List<RecruitsChunk> getSurroundingChunks(@NotNull RecruitsChunk currentChunk) {
            ArrayList<RecruitsChunk> list = new ArrayList<RecruitsChunk>();
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    RecruitsChunk newChunk = new RecruitsChunk(currentChunk.x + i, currentChunk.z + k);
                    list.add(newChunk);
                }
            }
            return list;
        }

        public static List<RecruitsChunk> getChunksToUnload(List<RecruitsChunk> currentChunks, List<RecruitsChunk> prevChunks) {
            ArrayList<RecruitsChunk> list = new ArrayList<RecruitsChunk>();
            for (RecruitsChunk prevChunk : prevChunks) {
                for (RecruitsChunk currentChunk : currentChunks) {
                    if (currentChunk.isSame(prevChunk)) continue;
                    list.add(prevChunk);
                }
            }
            return list;
        }
    }
}

