/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.compat.SmallShips;
import com.talhanation.recruits.entities.AbstractChunkLoaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.entities.ai.controller.IAttackController;
import com.talhanation.recruits.inventory.PatrolLeaderContainer;
import com.talhanation.recruits.network.MessageOpenSpecialScreen;
import com.talhanation.recruits.network.MessageToClientUpdateLeaderScreen;
import com.talhanation.recruits.util.FormationUtils;
import com.talhanation.recruits.util.NPCArmy;
import com.talhanation.recruits.util.RecruitCommanderUtil;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLeaderEntity
extends AbstractChunkLoaderEntity
implements ICompanion {
    private static final EntityDataAccessor<Integer> WAYPOINT_INDEX = SynchedEntityData.m_135353_(AbstractLeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WAIT_TIME_IN_MIN = SynchedEntityData.m_135353_(AbstractLeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CYCLE = SynchedEntityData.m_135353_(AbstractLeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FAST_PATROLLING = SynchedEntityData.m_135353_(AbstractLeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> PATROLLING_STATE = SynchedEntityData.m_135353_(AbstractLeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> INFO_MODE = SynchedEntityData.m_135353_(AbstractLeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public boolean returning;
    public boolean retreating;
    public int commandCooldown = 0;
    public BlockPos currentWaypoint;
    protected int waitingTime = 0;
    protected int waitForRecruitsUpkeepTime = 0;
    public int infoCooldown = 0;
    protected State state = State.IDLE;
    public State prevState = State.IDLE;
    protected String ownerName = "";
    public NPCArmy army;
    public NPCArmy enemyArmy;
    public IAttackController attackController;
    public Stack<BlockPos> WAYPOINTS = new Stack();
    public Stack<ItemStack> WAYPOINT_ITEMS = new Stack();
    private boolean retreatingMessage = false;
    private int checkEnemyTimer;
    private boolean checkForArmy = false;

    public AbstractLeaderEntity(EntityType<? extends AbstractLeaderEntity> entityType, Level world) {
        super((EntityType<? extends AbstractChunkLoaderEntity>)entityType, world);
        if (this.army == null && !this.m_9236_().m_5776_()) {
            this.army = new NPCArmy((ServerLevel)this.m_9236_(), null, null);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WAYPOINT_INDEX, (Object)0);
        this.f_19804_.m_135372_(WAIT_TIME_IN_MIN, (Object)0);
        this.f_19804_.m_135372_(CYCLE, (Object)false);
        this.f_19804_.m_135372_(FAST_PATROLLING, (Object)false);
        this.f_19804_.m_135372_(PATROLLING_STATE, (Object)3);
        this.f_19804_.m_135372_(INFO_MODE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        CompoundTag compoundnbt;
        super.m_7380_(nbt);
        nbt.m_128405_("waypoint_index", this.getWaypointIndex());
        nbt.m_128405_("wait_time_in_min", this.getWaitTimeInMin());
        nbt.m_128405_("waiting_time", this.waitingTime);
        nbt.m_128379_("cycle", this.getCycle());
        nbt.m_128344_("patrolState", this.state.getIndex());
        nbt.m_128344_("prevPatrolState", this.prevState.getIndex());
        nbt.m_128379_("returning", this.returning);
        nbt.m_128379_("retreating", this.retreating);
        nbt.m_128344_("infoMode", this.getInfoMode());
        nbt.m_128359_("OwnerName", this.ownerName);
        nbt.m_128379_("fastPatrolling", this.getFastPatrolling());
        nbt.m_128405_("waitForRecruitsUpkeepTime", this.waitForRecruitsUpkeepTime);
        ListTag waypointItems = new ListTag();
        for (int i = 0; i < this.WAYPOINT_ITEMS.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.WAYPOINT_ITEMS.get(i);
            if (itemstack.m_41619_()) continue;
            compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("WaypointItem", (byte)i);
            itemstack.m_41739_(compoundnbt);
            waypointItems.add((Object)compoundnbt);
        }
        nbt.m_128365_("WaypointItems", (Tag)waypointItems);
        ListTag waypoints = new ListTag();
        for (int i = 0; i < this.WAYPOINTS.size(); ++i) {
            compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Waypoint", (byte)i);
            BlockPos pos = (BlockPos)this.WAYPOINTS.get(i);
            compoundnbt.m_128347_("PosX", (double)pos.m_123341_());
            compoundnbt.m_128347_("PosY", (double)pos.m_123342_());
            compoundnbt.m_128347_("PosZ", (double)pos.m_123343_());
            waypoints.add((Object)compoundnbt);
        }
        nbt.m_128365_("Waypoints", (Tag)waypoints);
        CompoundTag armyTag = new CompoundTag();
        if (this.army != null) {
            this.army.save(armyTag);
        }
        nbt.m_128365_("ArmyData", (Tag)armyTag);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setWaypointIndex(nbt.m_128451_("waypoint_index"));
        this.setWaitTimeInMin(nbt.m_128451_("wait_time_in_min"));
        this.setCycle(nbt.m_128471_("cycle"));
        this.setPatrolState(State.fromIndex(nbt.m_128445_("patrolState")));
        this.prevState = State.fromIndex(nbt.m_128445_("prevPatrolState"));
        this.returning = nbt.m_128471_("returning");
        this.retreating = nbt.m_128471_("retreating");
        this.waitingTime = nbt.m_128451_("waiting_time");
        this.waitForRecruitsUpkeepTime = nbt.m_128451_("waitForRecruitsUpkeepTime");
        this.setInfoMode(nbt.m_128445_("infoMode"));
        this.ownerName = nbt.m_128461_("ownerName");
        this.setFastPatrolling(nbt.m_128471_("fastPatrolling"));
        ListTag waypointItems = nbt.m_128437_("WaypointItems", 10);
        for (int i = 0; i < waypointItems.size(); ++i) {
            CompoundTag compoundnbt = waypointItems.m_128728_(i);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundnbt);
            this.WAYPOINT_ITEMS.push(itemStack);
        }
        ListTag waypoints = nbt.m_128437_("Waypoints", 10);
        for (int i = 0; i < waypoints.size(); ++i) {
            CompoundTag compoundnbt = waypoints.m_128728_(i);
            BlockPos pos = new BlockPos((int)compoundnbt.m_128459_("PosX"), (int)compoundnbt.m_128459_("PosY"), (int)compoundnbt.m_128459_("PosZ"));
            this.WAYPOINTS.push(pos);
        }
        if (nbt.m_128441_("ArmyData") && !this.m_20193_().m_5776_()) {
            this.army = NPCArmy.load((ServerLevel)this.m_20193_(), nbt.m_128469_("ArmyData"));
            this.army.initRecruits(true);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.checkForArmy && this.army != null) {
            this.checkForArmy = true;
            this.army.initRecruits(true);
        }
        if (this.checkEnemyTimer > 0) {
            --this.checkEnemyTimer;
        }
        if (this.infoCooldown > 0) {
            --this.infoCooldown;
        }
        if (this.commandCooldown > 0) {
            --this.commandCooldown;
        }
        if (this.waitForRecruitsUpkeepTime > 0) {
            --this.waitForRecruitsUpkeepTime;
        }
        if (this.checkEnemyTimer == 0) {
            this.checkEnemyTimer = 200;
            this.checkForPotentialEnemies();
        }
        double distance = 0.0;
        if (this.currentWaypoint != null) {
            distance = this.m_20275_(this.currentWaypoint.m_123341_(), this.currentWaypoint.m_123342_(), this.currentWaypoint.m_123343_());
        }
        switch (this.state) {
            case IDLE: 
            case PAUSED: 
            case STOPPED: {
                break;
            }
            case PATROLLING: {
                if (this.currentWaypoint != null) {
                    if (distance <= this.getDistanceToReachWaypoint()) {
                        boolean isFirstWaypoint = this.getWaypointIndex() == 0;
                        BlockPos pos = this.getUpkeepPos();
                        if (pos != null && pos.m_123331_((Vec3i)this.m_20097_()) < 5000.0 && isFirstWaypoint && (this.waitForRecruitsUpkeepTime == 0 || this.getOtherUpkeepInterruption())) {
                            this.handleResupply();
                            this.waitForRecruitsUpkeepTime = this.getResupplyTime();
                            this.setPatrolState(State.UPKEEP);
                            this.retreating = false;
                            this.retreatingMessage = false;
                        } else {
                            this.updateWaypointIndex();
                            this.waitingTime = 120;
                            this.setPatrolState(State.WAITING);
                        }
                    } else {
                        this.moveToCurrentWaypoint();
                    }
                } else if (!this.WAYPOINTS.isEmpty() && this.hasIndex()) {
                    this.currentWaypoint = (BlockPos)this.WAYPOINTS.get(this.getWaypointIndex());
                } else {
                    this.setPatrolState(State.IDLE);
                }
                if (this.enemyArmy == null || this.retreating) break;
                if (this.enemyArmySpotted()) {
                    this.setPatrolState(State.ATTACKING);
                    break;
                }
                this.m_6710_(null);
                break;
            }
            case WAITING: {
                if (this.timerElapsed() && this.hasIndex()) {
                    this.currentWaypoint = (BlockPos)this.WAYPOINTS.get(this.getWaypointIndex());
                    this.setPatrolState(State.PATROLLING);
                }
                if (distance > 25.0 && this.enemyArmy == null) {
                    this.moveToCurrentWaypoint();
                }
                if (this.enemyArmy == null || this.enemyArmy.size() <= 0) break;
                if (this.enemyArmySpotted()) {
                    this.attackController.setInitPos(this.enemyArmy.getPosition());
                    this.setPatrolState(State.ATTACKING);
                    break;
                }
                this.m_6710_(null);
                break;
            }
            case ATTACKING: {
                if (this.retreating && this.WAYPOINTS != null && this.WAYPOINTS.size() > 0) {
                    this.setPatrolState(State.RETREATING);
                    return;
                }
                if (this.army == null || this.enemyArmy == null) {
                    this.setFollowState(0);
                    this.setPatrolState(this.prevState);
                    return;
                }
                this.attackController.tick();
                break;
            }
            case RETREATING: {
                if (this.getOwner() != null && !this.retreatingMessage) {
                    this.getOwner().m_213846_((Component)this.RETREATING());
                    this.retreatingMessage = true;
                }
                this.retreating = true;
                if (this.army != null) {
                    RecruitCommanderUtil.setRecruitsClearTargets(this.army.getAllRecruitUnits());
                    RecruitCommanderUtil.setRecruitsFollow(this.army.getAllRecruitUnits(), this.f_19820_);
                    RecruitCommanderUtil.setRecruitsShields(this.army.getAllRecruitUnits(), false);
                }
                this.setPatrolState(State.PATROLLING);
                break;
            }
            case UPKEEP: {
                this.handleUpkeepState();
            }
        }
    }

    public boolean getOtherUpkeepInterruption() {
        if (this.army != null && this.army.size() != 0 && this.army.getAverageHealth() < 25.0) {
            return true;
        }
        return this.army != null && this.army.size() != 0 && this.army.getAverageMorale() < 40.0;
    }

    private void checkForPotentialEnemies() {
        if (!this.m_9236_().m_5776_()) {
            List<LivingEntity> targets = this.m_20193_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(100.0)).stream().filter(target -> this.shouldAttack((LivingEntity)target) && this.m_142582_((Entity)target) && !target.m_5842_()).toList();
            if (targets.isEmpty()) {
                return;
            }
            this.enemyArmy = new NPCArmy((ServerLevel)this.m_9236_(), targets, null);
            if (this.state != State.ATTACKING && this.canAttackWhilePatrolling()) {
                this.setPatrolState(State.ATTACKING);
            }
        }
    }

    public boolean canAttackWhilePatrolling() {
        return true;
    }

    @Override
    public void setState(int state) {
        super.setState(state);
        if (this.army != null) {
            RecruitCommanderUtil.setRecruitsAggroState(this.army.getAllRecruitUnits(), state);
        }
    }

    protected void handleUpkeepState() {
        boolean allRecruitsResupplied;
        if (this.waitForRecruitsUpkeepTime == 0 && (allRecruitsResupplied = this.army.getAllRecruitUnits().stream().allMatch(recruit -> recruit.getUpkeepTimer() >= 0))) {
            this.waitForRecruitsUpkeepTime = this.getAgainResupplyTime();
            this.setPatrolState(State.PATROLLING);
        }
    }

    public boolean enemyArmySpotted() {
        if (this.enemyArmy == null || this.army == null) {
            return false;
        }
        double distanceToTarget = this.army.getPosition().m_82557_(this.enemyArmy.getPosition());
        if (this.enemyArmy != null && !this.enemyArmy.getAllRecruitUnits().isEmpty() && (distanceToTarget < 5000.0 || Double.isNaN(distanceToTarget))) {
            this.attackController.setInitPos(this.enemyArmy.getPosition());
            return true;
        }
        return false;
    }

    public void handleResupply() {
        if (this.army == null) {
            return;
        }
        RecruitCommanderUtil.setRecruitsWanderFreely(this.army.getAllRecruitUnits());
        RecruitCommanderUtil.setRecruitsUpkeep(this.army.getAllRecruitUnits(), this.getUpkeepPos(), this.getUpkeepUUID());
        this.forcedUpkeep = true;
    }

    public int getResupplyTime() {
        return 1000;
    }

    public int getAgainResupplyTime() {
        return 12000;
    }

    public void resetPatrolling() {
        this.waitForRecruitsUpkeepTime = 0;
        this.retreating = false;
        this.waitingTime = 0;
        RecruitCommanderUtil.setRecruitsClearTargets(this.army.getAllRecruitUnits());
        Vec3 forward = this.m_20182_().m_82541_().m_82505_(this.currentWaypoint.m_252807_().m_82541_());
        FormationUtils.squareFormation(forward, this.army.getAllRecruitUnits(), this.m_20182_().m_82541_(), 1.25);
        RecruitCommanderUtil.setRecruitsShields(this.army.getAllRecruitUnits(), false);
    }

    public double getDistanceToReachWaypoint() {
        return 5.0;
    }

    protected void moveToCurrentWaypoint() {
        if (this.f_19797_ % 20 == 0) {
            this.m_21573_().m_26519_((double)this.currentWaypoint.m_123341_(), (double)this.currentWaypoint.m_123342_(), (double)this.currentWaypoint.m_123343_(), this.getFastPatrolling() ? 1.0 : (double)0.6f);
            Vec3 forward = this.m_20182_().m_82505_(this.currentWaypoint.m_252807_());
            if (this.army != null) {
                FormationUtils.lineFormation(forward.m_82541_(), this.army.getAllRecruitUnits(), this.m_20182_(), 4, 1.75);
                RecruitCommanderUtil.setRecruitsPatrolMoveSpeed(this.army.getAllRecruitUnits(), 0.7f, 60.0f);
            }
        }
        if (this.f_19862_ || this.f_185931_) {
            this.m_21569_().m_24901_();
        }
    }

    public void setPatrolState(State state) {
        this.f_19804_.m_135381_(PATROLLING_STATE, (Object)state.getIndex());
        if (this.state != this.prevState) {
            this.prevState = this.state;
        }
        this.state = state;
    }

    private void sendInfoAboutTarget(LivingEntity target) {
        InfoMode infoMode = InfoMode.fromIndex(this.getInfoMode());
        if (this.getOwner() != null && this.infoCooldown == 0 && infoMode != InfoMode.NONE) {
            AbstractRecruitEntity recruitTarget;
            if (!(infoMode != InfoMode.ALL && infoMode != InfoMode.HOSTILE || target.m_6095_().m_20674_() != MobCategory.MONSTER && !(target instanceof Pillager))) {
                this.getOwner().m_213846_((Component)this.HOSTILE_CONTACT(this.m_20097_()));
            } else if ((infoMode == InfoMode.ALL || infoMode == InfoMode.ENEMY) && (target instanceof Player || target instanceof AbstractRecruitEntity && ((recruitTarget = (AbstractRecruitEntity)target).isOwned() || recruitTarget.m_5647_() != null))) {
                this.getOwner().m_213846_((Component)this.ENEMY_CONTACT(target.m_6095_().toString(), this.m_20097_()));
            }
            this.infoCooldown = 1200;
        }
    }

    private boolean hasIndex() {
        return !this.WAYPOINTS.isEmpty() && this.WAYPOINTS.size() > this.getWaypointIndex();
    }

    private boolean timerElapsed() {
        return ++this.waitingTime > this.getWaitTimeInMin() * 60 * 20;
    }

    public void decreaseIndex() {
        int currentIndex = this.getWaypointIndex();
        int nextIndex = currentIndex - 1;
        if (nextIndex >= 0) {
            this.setWaypointIndex(nextIndex);
        }
    }

    public void increaseIndex() {
        int currentIndex = this.getWaypointIndex();
        int nextIndex = currentIndex + 1;
        if (nextIndex < this.WAYPOINTS.size()) {
            this.setWaypointIndex(nextIndex);
        }
    }

    public void updateWaypointIndex() {
        boolean isFirstWaypoint;
        int currentIndex = this.getWaypointIndex();
        boolean isCycling = this.getCycle();
        boolean isLastWaypoint = currentIndex == this.WAYPOINTS.size() - 1;
        boolean bl = isFirstWaypoint = currentIndex == 0;
        if (isCycling && !this.retreating) {
            if (isLastWaypoint) {
                this.setWaypointIndex(0);
            } else {
                this.increaseIndex();
            }
        } else if (this.returning || this.retreating) {
            if (isFirstWaypoint) {
                this.returning = false;
                this.retreating = false;
            } else {
                this.decreaseIndex();
            }
        } else if (isLastWaypoint) {
            this.returning = true;
        } else {
            this.increaseIndex();
        }
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public byte getInfoMode() {
        return (Byte)this.f_19804_.m_135370_(INFO_MODE);
    }

    public void setInfoMode(byte x) {
        this.f_19804_.m_135381_(INFO_MODE, (Object)x);
    }

    public void setCycle(boolean cycle) {
        this.f_19804_.m_135381_(CYCLE, (Object)cycle);
    }

    public void setWaitTimeInMin(int wait_time_in_min) {
        this.f_19804_.m_135381_(WAIT_TIME_IN_MIN, (Object)wait_time_in_min);
    }

    public void setWaypointIndex(int current_waypoint_index) {
        this.f_19804_.m_135381_(WAYPOINT_INDEX, (Object)current_waypoint_index);
    }

    public byte getPatrollingState() {
        return (Byte)this.f_19804_.m_135370_(PATROLLING_STATE);
    }

    public boolean getCycle() {
        return (Boolean)this.f_19804_.m_135370_(CYCLE);
    }

    public int getWaitTimeInMin() {
        return (Integer)this.f_19804_.m_135370_(WAIT_TIME_IN_MIN);
    }

    public int getWaypointIndex() {
        return (Integer)this.f_19804_.m_135370_(WAYPOINT_INDEX);
    }

    public void setFastPatrolling(boolean fastPatrolling) {
        this.f_19804_.m_135381_(FAST_PATROLLING, (Object)fastPatrolling);
    }

    public boolean getFastPatrolling() {
        return false;
    }

    public MutableComponent ENEMY_CONTACT(String name, BlockPos pos) {
        return Component.m_237110_((String)"chat.recruits.text.patrol_leader_enemy_contact", (Object[])new Object[]{this.m_7755_().getString(), name, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public MutableComponent HOSTILE_CONTACT(BlockPos pos) {
        return Component.m_237110_((String)"chat.recruits.text.patrol_leader_hostile_contact", (Object[])new Object[]{this.m_7755_().getString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public MutableComponent RETREATING() {
        return Component.m_237110_((String)"chat.recruits.text.patrol_leader_retreating", (Object[])new Object[]{this.m_7755_().getString()});
    }

    public ItemStack getItemStackToRender(BlockPos pos) {
        ItemStack itemStack;
        BlockState state = this.m_20193_().m_8055_(pos);
        if (state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_)) {
            if (this instanceof CaptainEntity) {
                itemStack = SmallShips.getSmallShipsItem();
                if (itemStack == null) {
                    itemStack = Items.f_42453_.m_7968_();
                }
            } else {
                itemStack = new BlockItem(Blocks.f_49990_, new Item.Properties()).m_7968_();
            }
        } else {
            itemStack = state.m_60713_(Blocks.f_50016_) || state.m_60713_(Blocks.f_50627_) ? new ItemStack((ItemLike)Items.f_42276_) : new ItemStack((ItemLike)state.m_60734_().m_5456_());
        }
        return itemStack;
    }

    public void addWaypoint(BlockPos pos) {
        ItemStack itemStack = this.getItemStackToRender(pos);
        this.WAYPOINT_ITEMS.push(itemStack);
        this.WAYPOINTS.push(pos);
    }

    public int getArmySize() {
        if (this.army == null) {
            return 0;
        }
        return this.army.size();
    }

    @Override
    public void m_6667_(DamageSource dmg) {
        super.m_6667_(dmg);
        if (this.army != null && !this.army.getAllRecruitUnits().isEmpty()) {
            RecruitCommanderUtil.setRecruitsWanderFreely(this.army.getAllRecruitUnits());
            RecruitCommanderUtil.setRecruitsListen(this.army.getAllRecruitUnits(), true);
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource dmg, float amt) {
        if ((double)this.m_21233_() * 0.25 > (double)this.m_21223_() && this.state != State.RETREATING) {
            this.state = State.RETREATING;
        }
        return super.m_6469_(dmg, amt);
    }

    @Override
    public void openSpecialGUI(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return AbstractLeaderEntity.this.m_7755_();
                }

                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new PatrolLeaderContainer(i, playerEntity, AbstractLeaderEntity.this);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenSpecialScreen(player, this.m_20148_()));
        }
        if (player instanceof ServerPlayer) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateLeaderScreen(this.WAYPOINTS, this.WAYPOINT_ITEMS, this.army.getTotalUnits()));
        }
    }

    public static enum State {
        IDLE(0),
        PATROLLING(1),
        PAUSED(2),
        STOPPED(3),
        WAITING(4),
        ATTACKING(5),
        RETREATING(6),
        UPKEEP(7);

        private final byte index;

        private State(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public static State fromIndex(byte index) {
            for (State state : State.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid State index: " + index);
        }
    }

    public static enum InfoMode {
        ALL(0),
        NONE(1),
        ENEMY(2),
        HOSTILE(3);

        private final byte index;

        private InfoMode(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public InfoMode getNext() {
            byte newIndex = (byte)(this.index + 1);
            int length = InfoMode.values().length;
            if (newIndex >= length) {
                return ALL;
            }
            return InfoMode.fromIndex(newIndex);
        }

        public static InfoMode fromIndex(byte index) {
            for (InfoMode state : InfoMode.values()) {
                if (state.getIndex() != index) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid InfoMode index: " + index);
        }
    }
}

