/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RecruitUpkeepEntityGoal
extends Goal {
    public AbstractRecruitEntity recruit;
    public Optional<Entity> entity;
    public Container container;
    public boolean message;
    public boolean messageNotInRange;
    public BlockPos pos;
    public int timeToRecalcPath;
    private long lastCanUseCheck;
    public boolean canResetPaymentTimer = false;

    public RecruitUpkeepEntityGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
    }

    public boolean m_8036_() {
        long i = this.recruit.m_20193_().m_46467_();
        if (i - this.lastCanUseCheck >= 20L) {
            this.lastCanUseCheck = i;
            return this.recruit.needsToGetFood() && this.recruit.getUpkeepUUID() != null;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    private boolean isFoodInEntity(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack foodItem = container.m_8020_(i);
            if (!this.recruit.canEatItemStack(foodItem)) continue;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.timeToRecalcPath = 0;
        this.message = true;
        this.messageNotInRange = true;
        this.entity = this.findEntity();
        if (this.entity.isPresent()) {
            this.pos = this.entity.get().m_20097_();
            Entity entity = this.entity.get();
            if (entity instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)entity;
                this.container = horse.f_30520_;
            } else {
                entity = this.entity.get();
                if (entity instanceof InventoryCarrier) {
                    InventoryCarrier carrier = (InventoryCarrier)entity;
                    this.container = carrier.m_35311_();
                } else {
                    entity = this.entity.get();
                    if (entity instanceof Container) {
                        Container containerEntity;
                        this.container = containerEntity = (Container)entity;
                    }
                }
            }
        } else {
            if (this.recruit.getOwner() != null && this.messageNotInRange) {
                this.recruit.getOwner().m_213846_((Component)this.TEXT_NOT_IN_RANGE(this.recruit.m_7755_().getString()));
                this.messageNotInRange = false;
            }
            this.recruit.clearUpkeepEntity();
            this.m_8041_();
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.entity.isPresent()) {
            double distance;
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.recruit.m_21573_().m_26519_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), 1.15);
            }
            if (this.recruit.f_19862_ || this.recruit.f_185931_) {
                this.recruit.m_21569_().m_24901_();
            }
            if ((distance = this.recruit.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.pos))) < 50.0 && this.container != null) {
                this.checkIfMounted(this.entity.get());
                this.recruit.m_21573_().m_26573_();
                this.recruit.m_21563_().m_24950_(this.entity.get().m_20185_(), this.entity.get().m_20186_() + 1.0, this.entity.get().m_20189_(), 10.0f, (float)this.recruit.m_8132_());
                if (this.recruit.paymentTimer == 0) {
                    this.recruit.checkPayment(this.container);
                    this.canResetPaymentTimer = true;
                }
                this.recruit.upkeepReequip(this.container);
                if (this.isFoodInEntity(this.container)) {
                    for (int i = 0; i < 3; ++i) {
                        ItemStack foodItem = this.getFoodFromInv(this.container);
                        if (foodItem != null && this.canAddFood()) {
                            ItemStack food = foodItem.m_41777_();
                            food.m_41764_(1);
                            this.recruit.getInventory().m_19173_(food);
                            foodItem.m_41774_(1);
                            continue;
                        }
                        if (this.recruit.getOwner() == null || !this.message) continue;
                        this.recruit.getOwner().m_213846_((Component)this.TEXT_NO_PLACE(this.recruit.m_7755_().getString()));
                        this.message = false;
                    }
                    this.m_8041_();
                    return;
                }
                if (this.recruit.getOwner() != null && this.message) {
                    this.recruit.getOwner().m_213846_((Component)this.TEXT_FOOD(this.recruit.m_7755_().getString()));
                    this.message = false;
                }
                this.m_8041_();
                return;
            }
        } else if (this.recruit.getOwner() != null && this.messageNotInRange) {
            this.recruit.getOwner().m_213846_((Component)this.TEXT_NOT_IN_RANGE(this.recruit.m_7755_().getString()));
            this.messageNotInRange = false;
            this.recruit.clearUpkeepEntity();
            this.m_8041_();
        }
    }

    private void checkIfMounted(Entity entity) {
        Entity vehicle = this.recruit.m_20202_();
        if (vehicle != null) {
            if (vehicle.m_20148_().equals(entity.m_20148_())) {
                this.recruit.m_8127_();
            } else if (vehicle.m_20202_() != null && vehicle.m_20202_().m_20148_().equals(entity.m_20148_())) {
                vehicle.m_8127_();
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.recruit.setUpkeepTimer(this.recruit.getUpkeepCooldown());
        this.recruit.forcedUpkeep = false;
        if (this.recruit.paymentTimer == 0 && this.canResetPaymentTimer) {
            this.canResetPaymentTimer = false;
            this.recruit.resetPaymentTimer();
        }
    }

    private Optional<Entity> findEntity() {
        if (this.recruit.getUpkeepUUID() == null) {
            return Optional.empty();
        }
        List entities = this.recruit.m_20193_().m_6443_(Entity.class, this.recruit.m_20191_().m_82400_(100.0), entity -> entity.m_20148_().equals(this.recruit.getUpkeepUUID()));
        return entities.isEmpty() ? Optional.empty() : Optional.of((Entity)entities.get(0));
    }

    @Nullable
    private ItemStack getFoodFromInv(Container inv) {
        ItemStack itemStack = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!this.recruit.canEatItemStack(inv.m_8020_(i))) continue;
            itemStack = inv.m_8020_(i);
            break;
        }
        return itemStack;
    }

    private boolean canAddFood() {
        for (int i = 6; i < 14; ++i) {
            if (!this.recruit.getInventory().m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private MutableComponent TEXT_NO_PLACE(String name) {
        return Component.m_237110_((String)"chat.recruits.text.noPlaceInInv", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_NOT_IN_RANGE(String name) {
        return Component.m_237110_((String)"chat.recruits.text.cantFindEntity", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_FOOD(String name) {
        return Component.m_237110_((String)"chat.recruits.text.noFoodInUpkeep", (Object[])new Object[]{name});
    }
}

