/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RecruitUpkeepPosGoal
extends Goal {
    public AbstractRecruitEntity recruit;
    public BlockPos chestPos;
    public Container container;
    public boolean message;
    public boolean messageNotChest;
    public boolean messageNeedNewChest;
    public boolean messageNotInRange;
    public int timeToRecalcPath = 0;
    public int timer = 0;
    public boolean setTimer = false;
    public boolean canResetPaymentTimer = false;

    public RecruitUpkeepPosGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
    }

    public boolean m_8036_() {
        return this.recruit.needsToGetFood() && this.recruit.getUpkeepPos() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.timeToRecalcPath = 0;
        this.message = true;
        this.messageNotChest = true;
        this.messageNeedNewChest = true;
        this.messageNotInRange = true;
        this.chestPos = this.recruit.getUpkeepPos();
        if (this.chestPos != null) {
            double distance;
            BlockEntity entity = this.recruit.m_20193_().m_7702_(this.chestPos);
            BlockState blockState = this.recruit.m_20193_().m_8055_(this.chestPos);
            Block block = blockState.m_60734_();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                this.container = ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)blockState, (Level)this.recruit.m_20193_(), (BlockPos)this.chestPos, (boolean)false);
            } else if (entity instanceof Container) {
                Container containerEntity;
                this.container = containerEntity = (Container)entity;
            } else {
                if (this.recruit.getOwner() != null && this.messageNotChest) {
                    this.recruit.getOwner().m_213846_((Component)this.TEXT_CANT_INTERACT(this.recruit.m_7755_().getString()));
                    this.messageNotChest = false;
                }
                this.chestPos = null;
                this.recruit.clearUpkeepPos();
            }
            if (this.chestPos != null && (distance = this.recruit.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.chestPos))) > 10000.0) {
                if (this.recruit.getOwner() != null && this.messageNotInRange) {
                    this.recruit.getOwner().m_213846_((Component)this.TEXT_NOT_IN_RANGE(this.recruit.m_7755_().getString()));
                    this.messageNotInRange = false;
                }
                this.recruit.clearUpkeepPos();
                this.m_8041_();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8037_() {
        block17: {
            block18: {
                super.m_8037_();
                if (this.chestPos != this.recruit.getUpkeepPos()) {
                    this.chestPos = this.recruit.getUpkeepPos();
                    this.m_8041_();
                    return;
                }
                if (this.container == null || this.chestPos == null) break block18;
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.m_183277_(10);
                    this.recruit.m_21573_().m_26519_((double)this.chestPos.m_123341_(), (double)this.chestPos.m_123342_(), (double)this.chestPos.m_123343_(), 1.15);
                }
                if (this.recruit.f_19862_ || this.recruit.f_185931_) {
                    this.recruit.m_21569_().m_24901_();
                }
                if (!this.chestPos.m_123314_((Vec3i)this.recruit.m_20097_(), 3.0) || this.container == null) break block17;
                this.recruit.m_21573_().m_26573_();
                this.recruit.m_21563_().m_24950_((double)this.chestPos.m_123341_(), (double)(this.chestPos.m_123342_() + 1), (double)this.chestPos.m_123343_(), 10.0f, (float)this.recruit.m_8132_());
                if (!this.setTimer) {
                    if (this.recruit.paymentTimer == 0) {
                        this.recruit.checkPayment(this.container);
                        this.canResetPaymentTimer = true;
                    }
                    this.recruit.upkeepReequip(this.container);
                    this.timer = 30;
                    this.setTimer = true;
                    if (this.isFoodInContainer(this.container)) {
                        this.interactChest(this.container, true);
                        for (int i = 0; i < 3; ++i) {
                            ItemStack foodItem = this.getFoodFromInv(this.container);
                            if (foodItem != null && this.canAddFood()) {
                                ItemStack food = foodItem.m_41777_();
                                food.m_41764_(1);
                                this.recruit.getInventory().m_19173_(food);
                                foodItem.m_41774_(1);
                                continue;
                            }
                            if (this.recruit.getOwner() != null && this.message) {
                                this.recruit.getOwner().m_213846_((Component)this.TEXT_NO_PLACE(this.recruit.m_7755_().getString()));
                                this.message = false;
                            }
                            this.m_8041_();
                            return;
                        }
                        break block17;
                    } else {
                        if (this.recruit.getOwner() != null && this.message) {
                            this.recruit.getOwner().m_213846_((Component)this.TEXT_FOOD(this.recruit.m_7755_().getString()));
                            this.message = false;
                        }
                        this.m_8041_();
                        return;
                    }
                }
                break block17;
            }
            this.chestPos = this.findInvPos();
            if (this.chestPos == null) {
                if (this.recruit.getOwner() != null && this.messageNeedNewChest) {
                    this.recruit.getOwner().m_213846_((Component)this.NEED_NEW_UPKEEP(this.recruit.m_7755_().getString()));
                    this.messageNeedNewChest = false;
                }
                this.recruit.clearUpkeepPos();
                this.m_8041_();
            } else {
                this.recruit.setUpkeepPos(this.chestPos);
            }
        }
        if (this.setTimer) {
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer == 0) {
                this.m_8041_();
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.recruit.setUpkeepTimer(this.recruit.getUpkeepCooldown());
        this.recruit.forcedUpkeep = false;
        this.timer = 0;
        this.setTimer = false;
        if (this.recruit.paymentTimer == 0 && this.canResetPaymentTimer) {
            this.canResetPaymentTimer = false;
            this.recruit.resetPaymentTimer();
        }
        if (this.container != null) {
            this.interactChest(this.container, false);
            this.container.m_6596_();
        }
    }

    @Nullable
    private BlockPos findInvPos() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (this.recruit.getUpkeepPos() != null) {
            int range = 8;
            for (int x = -range; x < range; ++x) {
                for (int y = -range; y < range; ++y) {
                    for (int z = -range; z < range; ++z) {
                        BlockPos chestPos = this.recruit.getUpkeepPos().m_7918_(x, y, z);
                        BlockEntity block = this.recruit.m_20193_().m_7702_(chestPos);
                        if (!(block instanceof Container)) continue;
                        Container blockContainer = (Container)block;
                        if (this.isFoodInContainer(blockContainer)) {
                            return chestPos;
                        }
                        list.add(chestPos);
                    }
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return (BlockPos)list.get(this.recruit.m_217043_().m_188503_(list.size()));
    }

    private boolean isFoodInContainer(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack foodItem = container.m_8020_(i);
            if (!this.recruit.canEatItemStack(foodItem)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private ItemStack getFoodFromInv(Container inv) {
        ItemStack itemStack = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!this.recruit.canEatItemStack(inv.m_8020_(i))) continue;
            itemStack = inv.m_8020_(i);
            break;
        }
        return itemStack;
    }

    private boolean canAddFood() {
        for (int i = 6; i < 14; ++i) {
            if (!this.recruit.getInventory().m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void interactChest(Container container, boolean open) {
        if (this.chestPos != null && (container instanceof CompoundContainer || container instanceof ChestBlockEntity)) {
            BlockState state = this.recruit.m_20193_().m_8055_(this.chestPos);
            Block block = state.m_60734_();
            boolean isOpened = false;
            CompoundTag compoundTag = new CompoundTag();
            BlockEntity blockEntity = this.recruit.m_20193_().m_7702_(this.chestPos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                compoundTag = chestBlockEntity.getPersistentData();
                if (compoundTag.m_128441_("isOpened")) {
                    isOpened = compoundTag.m_128471_("isOpened");
                } else {
                    compoundTag.m_128379_("isOpened", false);
                }
            }
            if (open) {
                if (!isOpened) {
                    this.recruit.m_20193_().m_7696_(this.chestPos, block, 1, 1);
                    this.recruit.m_20193_().m_5594_(null, this.chestPos, SoundEvents.f_11749_, this.recruit.m_5720_(), 0.7f, 0.8f + 0.4f * this.recruit.m_217043_().m_188501_());
                    compoundTag.m_128379_("isOpened", true);
                }
            } else if (isOpened) {
                this.recruit.m_20193_().m_7696_(this.chestPos, block, 1, 0);
                this.recruit.m_20193_().m_5594_(null, this.chestPos, SoundEvents.f_11747_, this.recruit.m_5720_(), 0.7f, 0.8f + 0.4f * this.recruit.m_217043_().m_188501_());
                compoundTag.m_128379_("isOpened", false);
            }
            this.recruit.m_20193_().m_142346_((Entity)this.recruit, open ? GameEvent.f_157796_ : GameEvent.f_157793_, this.chestPos);
        }
    }

    private MutableComponent TEXT_NO_PLACE(String name) {
        return Component.m_237110_((String)"chat.recruits.text.noPlaceInInv", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_CANT_INTERACT(String name) {
        return Component.m_237110_((String)"chat.recruits.text.cantInteract", (Object[])new Object[]{name});
    }

    private MutableComponent NEED_NEW_UPKEEP(String name) {
        return Component.m_237110_((String)"chat.recruits.text.findMeNewChest", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_FOOD(String name) {
        return Component.m_237110_((String)"chat.recruits.text.noFoodInUpkeep", (Object[])new Object[]{name});
    }

    private MutableComponent TEXT_NOT_IN_RANGE(String name) {
        return Component.m_237110_((String)"chat.recruits.text.upkeepNotInRange", (Object[])new Object[]{name});
    }
}

