/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai;

import com.talhanation.recruits.compat.SmallShips;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.util.Kalkuel;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public class RecruitWanderGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    protected final AbstractRecruitEntity recruit;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    private long lastCanUseCheck;
    private int timeToRecalcPath;
    protected BlockPos initialPosition;

    public RecruitWanderGoal(AbstractRecruitEntity recruit) {
        this.recruit = recruit;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    private boolean canWander() {
        LivingEntity living = this.recruit.m_5448_();
        boolean state = this.recruit.getFollowState() == 0;
        boolean target = living == null || !living.m_6084_() || living.m_20280_((Entity)this.recruit) < 300.0;
        boolean rest = !this.recruit.getShouldRest();
        boolean move = !this.recruit.getShouldMovePos();
        boolean protect = !this.recruit.getShouldProtect();
        boolean follow = !this.recruit.getShouldFollow();
        boolean fleeing = !this.recruit.getFleeing();
        boolean needFood = !this.recruit.needsToGetFood();
        boolean mount = !this.recruit.getShouldMount();
        return state && target && rest && move && protect && follow && fleeing && needFood && mount;
    }

    public boolean m_8036_() {
        long i = this.recruit.m_20193_().m_46467_();
        if (i - this.lastCanUseCheck >= 20L) {
            this.lastCanUseCheck = i;
            return this.canWander();
        }
        return false;
    }

    public boolean m_8045_() {
        return this.canWander();
    }

    public void m_8056_() {
        this.initialPosition = this.recruit.m_20097_();
        this.timeToRecalcPath = 0;
    }

    public void m_8037_() {
        super.m_8037_();
        if (!this.recruit.m_21573_().m_26571_() && (this.recruit.f_19862_ || this.recruit.f_185931_)) {
            this.recruit.m_21569_().m_24901_();
        }
        if (--this.timeToRecalcPath <= 0) {
            Boat boat;
            CaptainEntity captain;
            AbstractRecruitEntity abstractRecruitEntity = this.recruit;
            if (abstractRecruitEntity instanceof CaptainEntity && (abstractRecruitEntity = (captain = (CaptainEntity)abstractRecruitEntity).m_20202_()) instanceof Boat && SmallShips.isSmallShip((Entity)(boat = (Boat)abstractRecruitEntity))) {
                Vec3 vec3 = Kalkuel.SailPointCalculator.getRandomSailPoint(captain.m_20193_(), this.initialPosition.m_252807_(), 100.0);
                captain.setSailPos(new BlockPos((int)vec3.f_82479_, (int)captain.m_20186_(), (int)vec3.f_82481_));
                captain.smallShipsController.calculatePath();
            }
            this.timeToRecalcPath = this.m_183277_(200) + this.recruit.m_217043_().m_188503_(50);
            Vec3 vec3 = this.getPosition();
            if (vec3 != null) {
                this.wantedX = vec3.f_82479_;
                this.wantedY = vec3.f_82480_;
                this.wantedZ = vec3.f_82481_;
                this.recruit.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, 0.85);
            }
        }
    }

    public void m_8041_() {
        this.recruit.m_21573_().m_26573_();
        this.initialPosition = null;
        super.m_8041_();
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.recruit.m_20072_()) {
            this.recruit.m_21446_(this.initialPosition, 150);
            Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.recruit, (int)32, (int)16);
            return vec3 == null ? DefaultRandomPos.m_148403_((PathfinderMob)this.recruit, (int)32, (int)16) : vec3;
        }
        this.recruit.m_21446_(this.initialPosition, 20);
        return LandRandomPos.m_148488_((PathfinderMob)this.recruit, (int)10, (int)0);
    }
}

