/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageMountEntityGui
implements Message<MessageMountEntityGui> {
    private UUID recruit;
    private boolean back;

    public MessageMountEntityGui() {
    }

    public MessageMountEntityGui(UUID recruit, boolean back) {
        this.recruit = recruit;
        this.back = back;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(32.0), v -> v.m_20148_().equals(this.recruit) && v.m_6084_()).forEach(this::mount);
    }

    private void mount(AbstractRecruitEntity recruit) {
        if (this.back && recruit.getMountUUID() != null) {
            recruit.shouldMount(true, recruit.getMountUUID());
        } else if (recruit.m_20202_() == null) {
            List list = recruit.m_20193_().m_6443_(Entity.class, recruit.m_20191_().m_82400_(8.0), mount -> {
                AbstractHorse horse;
                return (!(mount instanceof AbstractHorse) || !(horse = (AbstractHorse)mount).m_217005_()) && ((List)RecruitsServerConfig.MountWhiteList.get()).contains(mount.m_20078_());
            });
            double d0 = -1.0;
            Entity horse = null;
            for (Entity entity : list) {
                double d1 = entity.m_20280_((Entity)recruit);
                if (d0 != -1.0 && !(d1 < d0)) continue;
                horse = entity;
                d0 = d1;
            }
            if (horse == null) {
                recruit.getOwner().m_213846_((Component)MessageMountEntityGui.TEXT_NO_MOUNT(recruit.m_7755_().getString()));
                return;
            }
            recruit.shouldMount(true, horse.m_20148_());
        }
    }

    @Override
    public MessageMountEntityGui fromBytes(FriendlyByteBuf buf) {
        this.recruit = buf.m_130259_();
        this.back = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.recruit);
        buf.writeBoolean(this.back);
    }

    private static MutableComponent TEXT_NO_MOUNT(String name) {
        return Component.m_237110_((String)"chat.recruits.text.noMount", (Object[])new Object[]{name});
    }
}

