/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.pathfinding;

import com.google.common.collect.Lists;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.pathfinding.AsyncPath;
import com.talhanation.recruits.pathfinding.NodeEvaluatorCache;
import com.talhanation.recruits.pathfinding.NodeEvaluatorGenerator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class AsyncPathfinder
extends PathFinder {
    private final NodeEvaluator nodeEvaluator;
    private final int maxVisitedNodes;
    private Level level;
    private NodeEvaluatorGenerator nodeEvaluatorGenerator;

    public AsyncPathfinder(NodeEvaluator p_77425_, int p_77426_) {
        super(p_77425_, p_77426_);
        this.nodeEvaluator = p_77425_;
        this.maxVisitedNodes = p_77426_;
    }

    public AsyncPathfinder(NodeEvaluator p_77425_, int p_77426_, Level level) {
        super(p_77425_, p_77426_);
        this.nodeEvaluator = p_77425_;
        this.maxVisitedNodes = p_77426_;
        this.level = level;
    }

    public AsyncPathfinder(NodeEvaluator p_77425_, int p_77426_, NodeEvaluatorGenerator nodeEvaluatorGenerator, Level level) {
        super(p_77425_, p_77426_);
        this.maxVisitedNodes = p_77426_;
        this.nodeEvaluatorGenerator = nodeEvaluatorGenerator;
        this.nodeEvaluator = p_77425_;
        this.level = level;
    }

    @Nullable
    public Path m_77427_(@NotNull PathNavigationRegion p_77428_, @NotNull Mob p_77429_, @NotNull Set<BlockPos> p_77430_, float p_77431_, int p_77432_, float p_77433_) {
        NodeEvaluator nodeEvaluator = this.nodeEvaluatorGenerator == null ? this.nodeEvaluator : NodeEvaluatorCache.takeNodeEvaluator(this.nodeEvaluatorGenerator);
        nodeEvaluator.m_6028_(p_77428_, p_77429_);
        Node node = nodeEvaluator.m_7171_();
        if (node == null) {
            if (this.nodeEvaluatorGenerator != null) {
                NodeEvaluatorCache.returnNodeEvaluator(nodeEvaluator);
            }
            return null;
        }
        ArrayList map = Lists.newArrayList();
        for (BlockPos pos : p_77430_) {
            map.add(new AbstractMap.SimpleEntry<Target, BlockPos>(nodeEvaluator.m_7568_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), pos));
        }
        if (this.nodeEvaluatorGenerator == null) {
            Main.LOGGER.error("No node evaluator generator present for Mob {}", (Object)p_77429_);
            return null;
        }
        return new AsyncPath(Lists.newArrayList(), p_77430_, this.level, () -> {
            try {
                Path path = this.processPath(nodeEvaluator, node, map, p_77431_, p_77432_, p_77433_);
                return path;
            }
            catch (Exception e) {
                e.printStackTrace();
                Path path = null;
                return path;
            }
            finally {
                nodeEvaluator.m_6802_();
                NodeEvaluatorCache.returnNodeEvaluator(nodeEvaluator);
            }
        });
    }

    @NotNull
    private Path processPath(NodeEvaluator p_164717_, Node p_164718_, List<Map.Entry<Target, BlockPos>> p_164719_, float p_164720_, int p_164721_, float p_164722_) {
        Validate.isTrue((!p_164719_.isEmpty() ? 1 : 0) != 0);
        p_164718_.f_77275_ = 0.0f;
        p_164718_.f_77277_ = p_164718_.f_77276_ = this.getBestH(p_164718_, p_164719_);
        BinaryHeap openSet = new BinaryHeap();
        openSet.m_77084_(p_164718_);
        Node[] neighbors = new Node[32];
        int i = 0;
        ArrayList entryList = Lists.newArrayListWithExpectedSize((int)p_164719_.size());
        int j = (int)((float)this.maxVisitedNodes * p_164722_);
        while (!openSet.m_77092_() && ++i < j) {
            Node node = openSet.m_77091_();
            node.f_77279_ = true;
            for (Map.Entry<Target, BlockPos> entry : p_164719_) {
                Target target = entry.getKey();
                if (!(node.m_77304_((Node)target) <= (float)p_164721_)) continue;
                target.m_77509_();
                entryList.add(entry);
            }
            if (!entryList.isEmpty()) break;
            if (node.m_77293_(p_164718_) >= p_164720_) continue;
            int k = p_164717_.m_6065_(neighbors, node);
            for (int l = 0; l < k; ++l) {
                Node node1 = neighbors[l];
                float f = this.m_214208_(node, node1);
                node1.f_77280_ = node.f_77280_ + f;
                float f1 = node.f_77275_ + f + node1.f_77281_;
                if (!(node1.f_77280_ < p_164720_) || node1.m_77303_() && !(f1 < node1.f_77275_)) continue;
                node1.f_77278_ = node;
                node1.f_77275_ = f1;
                node1.f_77276_ = this.getBestH(node1, p_164719_) * 1.5f;
                if (node1.m_77303_()) {
                    openSet.m_77086_(node1, node1.f_77275_ + node1.f_77276_);
                    continue;
                }
                node1.f_77277_ = node1.f_77275_ + node1.f_77276_;
                openSet.m_77084_(node1);
            }
        }
        Path best = null;
        boolean entryListIsEmpty = entryList.isEmpty();
        Comparator<Path> comparator = entryListIsEmpty ? Comparator.comparingInt(Path::m_77398_) : Comparator.comparingDouble(Path::m_77407_).thenComparingInt(Path::m_77398_);
        for (Map.Entry entry : entryListIsEmpty ? p_164719_ : entryList) {
            Path path = this.m_77434_(((Target)entry.getKey()).m_77508_(), (BlockPos)entry.getValue(), !entryListIsEmpty);
            if (best != null && comparator.compare(path, best) >= 0) continue;
            best = path;
        }
        return best;
    }

    private Path m_77434_(Node p_77435_, BlockPos p_77436_, boolean p_77437_) {
        ArrayList list = Lists.newArrayList();
        Node node = p_77435_;
        list.add(0, p_77435_);
        while (node.f_77278_ != null) {
            node = node.f_77278_;
            list.add(0, node);
        }
        return new Path((List)list, p_77436_, p_77437_);
    }

    private float getBestH(Node p_164718_, List<Map.Entry<Target, BlockPos>> p_164719_) {
        float f = Float.MAX_VALUE;
        for (Map.Entry<Target, BlockPos> targetBlockPosEntry : p_164719_) {
            Target target = targetBlockPosEntry.getKey();
            float f1 = p_164718_.m_77293_((Node)target);
            target.m_77503_(f1, p_164718_);
            f = Math.min(f1, f);
        }
        return f;
    }
}

