/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class Kalkuel {
    public static double horizontalAngleBetweenVectors(Vec3 vector1, Vec3 vector2) {
        double dotProduct = vector1.f_82479_ * vector2.f_82479_ + vector1.f_82481_ * vector2.f_82481_;
        double magnitude1 = Math.sqrt(vector1.f_82479_ * vector1.f_82479_ + vector1.f_82481_ * vector1.f_82481_);
        double magnitude2 = Math.sqrt(vector2.f_82479_ * vector2.f_82479_ + vector2.f_82481_ * vector2.f_82481_);
        double cosTheta = dotProduct / (magnitude1 * magnitude2);
        return Math.toDegrees(Math.acos(cosTheta));
    }

    public static float addToSetPoint(float current, float positiveChange, float setPoint) {
        if (current < setPoint) {
            current += positiveChange;
        }
        return current;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return Mth.m_14031_((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    static float subtractToZero(float num, float sub) {
        float erg;
        if (num < 0.0f) {
            erg = num + sub;
            if (erg > 0.0f) {
                erg = 0.0f;
            }
        } else {
            erg = num - sub;
            if (erg < 0.0f) {
                erg = 0.0f;
            }
        }
        return erg;
    }

    public static class SailPointCalculator {
        private static final Random random = new Random();

        public static Vec3 getRandomSailPoint(Level world, Vec3 origin, Vec3 direction, double radius) {
            for (int i = 0; i < 10; ++i) {
                double offsetZ;
                Vec3 normDir = direction.m_82541_();
                double baseAngle = Math.atan2(normDir.f_82481_, normDir.f_82479_);
                double angleOffset = (random.nextDouble() - 0.5) * 1.5707963267948966;
                double newAngle = baseAngle + angleOffset;
                double distance = random.nextDouble() * radius;
                double offsetX = Math.cos(newAngle) * distance;
                Vec3 candidate = origin.m_82520_(offsetX, 0.0, offsetZ = Math.sin(newAngle) * distance);
                if (!SailPointCalculator.hasWaterConnection(world, origin, candidate)) continue;
                return candidate;
            }
            return origin;
        }

        public static Vec3 getRandomSailPoint(Level world, Vec3 origin, double radius) {
            for (int i = 0; i < 10; ++i) {
                double offsetZ;
                double angle = random.nextDouble() * 2.0 * Math.PI;
                double distance = random.nextDouble() * radius;
                double offsetX = Math.cos(angle) * distance;
                Vec3 candidate = origin.m_82520_(offsetX, 0.0, offsetZ = Math.sin(angle) * distance);
                if (!SailPointCalculator.hasWaterConnection(world, origin, candidate)) continue;
                return candidate;
            }
            return origin;
        }

        private static boolean hasWaterConnection(Level world, Vec3 origin, Vec3 target) {
            int steps = 20;
            for (int i = 0; i <= steps; ++i) {
                double t = (double)i / (double)steps;
                double x = origin.f_82479_ + t * (target.f_82479_ - origin.f_82479_);
                double y = origin.f_82480_ + t * (target.f_82480_ - origin.f_82480_);
                double z = origin.f_82481_ + t * (target.f_82481_ - origin.f_82481_);
                BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                if (world.m_8055_(pos).m_60734_().equals(Blocks.f_49990_)) continue;
                return false;
            }
            return true;
        }
    }
}

