/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class RecruitPlayerUnitSaveData
extends SavedData {
    public static final Map<UUID, Integer> recruitCountMap = new HashMap<UUID, Integer>();
    private static final String DATA_NAME = "recruit_player_unit_data";

    public RecruitPlayerUnitSaveData() {
        recruitCountMap.clear();
        this.m_77762_();
    }

    public static RecruitPlayerUnitSaveData load(CompoundTag nbt) {
        RecruitPlayerUnitSaveData data = new RecruitPlayerUnitSaveData();
        CompoundTag recruitCounts = nbt.m_128469_("recruitCounts");
        for (String uuidKey : recruitCounts.m_128431_()) {
            UUID uuid = UUID.fromString(uuidKey);
            int count = recruitCounts.m_128451_(uuidKey);
            recruitCountMap.put(uuid, count);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag recruitCounts = new CompoundTag();
        for (Map.Entry<UUID, Integer> entry : recruitCountMap.entrySet()) {
            recruitCounts.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        nbt.m_128365_("recruitCounts", (Tag)recruitCounts);
        return nbt;
    }

    public void setRecruitCount(UUID playerUUID, int count) {
        recruitCountMap.put(playerUUID, count);
        this.m_77762_();
    }

    public Map<UUID, Integer> getRecruitCountMap() {
        return recruitCountMap;
    }

    public static RecruitPlayerUnitSaveData get(ServerLevel level) {
        return (RecruitPlayerUnitSaveData)level.m_8895_().m_164861_(RecruitPlayerUnitSaveData::load, RecruitPlayerUnitSaveData::new, DATA_NAME);
    }
}

