/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.entities.HorsemanEntity;
import com.talhanation.recruits.entities.NomadEntity;
import com.talhanation.recruits.entities.PatrolLeaderEntity;
import com.talhanation.recruits.entities.RecruitEntity;
import com.talhanation.recruits.entities.RecruitShieldmanEntity;
import com.talhanation.recruits.entities.ai.villager.FollowCaravanOwner;
import com.talhanation.recruits.init.ModEntityTypes;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class RecruitsPatrolSpawn {
    public static final Random random = new Random();
    public static int timer;
    public static double chance;
    public final ServerLevel world;

    public RecruitsPatrolSpawn(ServerLevel level) {
        this.world = level;
        timer = RecruitsPatrolSpawn.getSpawnInterval();
        chance = (Double)RecruitsServerConfig.RecruitPatrolsSpawnChance.get();
    }

    public void tick() {
        if (timer > 0) {
            --timer;
        }
        if (timer <= 0) {
            double rnd;
            if (!this.world.m_46469_().m_46207_(GameRules.f_46124_) || !((rnd = (double)random.nextInt(100)) <= chance) || RecruitsPatrolSpawn.attemptSpawnPatrol(this.world)) {
                // empty if block
            }
            timer = RecruitsPatrolSpawn.getSpawnInterval();
        }
    }

    public static boolean attemptSpawnPatrol(ServerLevel world) {
        BlockPos blockpos;
        BlockPos blockpos2;
        ServerPlayer player = world.m_8890_();
        if (player == null) {
            return true;
        }
        if (!player.m_20193_().m_6042_().m_63963_()) {
            player = world.m_8890_();
        }
        if ((blockpos2 = RecruitsPatrolSpawn.func_221244_a(blockpos = new BlockPos((Vec3i)player.m_20097_()), 90, random, world)) != null && RecruitsPatrolSpawn.func_226559_a_(blockpos2, world) && blockpos2.m_123331_((Vec3i)blockpos) > 200.0) {
            BlockPos upPos = new BlockPos(blockpos2.m_123341_(), blockpos2.m_123342_() + 2, blockpos2.m_123343_());
            int i = random.nextInt(13);
            switch (i) {
                default: {
                    RecruitsPatrolSpawn.spawnCaravan(upPos, world);
                    break;
                }
                case 0: 
                case 9: {
                    RecruitsPatrolSpawn.spawnSmallPatrol(upPos, world);
                    break;
                }
                case 1: 
                case 2: {
                    RecruitsPatrolSpawn.spawnLargePatrol(upPos, world);
                    break;
                }
                case 3: 
                case 4: {
                    RecruitsPatrolSpawn.spawnHugePatrol(upPos, world);
                    break;
                }
                case 5: 
                case 6: {
                    RecruitsPatrolSpawn.spawnTinyPatrol(upPos, world);
                    break;
                }
                case 7: 
                case 8: {
                    RecruitsPatrolSpawn.spawnRoadPatrol(upPos, world);
                    break;
                }
                case 10: 
                case 11: {
                    RecruitsPatrolSpawn.spawnMediumPatrol(upPos, world);
                }
            }
            return true;
        }
        return false;
    }

    public static int getSpawnInterval() {
        int minutes = (Integer)RecruitsServerConfig.RecruitPatrolSpawnInterval.get();
        return 1200 * minutes;
    }

    public static void spawnCaravan(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Caravan Leader");
        RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        Villager villagerGuide = RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createLlama(world, upPos, villagerGuide);
        RecruitsPatrolSpawn.createLlama(world, upPos, villagerGuide);
        Villager villagerGuide2 = RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createMule(world, upPos, (LivingEntity)villagerGuide2);
        RecruitsPatrolSpawn.createMule(world, upPos, (LivingEntity)villagerGuide2);
        Villager villagerGuide3 = RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createHorse(world, upPos, villagerGuide3);
        RecruitsPatrolSpawn.createHorse(world, upPos, villagerGuide3);
        Villager villagerGuide4 = RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createMule(world, upPos, (LivingEntity)villagerGuide4);
        RecruitsPatrolSpawn.createMule(world, upPos, (LivingEntity)villagerGuide4);
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Caravan Guard");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Caravan Guard");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Caravan Guard");
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Caravan Guard", false);
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Caravan Guard", true);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Caravan Guard", true);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Caravan Guard", false);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Caravan Guard", false);
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Caravan Guard");
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Caravan Guard");
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Caravan Guard");
        RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createVillager(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createWanderingTrader(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createWanderingTrader(world, upPos, patrolLeader);
    }

    public static void createWanderingTrader(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader) {
        WanderingTrader villager = (WanderingTrader)EntityType.f_20494_.m_20615_((Level)world);
        villager.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        villager.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        villager.m_21530_();
        villager.f_21345_.m_25352_(0, (Goal)new FollowCaravanOwner((AbstractVillager)villager, patrolLeader.m_20148_()));
        world.m_7967_((Entity)villager);
    }

    public static void createHorse(ServerLevel world, BlockPos upPos, Villager villager) {
        Horse horse = (Horse)EntityType.f_20457_.m_20615_((Level)world);
        horse.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        horse.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        horse.m_21530_();
        horse.m_30651_(true);
        horse.m_5853_(null);
        horse.m_21463_((Entity)villager, true);
        world.m_7967_((Entity)horse);
    }

    public static void createLlama(ServerLevel world, BlockPos upPos, Villager villager) {
        ItemStack resources;
        int j;
        int count;
        int x;
        Llama llama = (Llama)EntityType.f_20466_.m_20615_((Level)world);
        llama.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        llama.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        llama.m_21530_();
        llama.m_30651_(true);
        llama.m_30504_(true);
        llama.getPersistentData().m_128405_("Strength", 5);
        llama.m_30625_();
        llama.m_21463_((Entity)villager, true);
        llama.getPersistentData().m_128379_("Caravan", true);
        world.m_7967_((Entity)llama);
        for (x = 0; x < 4; ++x) {
            int k = random.nextInt(4);
            count = random.nextInt(64);
            ItemStack food = switch (k) {
                default -> new ItemStack((ItemLike)Items.f_42405_);
                case 1 -> new ItemStack((ItemLike)Items.f_42404_);
                case 2 -> new ItemStack((ItemLike)Items.f_42578_);
                case 3 -> new ItemStack((ItemLike)Items.f_42620_);
            };
            food.m_41764_(count);
            llama.f_30520_.m_19173_(food);
        }
        for (x = 0; x < 4; ++x) {
            j = random.nextInt(4);
            count = random.nextInt(64);
            switch (j) {
                default: {
                    resources = new ItemStack((ItemLike)Items.f_42401_);
                    break;
                }
                case 1: {
                    resources = new ItemStack((ItemLike)Items.f_42454_);
                    break;
                }
                case 2: {
                    resources = new ItemStack((ItemLike)Items.f_42412_);
                    break;
                }
                case 3: {
                    resources = new ItemStack((ItemLike)Items.f_42026_);
                }
            }
            resources.m_41764_(count);
            llama.f_30520_.m_19173_(resources);
        }
        for (x = 0; x < 4; ++x) {
            j = random.nextInt(4);
            count = random.nextInt(64);
            switch (j) {
                default: {
                    resources = new ItemStack((ItemLike)Items.f_42594_);
                    break;
                }
                case 1: {
                    resources = new ItemStack((ItemLike)Items.f_41870_);
                    break;
                }
                case 2: {
                    resources = new ItemStack((ItemLike)Items.f_41888_);
                    break;
                }
                case 3: {
                    resources = new ItemStack((ItemLike)Items.f_42460_);
                }
            }
            resources.m_41764_(count);
            llama.f_30520_.m_19173_(resources);
        }
    }

    public static Villager createVillager(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader) {
        Villager villager = (Villager)EntityType.f_20492_.m_20615_((Level)world);
        villager.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        villager.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        villager.m_21530_();
        villager.f_21345_.m_25352_(0, (Goal)new FollowCaravanOwner((AbstractVillager)villager, patrolLeader.m_20148_()));
        world.m_7967_((Entity)villager);
        return villager;
    }

    public static void createMule(ServerLevel world, BlockPos upPos, LivingEntity villager) {
        int j;
        int count;
        int x;
        Mule mule = (Mule)EntityType.f_20503_.m_20615_((Level)world);
        mule.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        mule.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        mule.m_21530_();
        mule.m_30651_(true);
        mule.m_30504_(true);
        mule.m_30625_();
        mule.m_21463_((Entity)villager, true);
        mule.getPersistentData().m_128379_("Caravan", true);
        for (x = 0; x < 4; ++x) {
            int k = random.nextInt(4);
            count = random.nextInt(64);
            ItemStack food = switch (k) {
                default -> new ItemStack((ItemLike)Items.f_42406_);
                case 1 -> new ItemStack((ItemLike)Items.f_42580_);
                case 2 -> new ItemStack((ItemLike)Items.f_42582_);
                case 3 -> new ItemStack((ItemLike)Items.f_42659_);
            };
            food.m_41764_(count);
            mule.f_30520_.m_6836_(16 - x, food);
        }
        for (x = 0; x < 4; ++x) {
            j = random.nextInt(5);
            count = random.nextInt(64);
            ItemStack resources = switch (j) {
                default -> new ItemStack((ItemLike)Items.f_42413_);
                case 1 -> new ItemStack((ItemLike)Items.f_42416_);
                case 2 -> new ItemStack((ItemLike)Items.f_151052_);
                case 3 -> new ItemStack((ItemLike)Items.f_42026_);
                case 4 -> new ItemStack((ItemLike)Items.f_41983_);
            };
            resources.m_41764_(count);
            mule.f_30520_.m_6836_(12 - x, resources);
        }
        for (x = 0; x < 4; ++x) {
            j = random.nextInt(4);
            int count2 = random.nextInt(64);
            ItemStack resources = switch (j) {
                default -> new ItemStack((ItemLike)Items.f_41905_);
                case 1 -> new ItemStack((ItemLike)Items.f_41870_);
                case 2 -> new ItemStack((ItemLike)Items.f_41888_);
                case 3 -> new ItemStack((ItemLike)Items.f_42460_);
            };
            resources.m_41764_(count2);
            mule.f_30520_.m_6836_(8 - x, resources);
        }
        for (x = 0; x < 3; ++x) {
            j = random.nextInt(4);
            int count3 = random.nextInt(64);
            ItemStack resources = switch (j) {
                default -> new ItemStack((ItemLike)Items.f_41830_);
                case 1 -> new ItemStack((ItemLike)Items.f_41856_);
                case 2 -> new ItemStack((ItemLike)Items.f_41904_);
                case 3 -> new ItemStack((ItemLike)Items.f_42768_);
            };
            resources.m_41764_(count3);
            mule.f_30520_.m_6836_(4 - x, resources);
        }
        world.m_7967_((Entity)mule);
    }

    public static void spawnHugePatrol(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Patrol Leader");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolCrossbowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolCrossbowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolCrossbowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", false);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", false);
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
    }

    public static void spawnLargePatrol(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Patrol Leader");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolCrossbowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolCrossbowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
    }

    public static void spawnMediumPatrol(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Patrol Leader");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolCrossbowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
    }

    public static void spawnSmallPatrol(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Patrol Leader");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
    }

    public static void spawnTinyPatrol(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Patrol Leader");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolShieldman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolBowman(world, upPos, patrolLeader);
    }

    public static void spawnRoadPatrol(BlockPos upPos, ServerLevel world) {
        RecruitEntity patrolLeader = RecruitsPatrolSpawn.createPatrolLeader(world, upPos, "Patrol Leader");
        RecruitsPatrolSpawn.createPatrolRecruit(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
        RecruitsPatrolSpawn.createPatrolHorseman(world, upPos, patrolLeader, "Patrol", true);
        RecruitsPatrolSpawn.createPatrolNomad(world, upPos, patrolLeader, "Patrol");
    }

    @Nullable
    public static BlockPos func_221244_a(BlockPos p_221244_1_, int spread, Random random, ServerLevel world) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_221244_1_.m_123341_() + random.nextInt(spread * 2) - spread;
            BlockPos blockpos1 = new BlockPos(j, l = world.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = p_221244_1_.m_123343_() + random.nextInt(spread * 2) - spread), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)world, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    public static boolean func_226559_a_(BlockPos p_226559_1_, ServerLevel world) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.m_121940_((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.m_7918_(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (world.m_8055_(blockpos = (BlockPos)var2.next()).m_60816_((BlockGetter)world, blockpos).m_83281_() && world.m_6425_(blockpos).m_76178_());
        return false;
    }

    public static void setPatrolLeaderEquipment(RecruitEntity recruit) {
        Random random = new Random();
        recruit.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
        int j = random.nextInt(16);
        ItemStack item = new ItemStack((ItemLike)Items.f_42616_);
        item.m_41764_(8 + j);
        recruit.inventory.m_6836_(8, item);
        int i = random.nextInt(8);
        if (i == 1) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        } else if (i == 2 || i == 3) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42433_));
        } else if (i == 4 || i == 5) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
        } else {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        }
    }

    public static void setPatrolRecruitEquipment(RecruitEntity recruit) {
        Random random = new Random();
        recruit.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
        int i = random.nextInt(8);
        if (i == 1) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
        } else if (i == 2 || i == 3) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        } else {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        }
        int j = random.nextInt(8);
        if (j >= 4) {
            recruit.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }

    public static void setPatrolShieldmanEquipment(RecruitShieldmanEntity recruit) {
        Random random = new Random();
        recruit.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
        int i = random.nextInt(8);
        if (i == 1) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
        } else if (i == 2 || i == 3) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        } else {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        }
    }

    public static void setPatrolBowmanEquipment(AbstractRecruitEntity recruit) {
        recruit.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
        recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        RecruitsPatrolSpawn.setRangedArrows(recruit);
    }

    public static void setRangedArrows(AbstractRecruitEntity recruit) {
        int i = random.nextInt(32);
        ItemStack arrows = new ItemStack((ItemLike)Items.f_42412_);
        arrows.m_41764_(24 + i);
        recruit.inventory.m_6836_(6, arrows);
    }

    public static void setRangedCartriges(AbstractRecruitEntity recruit) {
        int i = random.nextInt(32);
        ItemStack arrows = new ItemStack((ItemLike)Items.f_42412_);
        arrows.m_41764_(24 + i);
        recruit.inventory.m_6836_(6, arrows);
    }

    public static void setRecruitFood(AbstractRecruitEntity recruit) {
        RecruitsPatrolSpawn.setRecruitFood(recruit, 0);
    }

    public static void setRecruitFood(AbstractRecruitEntity recruit, int bonus) {
        int k = random.nextInt(8);
        ItemStack food = switch (k) {
            default -> new ItemStack((ItemLike)Items.f_42406_);
            case 1 -> new ItemStack((ItemLike)Items.f_42530_);
            case 2 -> new ItemStack((ItemLike)Items.f_42575_);
            case 3 -> new ItemStack((ItemLike)Items.f_42698_);
            case 4 -> new ItemStack((ItemLike)Items.f_42580_);
            case 5 -> new ItemStack((ItemLike)Items.f_42582_);
            case 6 -> new ItemStack((ItemLike)Items.f_42659_);
            case 7 -> new ItemStack((ItemLike)Items.f_42674_);
        };
        int i = random.nextInt(14);
        food.m_41764_(6 + i + bonus);
        recruit.inventory.m_6836_(7, food);
    }

    public static void setPatrolCrossbowmanEquipment(AbstractRecruitEntity recruit) {
        Random random = new Random();
        recruit.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
        recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        RecruitsPatrolSpawn.setRangedArrows(recruit);
    }

    public static RecruitEntity createPatrolLeader(ServerLevel world, BlockPos upPos, String name) {
        RecruitEntity patrolLeader = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).m_20615_((Level)world);
        patrolLeader.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        patrolLeader.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        RecruitsPatrolSpawn.setPatrolLeaderEquipment(patrolLeader);
        patrolLeader.m_21530_();
        patrolLeader.setXpLevel(1 + random.nextInt(2));
        patrolLeader.addLevelBuffsForLevel(patrolLeader.getXpLevel());
        patrolLeader.setHunger(100.0f);
        patrolLeader.setMoral(100.0f);
        patrolLeader.setCost(55);
        patrolLeader.setXp(random.nextInt(200));
        patrolLeader.m_6593_((Component)Component.m_237113_((String)name));
        patrolLeader.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        patrolLeader.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        RecruitsPatrolSpawn.setRecruitFood(patrolLeader);
        world.m_7967_((Entity)patrolLeader);
        return patrolLeader;
    }

    public static void createPatrolRecruit(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader, String name) {
        RecruitEntity recruitEntity = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).m_20615_((Level)world);
        recruitEntity.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        recruitEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        if (random.nextInt(2) == 0) {
            RecruitsPatrolSpawn.setPatrolRecruitEquipment(recruitEntity);
        }
        recruitEntity.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        recruitEntity.m_21530_();
        recruitEntity.setXpLevel(Math.max(1, random.nextInt(3)));
        recruitEntity.addLevelBuffsForLevel(recruitEntity.getXpLevel());
        recruitEntity.setHunger(80.0f);
        recruitEntity.setMoral(65.0f);
        recruitEntity.setCost(9);
        recruitEntity.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        recruitEntity.setShouldProtect(true);
        recruitEntity.setXp(random.nextInt(80));
        recruitEntity.m_6593_((Component)Component.m_237113_((String)name));
        RecruitsPatrolSpawn.setRecruitFood(recruitEntity);
        world.m_7967_((Entity)recruitEntity);
    }

    public static void createPatrolBowman(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader) {
        BowmanEntity bowman = (BowmanEntity)((EntityType)ModEntityTypes.BOWMAN.get()).m_20615_((Level)world);
        bowman.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        bowman.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        if (random.nextInt(2) == 0) {
            RecruitsPatrolSpawn.setPatrolBowmanEquipment(bowman);
        }
        bowman.m_21530_();
        bowman.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        bowman.setXpLevel(Math.max(1, random.nextInt(3)));
        bowman.addLevelBuffsForLevel(bowman.getXpLevel());
        bowman.setHunger(80.0f);
        bowman.setMoral(65.0f);
        bowman.setCost(16);
        bowman.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        bowman.setShouldProtect(true);
        bowman.setXp(random.nextInt(120));
        bowman.m_6593_((Component)Component.m_237113_((String)"Patrol"));
        RecruitsPatrolSpawn.setRecruitFood(bowman);
        world.m_7967_((Entity)bowman);
    }

    public static void createPatrolShieldman(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader, String name, boolean banner) {
        RecruitShieldmanEntity shieldmanEntity = (RecruitShieldmanEntity)((EntityType)ModEntityTypes.RECRUIT_SHIELDMAN.get()).m_20615_((Level)world);
        shieldmanEntity.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        shieldmanEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        if (random.nextInt(2) == 0) {
            RecruitsPatrolSpawn.setPatrolShieldmanEquipment(shieldmanEntity);
        }
        shieldmanEntity.m_21530_();
        shieldmanEntity.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        shieldmanEntity.setXpLevel(Math.max(1, random.nextInt(3)));
        shieldmanEntity.addLevelBuffsForLevel(shieldmanEntity.getXpLevel());
        shieldmanEntity.setHunger(80.0f);
        shieldmanEntity.setMoral(65.0f);
        shieldmanEntity.setCost(12);
        shieldmanEntity.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        shieldmanEntity.setShouldProtect(true);
        shieldmanEntity.setXp(random.nextInt(120));
        shieldmanEntity.m_6593_((Component)Component.m_237113_((String)name));
        if (banner) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42673_);
            stack.m_41764_(1);
            shieldmanEntity.m_8061_(EquipmentSlot.HEAD, stack);
        }
        RecruitsPatrolSpawn.setRecruitFood(shieldmanEntity);
        world.m_7967_((Entity)shieldmanEntity);
    }

    public static void createPatrolHorseman(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader, String name, boolean banner) {
        HorsemanEntity horseman = (HorsemanEntity)((EntityType)ModEntityTypes.HORSEMAN.get()).m_20615_((Level)world);
        horseman.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        horseman.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        if (random.nextInt(2) == 0) {
            RecruitsPatrolSpawn.setPatrolShieldmanEquipment(horseman);
        }
        horseman.m_21530_();
        horseman.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        horseman.isPatrol = true;
        horseman.setXpLevel(Math.max(1, random.nextInt(3)));
        horseman.addLevelBuffsForLevel(horseman.getXpLevel());
        horseman.setHunger(80.0f);
        horseman.setMoral(75.0f);
        horseman.setCost(30);
        horseman.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        horseman.setShouldProtect(true);
        horseman.setXp(random.nextInt(120));
        horseman.m_6593_((Component)Component.m_237113_((String)name));
        if (banner) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42673_);
            stack.m_41764_(1);
            horseman.m_8061_(EquipmentSlot.HEAD, stack);
        }
        RecruitsPatrolSpawn.setRecruitFood(horseman);
        world.m_7967_((Entity)horseman);
    }

    public static void createPatrolNomad(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader, String name) {
        NomadEntity nomad = (NomadEntity)((EntityType)ModEntityTypes.NOMAD.get()).m_20615_((Level)world);
        nomad.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        nomad.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        if (random.nextInt(2) == 0) {
            RecruitsPatrolSpawn.setPatrolBowmanEquipment(nomad);
        }
        nomad.m_21530_();
        nomad.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        nomad.isPatrol = true;
        nomad.setXpLevel(1 + random.nextInt(3));
        nomad.addLevelBuffsForLevel(nomad.getXpLevel());
        nomad.setHunger(80.0f);
        nomad.setMoral(75.0f);
        nomad.setCost(30);
        nomad.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        nomad.setShouldProtect(true);
        nomad.setXp(random.nextInt(120));
        nomad.m_6593_((Component)Component.m_237113_((String)name));
        RecruitsPatrolSpawn.setRecruitFood(nomad);
        world.m_7967_((Entity)nomad);
    }

    public static void createPatrolCrossbowman(ServerLevel world, BlockPos upPos, RecruitEntity patrolLeader) {
        CrossBowmanEntity crossBowman = (CrossBowmanEntity)((EntityType)ModEntityTypes.CROSSBOWMAN.get()).m_20615_((Level)world);
        crossBowman.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        crossBowman.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        RecruitsPatrolSpawn.setPatrolCrossbowmanEquipment(crossBowman);
        crossBowman.m_21530_();
        crossBowman.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        crossBowman.setXpLevel(Math.max(1, random.nextInt(3)));
        crossBowman.addLevelBuffsForLevel(crossBowman.getXpLevel());
        crossBowman.setHunger(80.0f);
        crossBowman.setMoral(65.0f);
        crossBowman.setCost(16);
        crossBowman.setProtectUUID(Optional.of(patrolLeader.m_20148_()));
        crossBowman.setShouldProtect(true);
        crossBowman.setXp(random.nextInt(120));
        crossBowman.m_6593_((Component)Component.m_237113_((String)"Patrol"));
        RecruitsPatrolSpawn.setRecruitFood(crossBowman);
        world.m_7967_((Entity)crossBowman);
    }

    public static void createRecruit(ServerLevel world, BlockPos upPos, AbstractLeaderEntity leader) {
        RecruitEntity recruitEntity = (RecruitEntity)((EntityType)ModEntityTypes.RECRUIT.get()).m_20615_((Level)world);
        recruitEntity.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        recruitEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        if (random.nextInt(2) == 0) {
            RecruitsPatrolSpawn.setPatrolRecruitEquipment(recruitEntity);
        }
        recruitEntity.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        recruitEntity.m_21530_();
        recruitEntity.setXpLevel(Math.max(1, random.nextInt(3)));
        recruitEntity.addLevelBuffsForLevel(recruitEntity.getXpLevel());
        recruitEntity.setHunger(80.0f);
        recruitEntity.setMoral(65.0f);
        recruitEntity.setCost(9);
        recruitEntity.setXp(random.nextInt(80));
        recruitEntity.m_6593_((Component)Component.m_237113_((String)"Recruit"));
        RecruitsPatrolSpawn.setRecruitFood(recruitEntity);
        world.m_7967_((Entity)recruitEntity);
    }

    public static PatrolLeaderEntity createCompanionPatrolLeader(BlockPos upPos, ServerLevel world) {
        PatrolLeaderEntity leader = (PatrolLeaderEntity)((EntityType)ModEntityTypes.PATROL_LEADER.get()).m_20615_((Level)world);
        leader.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        leader.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        AbstractRecruitEntity.applySpawnValues(leader);
        RecruitsPatrolSpawn.setPatrolLeaderEquipment(leader);
        leader.setXpLevel(Math.max(1, random.nextInt(4)));
        leader.despawnTimer = (Integer)RecruitsServerConfig.RecruitPatrolDespawnTime.get() * 20 * 60;
        RecruitsPatrolSpawn.setRecruitFood(leader);
        leader.addLevelBuffsForLevel(leader.getXpLevel());
        leader.setHunger(80.0f);
        leader.setMoral(65.0f);
        leader.setCost(50);
        leader.setXp(random.nextInt(120));
        leader.setState(1);
        leader.m_6593_((Component)Component.m_237113_((String)"Patrol Leader"));
        return leader;
    }

    public static void spawnPatrol(BlockPos upPos, ServerLevel world) {
        PatrolLeaderEntity leader = RecruitsPatrolSpawn.createCompanionPatrolLeader(upPos, world);
        RecruitsPatrolSpawn.createRecruit(world, upPos, leader);
        RecruitsPatrolSpawn.createRecruit(world, upPos, leader);
        RecruitsPatrolSpawn.createRecruit(world, upPos, leader);
        RecruitsPatrolSpawn.createRecruit(world, upPos, leader);
        RecruitsPatrolSpawn.createRecruit(world, upPos, leader);
        world.m_7967_((Entity)leader);
    }

    public static void setPatrolLeaderEquipment(PatrolLeaderEntity recruit) {
        Random random = new Random();
        recruit.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        recruit.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        recruit.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        recruit.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
        int j = random.nextInt(16);
        ItemStack item = new ItemStack((ItemLike)Items.f_42616_);
        item.m_41764_(8 + j);
        recruit.inventory.m_6836_(8, item);
        int i = random.nextInt(8);
        if (i == 1) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        } else if (i == 2 || i == 3) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42433_));
        } else if (i == 4 || i == 5) {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
        } else {
            recruit.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        }
    }
}

