/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.world.RecruitsTeam;
import com.talhanation.recruits.world.RecruitsTeamSaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;

public class RecruitsTeamManager {
    private final Map<String, RecruitsTeam> teams = new HashMap<String, RecruitsTeam>();

    public void load(ServerLevel level) {
        RecruitsTeamSaveData data = RecruitsTeamSaveData.get(level);
        this.teams.clear();
        this.teams.putAll(data.getTeams());
        this.teams.values().forEach(this::loadConfig);
    }

    public void loadConfig(RecruitsTeam team) {
        team.maxPlayers = (Integer)RecruitsServerConfig.MaxPlayersInFaction.get();
        team.maxNPCs = (Integer)RecruitsServerConfig.MaxNPCsInFaction.get();
    }

    public void save(ServerLevel level) {
        RecruitsTeamSaveData data = RecruitsTeamSaveData.get(level);
        data.setTeams(this.teams);
        data.m_77762_();
    }

    public Collection<RecruitsTeam> getTeams() {
        return this.teams.values();
    }

    @Nullable
    public RecruitsTeam getTeamByStringID(String stringID) {
        return this.teams.get(stringID);
    }

    public List<ServerPlayer> getPlayersInTeam(String stringID, ServerLevel level) {
        ServerScoreboard scoreboard = level.m_6188_();
        PlayerTeam playerTeam = scoreboard.m_83489_(stringID);
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        if (playerTeam != null) {
            for (ServerPlayer p : level.m_6907_()) {
                if (!playerTeam.m_6809_().contains(p.m_7755_().getString())) continue;
                list.add(p);
            }
        }
        return list;
    }

    @Nullable
    public ServerPlayer getTeamLeader(RecruitsTeam recruitsTeam, ServerLevel level) {
        for (ServerPlayer p : level.m_6907_()) {
            if (!p.m_20148_().equals(recruitsTeam.getTeamLeaderUUID())) continue;
            return p;
        }
        return null;
    }

    public void addTeam(String teamName, UUID leaderUUID, String leaderName, CompoundTag bannerNbt, byte color, ChatFormatting teamColor) {
        RecruitsTeam recruitsTeam = new RecruitsTeam();
        recruitsTeam.setStringID(teamName);
        recruitsTeam.setTeamDisplayName(teamName);
        recruitsTeam.setTeamLeaderID(leaderUUID);
        recruitsTeam.setTeamLeaderName(leaderName);
        recruitsTeam.setBanner(bannerNbt);
        recruitsTeam.setUnitColor(color);
        recruitsTeam.setTeamColor(teamColor.m_126656_());
        recruitsTeam.setMaxNPCsPerPlayer((Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get());
        recruitsTeam.setMaxPlayers((Integer)RecruitsServerConfig.MaxPlayersInFaction.get());
        recruitsTeam.setMaxNPCs((Integer)RecruitsServerConfig.MaxNPCsInFaction.get());
        this.teams.put(teamName, recruitsTeam);
    }

    public void removeTeam(String teamName) {
        this.teams.remove(teamName);
    }

    public boolean isNameInUse(String teamName) {
        List<RecruitsTeam> list = this.getTeams().stream().toList();
        boolean equ = false;
        for (RecruitsTeam recruitsTeam : list) {
            equ = recruitsTeam.getStringID().toLowerCase().strip().equals(teamName.toLowerCase());
        }
        return equ;
    }

    public boolean isBannerInUse(CompoundTag bannerNbt) {
        Iterator<RecruitsTeam> iterator;
        if (bannerNbt != null && (iterator = this.getTeams().iterator()).hasNext()) {
            RecruitsTeam recruitsTeam = iterator.next();
            return bannerNbt.equals((Object)recruitsTeam.getBanner());
        }
        return false;
    }

    public static boolean isBannerBlank(ItemStack itemStack) {
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)itemStack);
        return compoundtag == null || !compoundtag.m_128441_("Patterns");
    }

    public boolean canPlayerJoin(RecruitsTeam recruitsTeam) {
        int config = (Integer)RecruitsServerConfig.MaxPlayersInFaction.get();
        if (config == 0) {
            return true;
        }
        return config <= recruitsTeam.getPlayers();
    }

    public boolean canRecruitJoin(RecruitsTeam recruitsTeam) {
        int config = (Integer)RecruitsServerConfig.MaxPlayersInFaction.get();
        if (config == 0) {
            return true;
        }
        return (Integer)RecruitsServerConfig.MaxNPCsInFaction.get() < recruitsTeam.getNPCs();
    }
}

