/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureBlock;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends FurnitureBlock
implements BlockTagSupplier {
    private final WoodType type;

    public TableBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape topNorthEdgeShape = Block.m_49796_((double)0.0, (double)14.0, (double)-1.0, (double)16.0, (double)16.0, (double)0.0);
        VoxelShape topEastEdgeShape = Block.m_49796_((double)16.0, (double)14.0, (double)0.0, (double)17.0, (double)16.0, (double)16.0);
        VoxelShape topSouthEdgeShape = Block.m_49796_((double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0, (double)17.0);
        VoxelShape topWestEdgeShape = Block.m_49796_((double)-1.0, (double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0);
        VoxelShape northWestTopCornerShape = Block.m_49796_((double)-1.0, (double)14.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0);
        VoxelShape northEastTopCornerShape = Block.m_49796_((double)16.0, (double)14.0, (double)-1.0, (double)17.0, (double)16.0, (double)0.0);
        VoxelShape southWestTopCornerShape = Block.m_49796_((double)-1.0, (double)14.0, (double)16.0, (double)0.0, (double)16.0, (double)17.0);
        VoxelShape southEastTopCornerShape = Block.m_49796_((double)16.0, (double)14.0, (double)16.0, (double)17.0, (double)16.0, (double)17.0);
        VoxelShape northWestLegShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0);
        VoxelShape northEastLegShape = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
        VoxelShape southWestLegShape = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0);
        VoxelShape southEastLegShape = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.m_61143_((Property)NORTH);
            boolean east = (Boolean)state.m_61143_((Property)EAST);
            boolean south = (Boolean)state.m_61143_((Property)SOUTH);
            boolean west = (Boolean)state.m_61143_((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            if (!north) {
                shapes.add(topNorthEdgeShape);
                if (!east) {
                    shapes.add(northEastTopCornerShape);
                    shapes.add(northEastLegShape);
                }
                if (!west) {
                    shapes.add(northWestTopCornerShape);
                    shapes.add(northWestLegShape);
                }
            }
            if (!east) {
                shapes.add(topEastEdgeShape);
            }
            if (!south) {
                shapes.add(topSouthEdgeShape);
                if (!east) {
                    shapes.add(southEastTopCornerShape);
                    shapes.add(southEastLegShape);
                }
                if (!west) {
                    shapes.add(southWestTopCornerShape);
                    shapes.add(southWestLegShape);
                }
            }
            if (!west) {
                shapes.add(topWestEdgeShape);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapes.get(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = level.m_8055_(pos.m_122012_()).m_60734_() instanceof TableBlock;
        boolean east = level.m_8055_(pos.m_122029_()).m_60734_() instanceof TableBlock;
        boolean south = level.m_8055_(pos.m_122019_()).m_60734_() instanceof TableBlock;
        boolean west = level.m_8055_(pos.m_122024_()).m_60734_() instanceof TableBlock;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{WEST});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_, ModTags.Blocks.TUCKABLE);
    }
}

