/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;

public class BlockItemRGB16
extends BlockItem
implements IColored,
IRGB16_Item {
    private final short startColor;
    private int[] tintedIndexes;

    public BlockItemRGB16(Block block, Item.Properties properties, DyeColor color) {
        this(block, properties, RGB16Helper.getIndexFor(color));
    }

    public BlockItemRGB16(Block block, Item.Properties properties, RGB16 rgb16) {
        this(block, properties, rgb16.getIndex());
    }

    public BlockItemRGB16(Block block, Item.Properties properties, short index) {
        super(block, properties);
        this.startColor = index;
    }

    public BlockItemRGB16 callback(Consumer<BlockItemRGB16> consumer) {
        consumer.accept(this);
        return this;
    }

    public BlockItemRGB16 tint(int ... indexes) {
        this.tintedIndexes = indexes;
        return this;
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        if (RGB16StackHelper.getRGB16(stack) == null) {
            RGB16StackHelper.setRGB16(stack, this.getStartingIndex(stack));
        }
    }

    @Override
    public short getRGB16(ItemStack stack) {
        return RGB16StackHelper.readColorTag(stack, this.startColor);
    }

    @Override
    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags(stack, rgbIndex);
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.m_41619_() && (this.tintedIndexes == null || Arrays.stream(this.tintedIndexes).anyMatch(value -> value == index))) {
            return RGB16Helper.getColor(this.getRGB16(data.stack));
        }
        return 0xFFFFFF;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        tooltip.add((Component)Component.m_237113_((String)RGB16Helper.getTooltip(this.getRGB16(stack))));
        super.m_7373_(stack, world, tooltip, advancedTooltips);
    }

    @Override
    public short getStartingIndex(ItemStack stack) {
        return this.startColor;
    }

    @Override
    public boolean enableDyeRecipe(ItemStack stack) {
        return true;
    }

    @Override
    public boolean dyeUseChance(ItemStack stack) {
        return true;
    }

    @Override
    public double getDyeUseChance(ItemStack result, ItemStack dye, int dyeCounter) {
        if (result.m_41720_() == this && RGB16StackHelper.getRGB16Index(result) == this.getStartingIndex(result)) {
            return 1.0;
        }
        return Math.max(0.0, 1.0 - 0.15 * (double)dyeCounter);
    }
}

