/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.container.PlaneInventoryContainer;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.datapack.PlanePayloadReloadListener;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.network.CargoUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.network.NewCargoUpgradePacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.payload.PayloadUpgrade;

public class CargoPlaneEntity
extends PlaneEntity {
    public List<LargeUpgrade> largeUpgrades = new ArrayList<LargeUpgrade>(8);

    public CargoPlaneEntity(EntityType<? extends CargoPlaneEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        for (Entity entity : list) {
            if (this.m_9236_().f_46443_ || this.m_6688_() instanceof Player || entity.m_20363_((Entity)this) || entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.m_20329_((Entity)this);
        }
    }

    @Override
    protected boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (this.largeUpgrades.size() < 8) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.m_41720_());
            if (upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)upgradeType)) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
                return true;
            }
            PayloadEntry payloadEntry = PlanePayloadReloadListener.payloadEntries.get(itemStack.m_41720_());
            if (payloadEntry != null) {
                this.addUpgrade(playerEntity, itemStack, new PayloadUpgrade(this, payloadEntry));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        return upgradeType != SimplePlanesUpgrades.JUKEBOX.get() && upgradeType != SimplePlanesUpgrades.SHOOTER.get() && super.canAddUpgrade(upgradeType);
    }

    @Override
    protected void addUpgrade(Player playerEntity, ItemStack itemStack, Upgrade upgrade) {
        if (!this.m_9236_().f_46443_) {
            upgrade.onApply(itemStack);
            if (!playerEntity.m_7500_()) {
                itemStack.m_41774_(1);
            }
            UpgradeType upgradeType = upgrade.getType();
            if (upgrade instanceof LargeUpgrade) {
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                this.largeUpgrades.add(largeUpgrade);
                SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new NewCargoUpgradePacket(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)upgradeType), this.m_19879_(), upgrade));
            } else {
                this.upgrades.put(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)upgradeType), upgrade);
                if (upgradeType.isEngine) {
                    this.engineUpgrade = (EngineUpgrade)upgrade;
                }
                SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)upgradeType), this.m_19879_(), (ServerLevel)this.m_9236_(), true));
            }
        }
    }

    public void addCargoUpgradeIntWorkbench(ItemStack itemStack, LargeUpgrade largeUpgrade) {
        largeUpgrade.onApply(itemStack);
        this.largeUpgrades.add(largeUpgrade);
        SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new NewCargoUpgradePacket(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)largeUpgrade.getType()), this.m_19879_(), largeUpgrade));
    }

    public void readNewCargoUpgradePacket(ResourceLocation upgradeID, FriendlyByteBuf packetBuffer) {
        UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.get().getValue(upgradeID);
        Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
        if (upgrade instanceof LargeUpgrade) {
            LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
            this.largeUpgrades.add(largeUpgrade);
        }
        upgrade.readPacket(packetBuffer);
    }

    @Override
    public void dropPayload() {
        for (LargeUpgrade upgrade : this.largeUpgrades) {
            if (!upgrade.canBeDroppedAsPayload()) continue;
            upgrade.dropAsPayload();
            if (upgrade.removed) {
                this.largeUpgrades.remove((Object)upgrade);
            }
            if (!this.m_9236_().f_46443_) break;
            SimplePlanesNetworking.INSTANCE.sendToServer((Object)new DropPayloadPacket());
            break;
        }
    }

    public void removeCargoUpgrade(int index) {
        LargeUpgrade upgrade = this.largeUpgrades.remove(index);
        upgrade.onRemoved();
        upgrade.removed = true;
        if (!this.m_9236_().f_46443_) {
            SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new CargoUpgradeRemovedPacket((byte)index, this.m_19879_()));
        }
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.CARGO_PLANE_ITEM.get();
    }

    @Override
    protected float getGroundPitch() {
        return 0.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.CARGO_PLANE_FUEL_COST.get();
    }

    @Override
    protected boolean m_7310_(Entity passenger) {
        List passengers = this.m_20197_();
        if (!this.upgrades.containsKey(SimplePlanesUpgrades.SEATS.getId())) {
            return passengers.size() < 2;
        }
        return passengers.size() < 6;
    }

    @Override
    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.m_20197_().indexOf(passenger);
        Vector3f pos = switch (index) {
            case 0 -> this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()) + 1.0f, 1.5f));
            case 1 -> this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()) + 1.0f - 0.125f, -12.0f));
            case 2 -> this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()) + 1.0f - 0.625f, 2.875f));
            case 3 -> this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()) + 1.0f - 0.625f, 3.75f));
            case 4 -> this.transformPos(new Vector3f(0.6f, (float)(this.m_6048_() + passenger.m_6049_()) + 1.0f - 0.625f, -6.25f));
            default -> this.transformPos(new Vector3f(-0.6f, (float)(this.m_6048_() + passenger.m_6049_()) + 1.0f - 0.625f, -6.25f));
        };
        moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.CARGO_PLANE_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    @Override
    protected float getRotationSpeedMultiplier() {
        return 0.2f;
    }

    @Override
    public void openContainer(ServerPlayer player, int containerID) {
        if (containerID == 0) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inventory, playerIn) -> new PlaneInventoryContainer(id, inventory, this), this.m_7755_()), buffer -> buffer.m_130130_(this.m_19879_()));
        } else {
            int id2 = 0;
            for (LargeUpgrade upgrade : this.largeUpgrades) {
                if (!upgrade.hasStorage() || containerID != ++id2) continue;
                upgrade.openStorageGui(player, id2);
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("large_upgrades")) {
            ListTag listTag = compound.m_128437_("large_upgrades", 10);
            this.largeUpgrades.clear();
            for (int i = 0; i < listTag.size(); ++i) {
                Upgrade upgrade;
                CompoundTag compoundTag = listTag.m_128728_(i);
                UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.get().getValue(new ResourceLocation(compoundTag.m_128461_("id")));
                if (upgradeType == null || !((upgrade = upgradeType.instanceSupplier.apply(this)) instanceof LargeUpgrade)) continue;
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                largeUpgrade.deserializeNBT(compoundTag.m_128469_("nbt"));
                this.largeUpgrades.add(largeUpgrade);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ListTag listTag = new ListTag();
        for (LargeUpgrade upgrade : this.largeUpgrades) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)upgrade.getType()).toString());
            compoundTag.m_128365_("nbt", (Tag)upgrade.serializeNBT());
            listTag.add((Object)compoundTag);
        }
        compound.m_128365_("large_upgrades", (Tag)listTag);
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.m_130130_(this.largeUpgrades.size());
        for (LargeUpgrade upgrade : this.largeUpgrades) {
            ResourceLocation upgradeID = SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((Object)upgrade.getType());
            buffer.m_130085_(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    @Override
    public void readSpawnData(FriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        int largeUpgradesSize = additionalData.m_130242_();
        for (int i = 0; i < largeUpgradesSize; ++i) {
            ResourceLocation upgradeID = additionalData.m_130281_();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.get().getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.largeUpgrades.add((LargeUpgrade)upgrade);
            upgrade.readPacket(additionalData);
        }
    }
}

