/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Medium;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import com.codinglitch.simpleradio.radio.RouterContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class Frequency
implements Medium {
    private static final List<Frequency> frequencies = new ArrayList<Frequency>();
    public static String DEFAULT_FREQUENCY;
    public static Modulation DEFAULT_MODULATION;
    public static int FREQUENCY_DIGITS;
    public static int MAX_FREQUENCY;
    public static String FREQUENCY_PATTERN;
    public boolean isValid = true;
    public final Modulation modulation;
    public final String frequency;
    public final RouterContainer<RadioReceiver> receivers;
    public final RouterContainer<RadioTransmitter> transmitters;

    public Frequency(String frequency, Modulation modulation) {
        if (!Frequency.check(frequency)) {
            CommonSimpleRadio.warn("{} does not follow frequency pattern! Replacing with default pattern {}", frequency, DEFAULT_FREQUENCY);
            frequency = DEFAULT_FREQUENCY;
        }
        this.frequency = frequency;
        this.modulation = modulation;
        this.receivers = new RouterContainer();
        this.transmitters = new RouterContainer();
        frequencies.add(this);
    }

    public static Frequency tryParse(String string) {
        Modulation modulation = Frequency.modulationOf(string.substring(string.length() - 2));
        return Frequency.getOrCreateFrequency(string.substring(0, string.length() - 2), modulation);
    }

    public static void onLexiconRevision() {
        FREQUENCY_DIGITS = SimpleRadioLibrary.SERVER_CONFIG.frequency.wholePlaces + SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces;
        MAX_FREQUENCY = (int)java.lang.Math.pow(10.0, FREQUENCY_DIGITS);
        FREQUENCY_PATTERN = "^\\d{" + SimpleRadioLibrary.SERVER_CONFIG.frequency.wholePlaces + "}.\\d{" + SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces + "}$";
        DEFAULT_FREQUENCY = SimpleRadioLibrary.SERVER_CONFIG.frequency.defaultFrequency.equals("auto-generate") ? "0".repeat(SimpleRadioLibrary.SERVER_CONFIG.frequency.wholePlaces) + "." + "0".repeat(SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces) : SimpleRadioLibrary.SERVER_CONFIG.frequency.defaultFrequency;
    }

    public static void garbageCollect() {
        for (Frequency frequency : frequencies) {
            RadioManager.validate(frequency.receivers);
            RadioManager.validate(frequency.transmitters);
        }
        frequencies.removeIf(Predicate.not(Frequency::validate));
    }

    public static void close() {
        frequencies.clear();
    }

    @Nullable
    public static Modulation modulationOf(String shorthand) {
        for (Modulation modulation : Modulation.values()) {
            if (!modulation.shorthand.equals(shorthand)) continue;
            return modulation;
        }
        return null;
    }

    public static boolean check(String frequency) {
        return frequency.matches(FREQUENCY_PATTERN);
    }

    public static String incrementFrequency(String frequency, int amount) {
        int rawFrequency = Integer.parseInt(frequency.replaceAll("[.]", ""));
        String str = String.format("%0" + FREQUENCY_DIGITS + "d", Math.clamp((int)0, (int)(MAX_FREQUENCY - 1), (int)(rawFrequency + amount)));
        return new StringBuilder(str).insert(str.length() - SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces, ".").toString();
    }

    public static List<Frequency> getFrequencies() {
        return frequencies;
    }

    public static int getFrequencyIndex(String string, Modulation modulation) {
        for (int i = 0; i < frequencies.size(); ++i) {
            Frequency frequency = frequencies.get(i);
            if (!frequency.frequency.equals(string) || !frequency.modulation.equals((Object)modulation)) continue;
            return i;
        }
        return -1;
    }

    public static Frequency getFrequency(String string, Modulation modulation) {
        for (Frequency frequency : frequencies) {
            if (!frequency.frequency.equals(string) || !frequency.modulation.equals((Object)modulation)) continue;
            return frequency;
        }
        return null;
    }

    public RadioReceiver getReceiver(Predicate<RadioReceiver> filter) {
        Optional<RadioReceiver> result = this.receivers.stream().filter(filter).findFirst();
        return result.orElse(null);
    }

    public RadioReceiver getReceiver(WorldlyPosition location) {
        return this.getReceiver((RadioReceiver receiver) -> location.equals(receiver.location));
    }

    public RadioReceiver getReceiver(Entity owner) {
        return this.getReceiver((RadioReceiver receiver) -> owner.equals((Object)receiver.owner));
    }

    public RadioReceiver getReceiver(UUID id) {
        return this.getReceiver((RadioReceiver receiver) -> id.equals(receiver.reference));
    }

    public void registerReceiver(RadioReceiver receiver) {
        RadioManager.putRouter(this.receivers, receiver);
    }

    public RadioReceiver addReceiver(RadioReceiver receiver) {
        boolean isClient = false;
        if (receiver.location != null) {
            isClient = receiver.location.isClientSide();
        } else if (receiver.owner != null) {
            isClient = receiver.owner.m_9236_().f_46443_;
        }
        RadioManager.registerRouterSided(receiver, isClient, this);
        CommonSimpleRadio.debug("Added receiver {} to frequency {}", receiver.reference, this.frequency);
        return receiver;
    }

    public RadioReceiver tryAddReceiver(UUID id, WorldlyPosition location) {
        boolean isClient = location.isClientSide();
        RadioReceiver receiver = null;
        if (receiver == null) {
            RadioReceiver radioReceiver = receiver = isClient ? ClientRadioManager.getReceiver(id) : this.getReceiver(id);
        }
        if (receiver == null) {
            return this.addReceiver(id, location);
        }
        return receiver;
    }

    public RadioReceiver addReceiver(UUID id, WorldlyPosition location) {
        return this.addReceiver(new RadioReceiver(this, location, id));
    }

    public RadioReceiver tryAddReceiver(UUID id, Entity entity) {
        boolean isClient = entity.m_9236_().f_46443_;
        RadioReceiver receiver = null;
        if (receiver == null) {
            RadioReceiver radioReceiver = receiver = isClient ? ClientRadioManager.getReceiver(id) : this.getReceiver(id);
        }
        if (receiver == null) {
            return this.addReceiver(id, entity);
        }
        return receiver;
    }

    public RadioReceiver addReceiver(UUID id, Entity entity) {
        return this.addReceiver(new RadioReceiver(this, entity, id));
    }

    public void removeReceiver(Predicate<RadioReceiver> criteria) {
        this.receivers.removeIf(criteria);
        if (!this.validate()) {
            frequencies.remove(this);
        }
    }

    public void removeReceiver(RadioReceiver receiver) {
        this.removeReceiver(receiver::equals);
    }

    public void removeReceiver(Entity owner) {
        this.removeReceiver((RadioReceiver receiver) -> owner.equals((Object)receiver.owner));
    }

    public void removeReceiver(WorldlyPosition location) {
        this.removeReceiver((RadioReceiver receiver) -> location.equals(receiver.location));
    }

    public void removeReceiver(UUID id) {
        this.removeReceiver((RadioReceiver receiver) -> id.equals(receiver.reference));
    }

    public RadioTransmitter getTransmitter(Predicate<RadioTransmitter> filter) {
        Optional<RadioTransmitter> result = this.transmitters.stream().filter(filter).findFirst();
        return result.orElse(null);
    }

    public RadioTransmitter getTransmitter(WorldlyPosition location) {
        return this.getTransmitter((RadioTransmitter transmitter) -> location.equals(transmitter.location));
    }

    public RadioTransmitter getTransmitter(Entity owner) {
        return this.getTransmitter((RadioTransmitter transmitter) -> owner.equals((Object)transmitter.owner));
    }

    public RadioTransmitter getTransmitter(UUID id) {
        return this.getTransmitter((RadioTransmitter transmitter) -> id.equals(transmitter.reference));
    }

    public void registerTransmitter(RadioTransmitter transmitter) {
        RadioManager.putRouter(this.transmitters, transmitter);
    }

    public RadioTransmitter addTransmitter(RadioTransmitter transmitter) {
        boolean isClient = false;
        if (transmitter.location != null) {
            isClient = transmitter.location.isClientSide();
        } else if (transmitter.owner != null) {
            isClient = transmitter.owner.m_9236_().f_46443_;
        }
        RadioManager.registerRouterSided(transmitter, isClient, this);
        CommonSimpleRadio.debug("Added transmitter {} to frequency {}", transmitter.reference, this.frequency);
        return transmitter;
    }

    public RadioTransmitter tryAddTransmitter(UUID id, WorldlyPosition location) {
        boolean isClient = location.isClientSide();
        RadioTransmitter transmitter = null;
        if (transmitter == null) {
            RadioTransmitter radioTransmitter = transmitter = isClient ? ClientRadioManager.getTransmitter(id) : this.getTransmitter(id);
        }
        if (transmitter == null) {
            return this.addTransmitter(id, location);
        }
        return transmitter;
    }

    public RadioTransmitter addTransmitter(UUID id, WorldlyPosition location) {
        return this.addTransmitter(new RadioTransmitter(this, location, id));
    }

    public RadioTransmitter tryAddTransmitter(UUID id, Entity entity) {
        boolean isClient = entity.m_9236_().f_46443_;
        RadioTransmitter transmitter = null;
        if (transmitter == null) {
            RadioTransmitter radioTransmitter = transmitter = isClient ? ClientRadioManager.getTransmitter(id) : this.getTransmitter(id);
        }
        if (transmitter == null) {
            return this.addTransmitter(id, entity);
        }
        return transmitter;
    }

    public RadioTransmitter addTransmitter(UUID id, Entity entity) {
        return this.addTransmitter(new RadioTransmitter(this, entity, id));
    }

    public void removeTransmitter(Predicate<RadioTransmitter> criteria) {
        this.transmitters.removeIf(criteria);
        if (!this.validate()) {
            frequencies.remove(this);
        }
    }

    public void removeTransmitter(RadioTransmitter transmitter) {
        this.removeTransmitter(transmitter::equals);
    }

    public void removeTransmitter(Entity owner) {
        this.removeTransmitter((RadioTransmitter transmitter) -> owner.equals((Object)transmitter.owner));
    }

    public void removeTransmitter(WorldlyPosition location) {
        this.removeTransmitter((RadioTransmitter transmitter) -> location.equals(transmitter.location));
    }

    public void removeTransmitter(UUID id) {
        this.removeTransmitter((RadioTransmitter transmitter) -> id.equals(transmitter.reference));
    }

    public void serverTick(int tickCount) {
        for (RadioTransmitter transmitter : this.transmitters) {
            transmitter.tick(tickCount);
        }
        for (RadioReceiver receiver : this.receivers) {
            receiver.tick(tickCount);
        }
    }

    public boolean validate() {
        if (this.receivers.isEmpty() && this.transmitters.isEmpty()) {
            this.invalidate();
            return false;
        }
        return true;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public Frequency revalidate() {
        return Frequency.getFrequency(this.frequency, this.modulation);
    }

    public static Frequency getOrCreateFrequency(String frequency, Modulation modulation) {
        Frequency found;
        if (frequency.isEmpty()) {
            frequency = DEFAULT_FREQUENCY;
        }
        if (modulation == null) {
            modulation = DEFAULT_MODULATION;
        }
        if ((found = Frequency.getFrequency(frequency, modulation)) != null) {
            return found;
        }
        return new Frequency(frequency, modulation);
    }

    @Nullable
    public static Frequency fromTag(CompoundTag tag) {
        if (!tag.m_128441_("frequency") || !tag.m_128441_("modulation")) {
            return null;
        }
        Modulation modulation = Frequency.modulationOf(tag.m_128461_("modulation"));
        if (modulation == null) {
            return null;
        }
        return Frequency.getOrCreateFrequency(tag.m_128461_("frequency"), modulation);
    }

    public String toString() {
        return this.frequency + this.modulation.shorthand;
    }

    static {
        DEFAULT_MODULATION = Modulation.FREQUENCY;
    }

    public static enum Modulation {
        FREQUENCY("FM"),
        AMPLITUDE("AM");

        public final String shorthand;

        private Modulation(String shorthand) {
            this.shorthand = shorthand;
        }
    }
}

