/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.CompatCore;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.SimpleRadioApi;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import com.codinglitch.simpleradio.radio.RouterContainer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RadioManager
implements SimpleRadioApi {
    private static RadioManager INSTANCE;
    private static final ArrayList<QueuedSource> pendingSources;
    private static final ArrayList<QueuedSource> sourceQueue;
    private static final Map<UUID, Vector3f> playerVelocities;
    private static final Queue<Runnable> pendingModifications;
    private static final RouterContainer<RadioSpeaker> speakers;
    private static final RouterContainer<RadioListener> listeners;
    static final Map<Short, RadioRouter> routers;

    public static RadioManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RadioManager();
        }
        return INSTANCE;
    }

    public static <R extends RadioRouter> void putRouter(@Nullable RouterContainer<R> container, R router) {
        if (container != null) {
            container.add(router);
        } else {
            RadioManager.pushRouter(router);
        }
    }

    public static short pushRouter(RadioRouter router) {
        return RadioManager.pushRouter(routers, router);
    }

    public static short pushRouter(Map<Short, RadioRouter> map, RadioRouter router) {
        for (short identifier = Short.MIN_VALUE; identifier < Short.MAX_VALUE; identifier = (short)(identifier + 1)) {
            if (map.containsKey(identifier)) continue;
            router.identifier = identifier;
            map.put(identifier, router);
            return identifier;
        }
        return Short.MAX_VALUE;
    }

    public static short getIdentifier(Predicate<RadioRouter> filter) {
        Optional<Map.Entry> result = routers.entrySet().stream().filter(entry -> filter.test((RadioRouter)entry.getValue())).findFirst();
        return result.map(Map.Entry::getKey).orElse((short)Short.MAX_VALUE);
    }

    public static List<RadioRouter> getRouters() {
        return routers.values().stream().toList();
    }

    public static void removeRouter(RadioRouter router) {
        RadioManager.removeRouter(router::equals);
    }

    public static void removeRouter(Predicate<RadioRouter> criteria) {
        routers.entrySet().removeIf(entry -> criteria.test((RadioRouter)entry.getValue()));
    }

    public static void removeRouter(short identifier) {
        routers.remove(identifier);
    }

    public static void removeRouter(UUID uuid) {
        RadioManager.removeRouter((RadioRouter router) -> router.reference.equals(uuid));
    }

    public static void removeRouter(Entity owner) {
        RadioManager.removeRouter((RadioRouter router) -> router.owner == owner);
    }

    public static void removeRouter(WorldlyPosition location) {
        RadioManager.removeRouter((RadioRouter router) -> router.location != null && router.location.equals(location));
    }

    public static RadioRouter getRouter(Predicate<RadioRouter> filter) {
        Optional<Map.Entry> result = routers.entrySet().stream().filter(entry -> filter.test((RadioRouter)entry.getValue())).findFirst();
        return result.map(Map.Entry::getValue).orElse(null);
    }

    public static RadioRouter getRouter(short identifier) {
        return routers.get(identifier);
    }

    public static RadioRouter getRouter(UUID reference, @Nullable String type) {
        return RadioManager.getRouter((RadioRouter router) -> router.reference.equals(reference) && (type == null ? router.getClass().equals(RadioRouter.class) : router.getClass().getSimpleName().equals(type)));
    }

    public static RadioRouter getRouter(UUID reference) {
        return RadioManager.getRouter((RadioRouter router) -> router.reference.equals(reference));
    }

    public static RadioRouter getRouter(Entity owner) {
        return RadioManager.getRouter((RadioRouter router) -> owner.equals((Object)router.owner));
    }

    public static RadioRouter getRouter(WorldlyPosition location) {
        return RadioManager.getRouter((RadioRouter router) -> location.equals(router.location));
    }

    public static void registerRouter(RadioRouter router) {
        RadioManager.putRouter(null, router);
    }

    public static RadioRouter getRouterSided(UUID reference, boolean isClient) {
        return isClient ? ClientRadioManager.getRouter(reference) : RadioManager.getRouter(reference);
    }

    public static RadioRouter getRouterSided(UUID reference, @Nullable String type, boolean isClient) {
        return isClient ? ClientRadioManager.getRouter(reference, type) : RadioManager.getRouter(reference, type);
    }

    public static void registerRouterSided(RadioRouter router, boolean isClient, @Nullable Frequency frequency) {
        CommonSimpleRadio.debug("Adding {} of reference {}", router.getClass().getSimpleName(), router.reference);
        if (isClient) {
            ClientRadioManager.registerRouter(router);
        } else if (router instanceof RadioSpeaker) {
            RadioSpeaker speaker = (RadioSpeaker)router;
            RadioManager.registerSpeaker(speaker);
        } else if (router instanceof RadioListener) {
            RadioListener listener = (RadioListener)router;
            RadioManager.registerListener(listener);
        } else if (router instanceof RadioReceiver) {
            RadioReceiver receiver = (RadioReceiver)router;
            if (frequency != null) {
                frequency.registerReceiver(receiver);
            }
        } else if (router instanceof RadioTransmitter) {
            RadioTransmitter transmitter = (RadioTransmitter)router;
            if (frequency != null) {
                frequency.registerTransmitter(transmitter);
            }
        } else {
            RadioManager.registerRouter(router);
        }
    }

    public static void removeRouterSided(UUID uuid, boolean isClient) {
        if (isClient) {
            ClientRadioManager.removeRouter(uuid);
        } else {
            RadioManager.removeRouter(uuid);
        }
    }

    public static void removeRouterSided(RadioRouter router, boolean isClient) {
        if (isClient) {
            ClientRadioManager.removeRouter(router);
        } else {
            RadioManager.removeRouter(router);
        }
    }

    public static List<RadioSpeaker> getSpeakers() {
        return speakers.stream().toList();
    }

    public static void removeSpeaker(RadioSpeaker speaker) {
        RadioManager.removeSpeaker(speaker::equals);
    }

    public static void removeSpeaker(Predicate<RadioSpeaker> criteria) {
        speakers.removeIf(criteria);
    }

    public static void removeSpeaker(short identifier) {
        speakers.remove(identifier);
    }

    public static void removeSpeaker(Entity owner) {
        RadioManager.removeSpeaker((RadioSpeaker speaker) -> owner.equals((Object)speaker.owner));
    }

    public static void removeSpeaker(WorldlyPosition location) {
        RadioManager.removeSpeaker((RadioSpeaker speaker) -> location.equals(speaker.location));
    }

    public static void removeSpeaker(UUID id) {
        RadioManager.removeSpeaker((RadioSpeaker speaker) -> id.equals(speaker.reference));
    }

    public static RadioSpeaker getSpeaker(Entity owner) {
        return RadioManager.getSpeaker((RadioSpeaker speaker) -> owner.equals((Object)speaker.owner));
    }

    public static RadioSpeaker getSpeaker(WorldlyPosition location) {
        return RadioManager.getSpeaker((RadioSpeaker speaker) -> location.equals(speaker.location));
    }

    public static RadioSpeaker getSpeaker(UUID id) {
        return RadioManager.getSpeaker((RadioSpeaker speaker) -> id.equals(speaker.reference));
    }

    public static RadioSpeaker getSpeaker(Predicate<RadioSpeaker> filter) {
        Optional<RadioSpeaker> result = speakers.stream().filter(filter).findFirst();
        return result.orElse(null);
    }

    public static RadioSpeaker getOrCreateSpeaker(Entity owner, @Nullable UUID id) {
        boolean isClient = owner.m_9236_().f_46443_;
        RadioSpeaker speaker = null;
        if (speaker == null) {
            speaker = isClient ? ClientRadioManager.getSpeaker(id) : RadioManager.getSpeaker(id);
        }
        return speaker != null ? speaker : new RadioSpeaker(owner, id);
    }

    public static RadioSpeaker getOrCreateSpeaker(Entity owner) {
        return RadioManager.getOrCreateSpeaker(owner, null);
    }

    public static RadioSpeaker getOrCreateSpeaker(WorldlyPosition location, @Nullable UUID id) {
        boolean isClient = location.level.f_46443_;
        RadioSpeaker speaker = null;
        if (speaker == null) {
            speaker = isClient ? ClientRadioManager.getSpeaker(id) : RadioManager.getSpeaker(id);
        }
        return speaker != null ? speaker : new RadioSpeaker(location, id);
    }

    public static RadioSpeaker getOrCreateSpeaker(WorldlyPosition location) {
        return RadioManager.getOrCreateSpeaker(location, null);
    }

    public static RadioSpeaker registerSpeaker(RadioSpeaker speaker) {
        if (speaker.location != null && speaker.location.isClientSide()) {
            CommonSimpleRadio.warn("Attempted to register a client-sided speaker on the server; cancelling", new Object[0]);
            return null;
        }
        RadioManager.putRouter(speakers, speaker);
        return speaker;
    }

    public static List<RadioListener> getListeners() {
        return listeners.stream().toList();
    }

    public static void removeListener(RadioListener listener) {
        RadioManager.removeListener(listener::equals);
    }

    public static void removeListener(Predicate<RadioListener> criteria) {
        listeners.removeIf(criteria);
    }

    public static void removeListener(short identifier) {
        listeners.remove(identifier);
    }

    public static void removeListener(Entity owner) {
        RadioManager.removeListener((RadioListener listener) -> owner.equals((Object)listener.owner));
    }

    public static void removeListener(WorldlyPosition location) {
        RadioManager.removeListener((RadioListener listener) -> location.equals(listener.location));
    }

    public static void removeListener(UUID id) {
        RadioManager.removeListener((RadioListener listener) -> id.equals(listener.reference));
    }

    public static RadioListener getListener(Entity owner) {
        return RadioManager.getListener((RadioListener listener) -> owner.equals((Object)listener.owner));
    }

    public static RadioListener getListener(WorldlyPosition location) {
        return RadioManager.getListener((RadioListener listener) -> location.equals(listener.location));
    }

    public static RadioListener getListener(UUID id) {
        return RadioManager.getListener((RadioListener listener) -> id.equals(listener.reference));
    }

    public static RadioListener getListener(Predicate<RadioListener> filter) {
        Optional<RadioListener> result = listeners.stream().filter(filter).findFirst();
        return result.orElse(null);
    }

    public static RadioListener getOrCreateListener(Entity owner, @Nullable UUID id) {
        boolean isClient = owner.m_9236_().f_46443_;
        RadioListener listener = null;
        if (listener == null) {
            listener = isClient ? ClientRadioManager.getListener(id) : RadioManager.getListener(id);
        }
        return listener != null ? listener : new RadioListener(owner, id);
    }

    public static RadioListener getOrCreateListener(Entity owner) {
        return RadioManager.getOrCreateListener(owner, null);
    }

    public static RadioListener getOrCreateListener(WorldlyPosition location, @Nullable UUID id) {
        boolean isClient = location.level.f_46443_;
        RadioListener listener = null;
        if (listener == null) {
            listener = isClient ? ClientRadioManager.getListener(id) : RadioManager.getListener(id);
        }
        return listener != null ? listener : new RadioListener(location, id);
    }

    public static RadioListener getOrCreateListener(WorldlyPosition location) {
        return RadioManager.getOrCreateListener(location, null);
    }

    public static RadioListener registerListener(RadioListener listener) {
        if (listener.location != null && listener.location.isClientSide()) {
            CommonSimpleRadio.warn("Attempted to register a client-sided listener on the server; cancelling", new Object[0]);
            return null;
        }
        RadioManager.putRouter(listeners, listener);
        return listener;
    }

    public static void close() {
        Frequency.close();
        speakers.clear();
        listeners.clear();
        routers.clear();
    }

    public static <R extends RadioRouter> void validate(List<R> container) {
        container.removeIf(Predicate.not(RadioRouter::validate));
        container.removeIf(entry -> entry.owner == null && entry.location == null);
    }

    public static void garbageCollect() {
        Frequency.garbageCollect();
        RadioManager.validate(speakers);
        RadioManager.validate(listeners);
        routers.entrySet().removeIf(entry -> !((RadioRouter)entry.getValue()).validate());
        routers.entrySet().removeIf(entry -> ((RadioRouter)entry.getValue()).owner == null && ((RadioRouter)entry.getValue()).location == null);
    }

    public static void levelTick(ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            playerVelocities.compute(player.m_20148_(), (uuid, vector) -> {
                if (vector == null) {
                    vector = new Vector3f();
                }
                vector.set((float)(player.m_20185_() - player.f_19790_), (float)(player.m_20186_() - player.f_19791_), (float)(player.m_20189_() - player.f_19792_));
                return vector;
            });
        }
    }

    public static void serverTick(int tickCount) {
        if (tickCount % 20 == 0) {
            RadioManager.garbageCollect();
        }
        List<Frequency> frequencies = Frequency.getFrequencies();
        for (Frequency frequency : frequencies) {
            frequency.serverTick(tickCount);
        }
        for (RadioListener listener : listeners) {
            listener.tick(tickCount);
        }
        for (RadioSpeaker speaker : speakers) {
            speaker.tick(tickCount);
        }
        RadioManager.applyModifications();
        sourceQueue.addAll(pendingSources);
        pendingSources.clear();
        ArrayList<QueuedSource> acceptedSources = new ArrayList<QueuedSource>();
        Iterator<QueuedSource> iterator = sourceQueue.iterator();
        while (iterator.hasNext()) {
            QueuedSource source = iterator.next();
            --source.time;
            if (source.time > 0) continue;
            acceptedSources.add(source);
            iterator.remove();
        }
        for (QueuedSource source : acceptedSources) {
            source.router.accept(source.source);
        }
    }

    private static void applyModifications() {
        Runnable modification;
        for (int i = 0; i < pendingModifications.size() && (modification = pendingModifications.poll()) != null; ++i) {
            modification.run();
        }
    }

    public static void queueSource(RadioSource source, RadioRouter destination, int delay) {
        pendingSources.add(new QueuedSource(source, destination, delay));
    }

    public static void dequeueSource(Predicate<QueuedSource> criteria) {
        pendingSources.removeIf(criteria);
        sourceQueue.removeIf(criteria);
    }

    public static boolean readQueue(Predicate<QueuedSource> filter) {
        for (QueuedSource source : sourceQueue) {
            if (!filter.test(source)) continue;
            return true;
        }
        for (QueuedSource source : pendingSources) {
            if (!filter.test(source)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyLocationCollection(WorldlyPosition position, Class<?> clazz) {
        BlockPos pos = position.realLocation();
        CollectionResult result = CompatCore.verifyLocationCollection(position, clazz);
        if (result == CollectionResult.IGNORE) {
            return true;
        }
        if (result == CollectionResult.COLLECT) {
            return false;
        }
        BlockState state = position.level.m_8055_(pos);
        if (state.m_60795_()) {
            return !position.level.m_46749_(pos);
        }
        Block block = state.m_60734_();
        return clazz.isAssignableFrom(block.getClass()) || clazz.isAssignableFrom(block.m_5456_().getClass());
    }

    public static boolean verifyEntityCollection(Entity entity, Predicate<ItemStack> itemCriteria) {
        CollectionResult result = CompatCore.verifyEntityCollection(entity, itemCriteria);
        if (result == CollectionResult.IGNORE) {
            return true;
        }
        if (result == CollectionResult.COLLECT) {
            return false;
        }
        if (entity.m_213877_()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_150109_().m_216874_(itemCriteria);
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemCriteria.test(itemEntity.m_32055_());
        }
        for (ItemStack stack : entity.m_6167_()) {
            if (!itemCriteria.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemStack isEntityHolding(Entity entity, Predicate<ItemStack> handCriteria) {
        for (ItemStack stack : entity.m_6167_()) {
            if (!handCriteria.test(stack)) continue;
            return stack;
        }
        return null;
    }

    public static TreeMap<Float, RadioListener> getListeners(Vector3f at) {
        TreeMap<Float, RadioListener> qualified = new TreeMap<Float, RadioListener>();
        for (RadioListener listener : RadioManager.getListeners()) {
            Vector3f position;
            if (listener.location != null) {
                position = listener.location.position();
            } else {
                if (listener.owner == null) continue;
                position = listener.owner.m_20182_().m_252839_();
            }
            float distance = position.distance((Vector3fc)at);
            if (distance > listener.range) continue;
            qualified.put(Float.valueOf(distance), listener);
        }
        return qualified;
    }

    public void onSoundPlayed(ServerLevel level, Vec3 location, Holder<SoundEvent> soundHolder, float volume, float pitch, long seed) {
        this.onSoundPlayed(level, location, soundHolder, volume, pitch, 0.0f, seed);
    }

    public void onSoundPlayed(ServerLevel level, Vec3 location, Holder<SoundEvent> soundHolder, float volume, float pitch, float offset, long seed) {
        if (level.f_46443_) {
            return;
        }
        if (!SimpleRadioLibrary.SERVER_CONFIG.router.soundListening.booleanValue()) {
            return;
        }
        if (!level.m_46749_(BlockPos.m_274446_((Position)location))) {
            return;
        }
        SoundEvent sound = (SoundEvent)soundHolder.m_203334_();
        TreeMap<Float, RadioListener> qualified = RadioManager.getListeners(location.m_252839_());
        for (Map.Entry<Float, RadioListener> entry : qualified.entrySet()) {
            float distance = entry.getKey().floatValue();
            RadioListener listener = entry.getValue();
            double falloff = CommonRadioPlugin.getFalloff(distance, listener.range);
            RadioSource newSource = new RadioSource(listener.reference, WorldlyPosition.of(location.m_252839_(), (Level)level), sound, (float)(falloff * (double)volume));
            newSource.pitch = pitch;
            newSource.offset = offset;
            newSource.seed = seed;
            newSource.activity = (float)((double)Math.clamp((int)0, (int)15, (int)Math.round((float)((1.0f - distance / listener.range) * 15.0f))) * SimpleRadioLibrary.SERVER_CONFIG.router.activityRedstoneFactor);
            listener.onSource(newSource);
        }
    }

    public void onMicPacket(MicrophonePacketEvent event) {
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)senderConnection.getPlayer().getPlayer();
        ServerLevel level = sender.m_284548_();
        TreeMap<Float, RadioListener> qualified = RadioManager.getListeners(new Vector3f((float)sender.m_20185_(), (float)sender.m_20186_(), (float)sender.m_20189_()));
        for (Map.Entry<Float, RadioListener> entry : qualified.entrySet()) {
            float distance = entry.getKey().floatValue();
            RadioListener listener = entry.getValue();
            double falloff = CommonRadioPlugin.getFalloff(distance, listener.range);
            Vector3f listenerPosition = null;
            if (listener.location != null) {
                listenerPosition = listener.location.position();
            } else if (listener.owner != null) {
                listenerPosition = listener.owner.m_20182_().m_252839_();
            }
            if (listenerPosition == null) continue;
            byte[] data = ((MicrophonePacket)event.getPacket()).getOpusEncodedData();
            Vector3f senderPosition = sender.m_20182_().m_252839_();
            RadioSource newSource = new RadioSource(sender.m_20148_(), WorldlyPosition.of(senderPosition, (Level)level), data, (float)falloff);
            OpusDecoder decoder = listener.getDecoder(sender.m_20148_());
            if (data == null || data.length == 0) {
                decoder.resetState();
            } else {
                short[] decoded = decoder.decode(data);
                newSource.activity = CommonRadioPlugin.analyzeActivity(decoded);
            }
            listener.onSource(newSource);
        }
    }

    static {
        pendingSources = new ArrayList();
        sourceQueue = new ArrayList();
        playerVelocities = new HashMap<UUID, Vector3f>();
        pendingModifications = new LinkedList<Runnable>();
        speakers = new RouterContainer();
        listeners = new RouterContainer();
        routers = new HashMap<Short, RadioRouter>();
    }

    public static class QueuedSource {
        public RadioSource source;
        public RadioRouter router;
        public int time;

        public QueuedSource(RadioSource source, RadioRouter router, int time) {
            this.source = source;
            this.router = router;
            this.time = time;
        }
    }

    public static enum CollectionResult {
        PASS,
        IGNORE,
        COLLECT;

    }
}

