/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei;

import java.util.ArrayList;
import java.util.Comparator;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.integration.jei.SandwichingStationCategory;
import someassemblyrequired.integration.jei.SandwichingStationRecipeGenerator;
import someassemblyrequired.integration.jei.create.SequencedAssemblyRecipeGenerator;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModBlocks;
import someassemblyrequired.registry.ModItems;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = SomeAssemblyRequired.id("main");
    public static final RecipeType<SandwichingStationCategory.Recipe> SANDWICHING_STATION = RecipeType.create((String)"some_assembly_required", (String)"sandwiching_station", SandwichingStationCategory.Recipe.class);

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        ArrayList<ItemStack> sandwiches = new ArrayList<ItemStack>();
        ModCompat.gatherCreativeTabSandwiches(sandwiches::add);
        ModCompat.gatherJEISandwiches(sandwiches::add);
        sandwiches.removeIf(sandwich -> !SandwichItemHandler.get((ICapabilityProvider)sandwich).orElseThrow().isBurger());
        registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, sandwiches, ((SandwichItem)((Object)ModItems.SANDWICH.get())).m_5524_());
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (ModCompat.isCreateLoaded()) {
            SequencedAssemblyRecipeGenerator.register(registration);
        }
        registration.addTypedRecipeManagerPlugin(SANDWICHING_STATION, (ISimpleRecipeManagerPlugin)new SandwichingStationRecipeGenerator());
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        ArrayList<ItemStack> sandwiches = new ArrayList<ItemStack>();
        ModCompat.gatherJEISandwiches(sandwiches::add);
        sandwiches.sort(Comparator.comparingInt(stack -> -BuiltInRegistries.f_257033_.m_7447_((Object)SandwichItemHandler.get((ICapabilityProvider)stack).orElseThrow().bottom().m_41720_())));
        registration.addExtraItemStacks(sandwiches);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SandwichingStationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.SANDWICH.get(), (stack, uidContext) -> SandwichItemHandler.get((ICapabilityProvider)stack).map(handler -> {
            StringBuilder builder = new StringBuilder();
            for (ItemStack item : handler.getItems()) {
                builder.append(item.toString());
                builder.append(item.m_41784_());
            }
            return builder.toString();
        }).orElse(""));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SANDWICHING_STATION.get()), new RecipeType[]{SANDWICHING_STATION});
    }
}

