/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.data.SBInjectLootSubProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.data.SBLootEnabledCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;

public class SBLootModifierProvider
extends GlobalLootModifierProvider {
    SBLootModifierProvider(PackOutput packOutput) {
        super(packOutput, "sophisticatedbackpacks");
    }

    protected void start() {
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SIMPLE_DUNGEON, BuiltInLootTables.f_78742_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.ABANDONED_MINESHAFT, BuiltInLootTables.f_78759_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.DESERT_PYRAMID, BuiltInLootTables.f_78764_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.WOODLAND_MANSION, BuiltInLootTables.f_78689_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SHIPWRECK_TREASURE, BuiltInLootTables.f_78695_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.BASTION_TREASURE, BuiltInLootTables.f_78697_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.END_CITY_TREASURE, BuiltInLootTables.f_78741_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.NETHER_BRIDGE, BuiltInLootTables.f_78760_);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SPAWN_BONUS_CHEST, BuiltInLootTables.f_78740_);
    }

    private void addInjectLootTableModifier(ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
        this.add(lootTableToInjectInto.m_135815_(), (IGlobalLootModifier)new InjectLootModifier(lootTable, lootTableToInjectInto));
    }

    public static class InjectLootModifier
    extends LootModifier {
        public static final Codec<InjectLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(m -> m.lootTable), (App)ResourceLocation.f_135803_.fieldOf("loot_table_to_inject_into").forGetter(m -> m.lootTableToInjectInto))).apply((Applicative)inst, InjectLootModifier::new));
        private final ResourceLocation lootTable;
        private final ResourceLocation lootTableToInjectInto;

        protected InjectLootModifier(LootItemCondition[] conditions, ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            super(conditions);
            this.lootTable = lootTable;
            this.lootTableToInjectInto = lootTableToInjectInto;
        }

        protected InjectLootModifier(ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            this(new LootItemCondition[]{SBLootEnabledCondition.builder().m_6409_(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto).m_6409_()}, lootTable, lootTableToInjectInto);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            LootTable table = context.m_278643_().m_278676_(this.lootTable);
            table.m_79131_(context, arg_0 -> generatedLoot.add(arg_0));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return (Codec)ModItems.INJECT_LOOT.get();
        }
    }
}

