/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record RequestItemHighlightsMessage(ItemStack stack, List<BlockPos> storagePositions) {
    public static void encode(RequestItemHighlightsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeItemStack(msg.stack(), false);
        packetBuffer.m_236828_(msg.storagePositions(), FriendlyByteBuf::m_130064_);
    }

    public static RequestItemHighlightsMessage decode(FriendlyByteBuf packetBuffer) {
        return new RequestItemHighlightsMessage(packetBuffer.m_130267_(), packetBuffer.m_236845_(FriendlyByteBuf::m_130135_));
    }

    static void onMessage(RequestItemHighlightsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RequestItemHighlightsMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, RequestItemHighlightsMessage msg) {
        if (player == null) {
            return;
        }
        ItemStackKey stackKey = ItemStackKey.of(msg.stack());
        Level level = player.m_9236_();
        ArrayList<BlockPos> stackPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> itemPositions = new ArrayList<BlockPos>();
        msg.storagePositions().forEach(pos -> WorldHelper.getLoadedBlockEntity(level, pos, IControllableStorage.class).ifPresent(storage -> {
            ISlotTracker slotTracker = storage.getStorageWrapper().getInventoryHandler().getSlotTracker();
            if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                stackPositions.add((BlockPos)pos);
            } else if (slotTracker.getItems().contains(msg.stack().m_41720_())) {
                itemPositions.add((BlockPos)pos);
            }
        }));
        PacketHandler.INSTANCE.sendToClient(player, new SyncItemHighlightsMessage(stackPositions, itemPositions, List.of()));
    }
}

