/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public class ShulkerBoxDynamicModel
implements IUnbakedGeometry<ShulkerBoxDynamicModel> {
    private static final String BLOCK_BREAK_FOLDER = "block/break/";
    public static final ResourceLocation TINTABLE_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/tintable_shulker_box");
    public static final ResourceLocation MAIN_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/shulker_box");

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new ShulkerBoxBakedModel();
    }

    private static class ShulkerBoxBakedModel
    implements BakedModel {
        private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();

        private ShulkerBoxBakedModel() {
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return Collections.emptyList();
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return true;
        }

        public TextureAtlasSprite m_6160_() {
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(BlockModelShaper.m_110895_((BlockState)Blocks.f_50705_.m_49966_()));
            return model.m_6160_();
        }

        @Nonnull
        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
                ModelData.Builder builder = ModelData.builder();
                builder.with(HAS_MAIN_COLOR, (Object)(be.getStorageWrapper().getMainColor() > -1 ? 1 : 0));
                return builder.build();
            }).orElse(ModelData.EMPTY);
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            ResourceLocation texture = TINTABLE_BREAK_TEXTURE;
            if (Boolean.FALSE.equals(data.get(HAS_MAIN_COLOR))) {
                texture = MAIN_BREAK_TEXTURE;
            }
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        }

        public ItemOverrides m_7343_() {
            return new ItemOverrides(){};
        }
    }

    public static final class Loader
    implements IGeometryLoader<ShulkerBoxDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public ShulkerBoxDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            return new ShulkerBoxDynamicModel();
        }
    }
}

