/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElytrumModel<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("spore", "elytrummodel"), "main");
    public final ModelPart body;
    private final ModelPart leftJoint;
    private final ModelPart left_wing;
    private final ModelPart left_for_wing;
    private final ModelPart rightJoint;
    private final ModelPart right_wing;
    private final ModelPart right_for_wing;

    public ElytrumModel() {
        ModelPart root = ElytrumModel.createBodyLayer().m_171564_();
        this.body = root.m_171324_("body");
        this.leftJoint = this.body.m_171324_("leftJoint");
        this.left_wing = this.leftJoint.m_171324_("left_wing");
        this.left_for_wing = this.left_wing.m_171324_("left_for_wing");
        this.rightJoint = this.body.m_171324_("rightJoint");
        this.right_wing = this.rightJoint.m_171324_("right_wing");
        this.right_for_wing = this.right_wing.m_171324_("right_for_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftJoint = body.m_171599_("leftJoint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)-3.0f, (float)3.0f));
        PartDefinition left_wing = leftJoint.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-7.25f, -1.0f, -1.0f, 17.0f, 14.0f, 1.0f, new CubeDeformation(-1.0f)), PartPose.m_171423_((float)6.75f, (float)2.0f, (float)-0.25f, (float)-3.1416f, (float)0.0f, (float)-2.7925f));
        PartDefinition left_for_wing = left_wing.m_171599_("left_for_wing", CubeListBuilder.m_171558_().m_171514_(18, 44).m_171488_(-12.25f, -7.0f, 0.01f, 17.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)12.0f, (float)-1.0f));
        PartDefinition rightJoint = body.m_171599_("rightJoint", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)-3.0f, (float)3.0f));
        PartDefinition right_wing = rightJoint.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(28, 23).m_171488_(-9.75f, -1.0f, -0.95f, 17.0f, 14.0f, 1.0f, new CubeDeformation(-1.0f)), PartPose.m_171423_((float)-6.75f, (float)2.0f, (float)-0.25f, (float)-3.1416f, (float)0.0f, (float)2.7925f));
        PartDefinition right_for_wing = right_wing.m_171599_("right_for_wing", CubeListBuilder.m_171558_().m_171514_(1, 44).m_171488_(-4.25f, -7.0f, 0.06f, 17.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)12.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void animatedElytra(T entity, ModelPart rightWing, ModelPart leftWing) {
        float f = 0.2617994f;
        float f1 = -0.2617994f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (entity.m_21255_()) {
            float f4 = 1.0f;
            Vec3 vec3 = entity.m_20184_();
            if (vec3.f_82480_ < 0.0) {
                Vec3 vec31 = vec3.m_82541_();
                f4 = 1.0f - (float)Math.pow(-vec31.f_82480_, 1.5);
            }
            f = f4 * 0.34906584f + (1.0f - f4) * f;
            f1 = f4 * -1.5707964f + (1.0f - f4) * f1;
        } else if (entity.m_6047_()) {
            f = 0.6981317f;
            f1 = -0.7853982f;
            f2 = 3.0f;
            f3 = 0.08726646f;
        }
        leftWing.f_104201_ = f2;
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
            abstractclientplayer.f_108542_ += (f - abstractclientplayer.f_108542_) * 0.1f;
            abstractclientplayer.f_108543_ += (f3 - abstractclientplayer.f_108543_) * 0.1f;
            abstractclientplayer.f_108544_ += (f1 - abstractclientplayer.f_108544_) * 0.1f;
            leftWing.f_104203_ = abstractclientplayer.f_108542_;
            leftWing.f_104204_ = abstractclientplayer.f_108543_;
            leftWing.f_104205_ = abstractclientplayer.f_108544_;
        } else {
            leftWing.f_104203_ = f;
            leftWing.f_104205_ = f1;
            leftWing.f_104204_ = f3;
        }
        rightWing.f_104204_ = -leftWing.f_104204_;
        rightWing.f_104201_ = leftWing.f_104201_;
        rightWing.f_104203_ = leftWing.f_104203_;
        rightWing.f_104205_ = -leftWing.f_104205_;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animatedElytra(entity, this.leftJoint, this.rightJoint);
        this.right_for_wing.f_104205_ = this.rightJoint.f_104205_ / 2.0f;
        this.left_for_wing.f_104205_ = this.leftJoint.f_104205_ / 2.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

