/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.InfectedHazmatCoat;
import com.Harbinger.Spore.Client.Models.InfectedHazmatModel;
import com.Harbinger.Spore.Client.Models.InfectedHazmatWithTank;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedHazmat;
import com.Harbinger.Spore.Sentities.Variants.HazmatVariant;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InfectedHazmatRenderer
extends MobRenderer<InfectedHazmat, EntityModel<InfectedHazmat>> {
    private final EntityModel<InfectedHazmat> normalHazmat = this.m_7200_();
    private final EntityModel<InfectedHazmat> tankHazmat;
    private final EntityModel<InfectedHazmat> coatHazmat;
    public static final Map<HazmatVariant, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(HazmatVariant.class), p_114874_ -> {
        p_114874_.put(HazmatVariant.DEFAULT, new ResourceLocation("spore", "textures/entity/inf_hazmat.png"));
        p_114874_.put(HazmatVariant.TANK, new ResourceLocation("spore", "textures/entity/inf_hazmat.png"));
        p_114874_.put(HazmatVariant.COAT, new ResourceLocation("spore", "textures/entity/inf_hazmat_coat.png"));
    });

    public InfectedHazmatRenderer(EntityRendererProvider.Context context) {
        super(context, new InfectedHazmatModel(context.m_174023_(InfectedHazmatModel.LAYER_LOCATION)), 0.5f);
        this.tankHazmat = new InfectedHazmatWithTank<InfectedHazmat>(context.m_174023_(InfectedHazmatWithTank.LAYER_LOCATION));
        this.coatHazmat = new InfectedHazmatCoat<InfectedHazmat>(context.m_174023_(InfectedHazmatCoat.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(InfectedHazmat hazmat) {
        return TEXTURE.get((Object)hazmat.getVariant());
    }

    public void render(InfectedHazmat infectedHazmat, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        EntityModel<InfectedHazmat> entityModel = infectedHazmat.getVariant() == HazmatVariant.TANK ? this.tankHazmat : (infectedHazmat.getVariant() == HazmatVariant.COAT ? this.coatHazmat : this.normalHazmat);
        this.f_115290_ = entityModel;
        super.m_7392_((Mob)infectedHazmat, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }
}

