/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.Screens.ZoaholicMenu;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Signal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ZoaholicBlockEntity
extends BlockEntity
implements AnimatedEntity,
MenuProvider {
    private int ticks;
    private boolean hasBrain = false;
    private boolean hasHeart = false;
    private int amountOfInnards = 0;
    private int biomass = 0;
    private int processing = 0;
    private int side;

    public ZoaholicBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SblockEntities.ZOAHOLIC.get(), pos, state);
        this.side = this.setSide(state);
    }

    private int setSide(BlockState state) {
        Property property = state.m_60734_().m_49965_().m_61081_("facing");
        if (property instanceof DirectionProperty) {
            DirectionProperty directionProperty = (DirectionProperty)property;
            return ((Direction)state.m_61143_((Property)directionProperty)).m_122411_();
        }
        return 2;
    }

    public int getAmountOfInnards() {
        return this.amountOfInnards;
    }

    public void setAmountOfInnards(int amountOfInnards) {
        this.amountOfInnards = amountOfInnards;
    }

    public boolean HasBrain() {
        return this.hasBrain;
    }

    public void setBrain(boolean hasBrain) {
        this.hasBrain = hasBrain;
    }

    public boolean HasHeart() {
        return this.hasHeart;
    }

    public void setHasHeart(boolean hasHeart) {
        this.hasHeart = hasHeart;
    }

    public boolean hasEnoughInnards() {
        return this.getAmountOfInnards() >= 2;
    }

    public int getBiomass() {
        return this.biomass;
    }

    public void setBiomass(int biomass) {
        this.biomass = biomass;
    }

    public void addBiomass(int value) {
        this.setBiomass(this.getBiomass() + value);
    }

    public int getProcessing() {
        return this.processing;
    }

    public void setProcessing(int processing) {
        this.processing = processing;
    }

    public void setSide(int i) {
        this.side = i;
    }

    public int getSide() {
        return this.side;
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("innards", this.getAmountOfInnards());
        tag.m_128405_("biomass", this.getBiomass());
        tag.m_128379_("brain", this.HasBrain());
        tag.m_128379_("heart", this.HasHeart());
        tag.m_128405_("side", this.getSide());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.setAmountOfInnards(tag.m_128451_("innards"));
        this.setBiomass(tag.m_128451_("biomass"));
        this.setBrain(tag.m_128471_("brain"));
        this.setHasHeart(tag.m_128471_("heart"));
        this.setSide(this.getSide());
        super.m_142466_(tag);
    }

    public void lowerBiomass() {
        this.setBiomass(this.getBiomass() - 1);
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    public boolean isActive() {
        return this.HasHeart() && this.HasBrain() && this.hasEnoughInnards() && this.getBiomass() > 1;
    }

    public void tickBlockEntity() {
        this.ticks = this.ticks < 360 ? ++this.ticks : 0;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, ZoaholicBlockEntity e) {
        if (e.isActive()) {
            e.lowerBiomass();
            if (e.getProcessing() > 0) {
                e.setProcessing(e.getProcessing() - 1);
                if (e.getProcessing() == 198) {
                    level.m_5594_(null, pos, (SoundEvent)Ssounds.PRINTING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (e.getProcessing() == 1) {
                    e.writeDocument(level, pos);
                }
            }
            if (e.getBiomass() % 60 == 0) {
                e.spreadMadness(level, pos);
                level.m_5594_(null, pos, (SoundEvent)Ssounds.HEART_BEAT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, ZoaholicBlockEntity e) {
        e.tickBlockEntity();
    }

    @Nullable
    protected LivingEntity getAnomaly(Level level) {
        RandomSource source = RandomSource.m_216327_();
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || !((living = (LivingEntity)entity) instanceof Proto) && !(living instanceof Calamity)) continue;
                entities.add(living);
            }
        }
        if (entities.isEmpty()) {
            return null;
        }
        int size = entities.size();
        return (LivingEntity)entities.get(source.m_188503_(size));
    }

    public void writeDocument(Level level, BlockPos blockPos) {
        LivingEntity livingEntity = this.getAnomaly(level);
        RandomSource randomSource = RandomSource.m_216327_();
        ItemStack stack = new ItemStack((ItemLike)Items.f_42516_);
        if (livingEntity != null) {
            if (Math.random() < (double)0.2f) {
                this.alertAnomaly(blockPos, livingEntity);
                stack.m_41714_((Component)Component.m_237115_((String)"zoaholic.line_5"));
            } else {
                int x = livingEntity.m_146903_() + randomSource.m_216339_(-50, 50);
                int z = livingEntity.m_146907_() + randomSource.m_216339_(-50, 50);
                String component = Component.m_237115_((String)"zoaholic.line_3").getString();
                stack.m_41714_((Component)Component.m_237113_((String)(component + " X:" + x + " Z:" + z)));
            }
        } else {
            stack.m_41714_((Component)Component.m_237115_((String)"zoaholic.line_4"));
        }
        ItemEntity item = new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_(), stack);
        level.m_7967_((Entity)item);
    }

    private void alertAnomaly(BlockPos pos, LivingEntity livingEntity) {
        if (livingEntity instanceof Proto) {
            Proto proto = (Proto)livingEntity;
            proto.setSignal(new Signal(true, pos));
        } else if (livingEntity instanceof Calamity) {
            Calamity calamity = (Calamity)livingEntity;
            calamity.setSearchArea(pos);
        }
    }

    public void spreadMadness(Level level, BlockPos blockPos) {
        if (Math.random() < 0.1) {
            AABB aabb = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)16.0, (double)16.0, (double)16.0);
            List entities = level.m_6443_(LivingEntity.class, aabb, e -> ((List)SConfig.SERVER.proto_sapient_target.get()).contains(e.m_20078_()) || e instanceof Player);
            for (LivingEntity entity : entities) {
                entity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MADNESS.get(), 2400, 0, false, false));
            }
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.spore.zoaholic");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ZoaholicMenu(i, inventory);
    }
}

