/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ClimberMovement
extends MoveControl {
    private final float maxClampDist;
    private final float minClampDist;
    private final float multiplier;

    public ClimberMovement(Mob mob, float maxClampDist, float minClampDist, float multiplier) {
        super(mob);
        this.maxClampDist = maxClampDist;
        this.minClampDist = minClampDist;
        this.multiplier = multiplier;
    }

    private void clampToSurfaceOrDrop() {
        float maxDistSq;
        float minDistSq = maxDistSq = this.maxClampDist * this.maxClampDist;
        Vec3 yank = Vec3.f_82478_;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    float d;
                    if (i == 0 && j == 0 && k == 0 || !((d = this.raycastDistSq(new Vec3((double)i, (double)j, (double)k))) < maxDistSq)) continue;
                    yank = yank.m_82520_((double)i, (double)j, (double)k);
                    if (!(d < minDistSq)) continue;
                    minDistSq = d;
                }
            }
        }
        if (minDistSq > this.minClampDist * this.minClampDist) {
            this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(yank.m_82490_((double)(this.multiplier * minDistSq))));
        }
        this.f_24974_.m_20242_(minDistSq < maxDistSq);
    }

    private float raycastDistSq(Vec3 direction) {
        Vec3 start = this.f_24974_.m_20182_().m_82520_(0.0, (double)this.f_24974_.m_20206_() / 2.0, 0.0);
        Vec3 end = start.m_82549_(direction.m_82490_((double)this.maxClampDist));
        BlockHitResult result = this.f_24974_.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.f_24974_));
        return (float)result.m_82450_().m_82557_(start);
    }

    public void m_8126_() {
        super.m_8126_();
        if (this.f_24974_.m_5448_() != null && this.f_24974_.m_5448_().m_20186_() <= this.f_24974_.m_20186_()) {
            this.f_24974_.m_20242_(false);
            return;
        }
        if ((this.f_24974_.f_19862_ || this.f_24974_.f_19863_) && !this.f_24974_.m_20096_()) {
            this.clampToSurfaceOrDrop();
        }
    }
}

