/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public interface CasingGenerator {
    private boolean compare(Level level, BlockPos blockpos) {
        boolean propery1 = level.m_8055_(blockpos.m_7495_()).m_60804_((BlockGetter)level, blockpos);
        boolean propery2 = level.m_8055_(blockpos.m_7494_()).m_60804_((BlockGetter)level, blockpos);
        boolean properzx1 = level.m_8055_(blockpos.m_122029_()).m_60804_((BlockGetter)level, blockpos);
        boolean properzx2 = level.m_8055_(blockpos.m_122019_()).m_60804_((BlockGetter)level, blockpos);
        boolean properzx3 = level.m_8055_(blockpos.m_122012_()).m_60804_((BlockGetter)level, blockpos);
        boolean properzx4 = level.m_8055_(blockpos.m_122024_()).m_60804_((BlockGetter)level, blockpos);
        return propery1 || propery2 || properzx1 || properzx2 || properzx3 || properzx4;
    }

    default public List<BlockState> possibleBlocks() {
        ArrayList<BlockState> values = new ArrayList<BlockState>();
        values.add(((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_());
        values.add(((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_());
        values.add(((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_());
        values.add(((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_());
        values.add(((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_());
        values.add(((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_());
        values.add(((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).m_49966_());
        values.add(((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).m_49966_());
        values.add(((Block)Sblocks.GASTRIC_BIOMASS.get()).m_49966_());
        return values;
    }

    default public void generateChasing(BlockPos pos, Entity entity, int radius) {
        this.generateChasing(pos, entity, radius, 1);
    }

    default public void generateChasing(BlockPos pos, Entity entity, int radius, int thickness) {
        Level level = entity.m_9236_();
        RandomSource randomSource = RandomSource.m_216327_();
        for (int i = 0; i <= 2 * radius; ++i) {
            for (int j = 0; j <= 2 * radius; ++j) {
                for (int k = 0; k <= 2 * radius; ++k) {
                    double distance = Mth.m_14116_((float)((i - radius) * (i - radius) + (j - radius) * (j - radius) + (k - radius) * (k - radius)));
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 && Math.abs(k) == 2 || !(distance > (double)radius - (double)thickness / 2.0) || !(distance < (double)radius + (double)thickness / 2.0)) continue;
                    BlockPos blockpos = pos.m_7918_(i - radius, j - radius, k - radius);
                    BlockState blockstate = level.m_8055_(blockpos);
                    if (Math.random() < 0.1 && !blockstate.m_60804_((BlockGetter)level, blockpos) && this.compare(level, blockpos) && !level.f_46443_) {
                        level.m_7731_(blockpos, this.possibleBlocks().get(randomSource.m_188503_(this.possibleBlocks().size())), 3);
                        if (Math.random() < 0.001) {
                            this.createSpots(blockpos, level, randomSource.m_216339_(3, 6), Math.random() < 0.5 ? ((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).m_49966_() : ((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).m_49966_());
                        }
                        if (Math.random() < 0.001) {
                            this.createPussSpots(blockpos, level, randomSource.m_216339_(2, 5));
                        }
                        if (Math.random() < 0.005) {
                            if (level.m_8055_(blockpos.m_7494_()).m_60795_()) {
                                this.createFungalStalks(blockpos, level, randomSource, false);
                            } else if (level.m_8055_(blockpos.m_7495_()).m_60795_()) {
                                this.createFungalStalks(blockpos, level, randomSource, true);
                            }
                        }
                    }
                    if (!(Math.random() < 0.05) || !blockstate.m_60804_((BlockGetter)level, blockpos)) continue;
                    for (String str : (List)SConfig.DATAGEN.block_infection.get()) {
                        Item item;
                        ItemStack itemStack;
                        String[] string = str.split("\\|");
                        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string[0])));
                        if (stack == ItemStack.f_41583_ || blockstate.m_60734_().m_5456_() != stack.m_41720_() || (itemStack = new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string[1])))) == ItemStack.f_41583_ || !((item = itemStack.m_41720_()) instanceof BlockItem)) continue;
                        BlockItem blockItem = (BlockItem)item;
                        level.m_7731_(blockpos, blockItem.m_40614_().m_49966_(), 3);
                    }
                }
            }
        }
    }

    default public void createSpots(BlockPos pos, Level level, int range, BlockState state) {
        for (int i = 0; i <= 2 * range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = 0; k <= 2 * range; ++k) {
                    double distance = Mth.m_14116_((float)((i - range) * (i - range) + (j - range) * (j - range) + (k - range) * (k - range)));
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 && Math.abs(k) == 2 || !(distance < (double)range + 0.5)) continue;
                    BlockPos blockpos = pos.m_7918_(i - range, j - range, k - range);
                    if (!this.possibleBlocks().contains(level.m_8055_(blockpos))) continue;
                    level.m_7731_(blockpos, state, 3);
                }
            }
        }
    }

    default public void createPussSpots(BlockPos pos, Level level, int range) {
        for (int i = 0; i <= 2 * range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = 0; k <= 2 * range; ++k) {
                    BlockPos blockpos;
                    double distance = Mth.m_14116_((float)((i - range) * (i - range) + (j - range) * (j - range) + (k - range) * (k - range)));
                    if (Math.abs(i) == 2 && Math.abs(j) == 2 && Math.abs(k) == 2) continue;
                    if (distance < (double)range + 0.5 && distance > (double)range - 0.5 && level.m_8055_(blockpos = pos.m_7918_(i - range, j - range, k - range)).m_60795_()) {
                        level.m_7731_(blockpos, Math.random() < 0.5 ? ((Block)Sblocks.GASTRIC_BIOMASS.get()).m_49966_() : ((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_(), 3);
                    }
                    if (!(distance < (double)range - 0.5) || !level.m_8055_(blockpos = pos.m_7918_(i - range, j - range, k - range)).m_60795_()) continue;
                    level.m_7731_(blockpos, Math.random() < 0.5 ? ((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).m_49966_() : ((LiquidBlock)Sblocks.BILE.get()).m_49966_(), 3);
                }
            }
        }
    }

    default public void createFungalStalks(BlockPos pos, Level level, RandomSource source, boolean down) {
        int random = down ? -source.m_216339_(4, 16) : source.m_216339_(4, 16);
        ArrayList<BlockState> states = new ArrayList<BlockState>(){
            {
                this.add(((Block)Sblocks.MYCELIUM_BLOCK.get()).m_49966_());
                this.add(((Block)Sblocks.FUNGAL_SHELL.get()).m_49966_());
            }
        };
        for (int i = 0; i <= random; ++i) {
            BlockState state = (BlockState)states.get(source.m_188503_(states.size()));
            int randomX = source.m_216339_(-1, 1);
            int randomZ = source.m_216339_(-1, 1);
            BlockPos blockPos = pos.m_7918_(randomX, i, randomZ);
            if (i % 2 == 0) {
                if (level.m_8055_(blockPos).m_60795_()) {
                    level.m_7731_(blockPos, state, 3);
                }
                if (level.m_8055_(blockPos.m_7494_()).m_60795_()) {
                    level.m_7731_(blockPos.m_7494_(), state, 3);
                }
            }
            if (i != random - 1) continue;
            if (level.m_8055_(blockPos.m_7494_()).m_60795_()) {
                level.m_7731_(blockPos.m_7494_(), ((Block)Sblocks.ORGANITE.get()).m_49966_(), 3);
            }
            if (!level.m_8055_(blockPos).m_60795_()) continue;
            level.m_7731_(blockPos, state, 3);
        }
    }
}

