/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Sblocks.GenericFoliageBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public interface FoliageSpread {
    default public void SpreadInfection(Level level, double range, BlockPos pos) {
        if (!level.f_46443_) {
            if (((Boolean)SConfig.SERVER.mound_foliage.get()).booleanValue()) {
                this.additionPlacers(level, pos, range);
                int i = 0;
                while ((double)i <= 2.0 * range) {
                    int j = 0;
                    while ((double)j <= 2.0 * range) {
                        int k = 0;
                        while ((double)k <= 2.0 * range) {
                            double distance = Mth.m_14116_((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                            if ((Math.abs(i) != 2 || Math.abs(j) != 2 || Math.abs(k) != 2) && distance < range + 0.5) {
                                BlockPos blockpos = pos.m_7918_(i - (int)range, j - (int)range, k - (int)range);
                                BlockState blockstate = level.m_8055_(blockpos);
                                this.SpreadFoliageAndConvert(level, blockstate, blockpos);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.additionIgnoreConfigPlacers(level, pos, range);
            }
        }
    }

    default public void SpreadFoliageAndConvert(Level level, BlockState blockstate, BlockPos blockpos) {
        boolean belowT;
        BlockState nord = level.m_8055_(blockpos.m_122012_());
        BlockState south = level.m_8055_(blockpos.m_122019_());
        BlockState west = level.m_8055_(blockpos.m_122024_());
        BlockState east = level.m_8055_(blockpos.m_122029_());
        BlockState above = level.m_8055_(blockpos.m_7494_());
        BlockState below = level.m_8055_(blockpos.m_7495_());
        boolean nordT = !nord.m_60804_((BlockGetter)level, blockpos.m_122012_());
        boolean southT = !south.m_60804_((BlockGetter)level, blockpos.m_122019_());
        boolean westT = !west.m_60804_((BlockGetter)level, blockpos.m_122024_());
        boolean eastT = !east.m_60804_((BlockGetter)level, blockpos.m_122029_());
        boolean aboveT = !above.m_60804_((BlockGetter)level, blockpos.m_7494_());
        boolean bl = belowT = !below.m_60804_((BlockGetter)level, blockpos.m_7495_());
        if (Math.random() < 0.1 && blockstate.m_60804_((BlockGetter)level, blockpos) && (nordT || southT || westT || eastT || aboveT || belowT)) {
            this.convertBlocks(blockstate, level, blockpos);
        }
        if (Math.random() < 0.2) {
            this.convertWood(level, blockstate, blockpos);
            this.placeRottenBush(above, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeGroundFoliage(above, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeWaterFoliage(above, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeHangingFoliage(below, level, blockpos, blockstate);
        }
        if (Math.random() < 0.01) {
            this.placeWallFoliage(nord, south, west, east, nordT, southT, westT, eastT, level, blockpos, blockstate);
        }
    }

    default public void additionPlacers(Level level, BlockPos pos, double range) {
    }

    default public void additionIgnoreConfigPlacers(Level level, BlockPos pos, double range) {
    }

    default public void placeGroundFoliage(BlockState above, Level level, BlockPos blockpos, BlockState blockstate) {
        if (above.m_60795_() && blockstate.m_60804_((BlockGetter)level, blockpos)) {
            BlockState block1 = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("spore:ground_foliage"))).getRandomElement(RandomSource.m_216327_()).orElse((Block)Sblocks.GROWTHS_BIG.get()).m_49966_();
            level.m_7731_(blockpos.m_7494_(), block1, 3);
        }
    }

    default public void placeRottenBush(BlockState above, Level level, BlockPos blockpos, BlockState blockstate) {
        if (above.m_60734_() instanceof BushBlock && !(above.m_60734_() instanceof GenericFoliageBlock) && blockstate.m_60804_((BlockGetter)level, blockpos)) {
            BlockState state = Math.random() < 0.5 ? ((Block)Sblocks.ROTTEN_BUSH.get()).m_49966_() : ((Block)Sblocks.GROWTHS_BIG.get()).m_49966_();
            level.m_7731_(blockpos.m_7494_(), state, 3);
        }
    }

    default public void placeWaterFoliage(BlockState above, Level level, BlockPos blockpos, BlockState blockstate) {
        BlockState block5 = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("spore:underwater_blocks"))).getRandomElement(RandomSource.m_216327_()).orElse((Block)Sblocks.GROWTHS_SMALL.get()).m_49966_();
        if (blockstate.m_60804_((BlockGetter)level, blockpos) && above.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            Property property = block5.m_60734_().m_49965_().m_61081_("waterlogged");
            if (property instanceof BooleanProperty) {
                BooleanProperty property2 = (BooleanProperty)property;
                level.m_7731_(blockpos.m_7494_(), (BlockState)block5.m_61124_((Property)property2, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                level.m_7731_(blockpos.m_7494_(), block5, 3);
            }
        }
    }

    default public void placeHangingFoliage(BlockState below, Level level, BlockPos blockpos, BlockState blockstate) {
        if (below.m_60795_() && blockstate.m_60804_((BlockGetter)level, blockpos)) {
            BlockState block2 = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("spore:roof_foliage"))).getRandomElement(RandomSource.m_216327_()).orElse((Block)Sblocks.FUNGAL_ROOTS.get()).m_49966_();
            Property property = block2.m_60734_().m_49965_().m_61081_("hanging");
            if (property instanceof BooleanProperty) {
                BooleanProperty property2 = (BooleanProperty)property;
                level.m_7731_(blockpos.m_7495_(), (BlockState)block2.m_61124_((Property)property2, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                level.m_7731_(blockpos.m_7495_(), block2, 3);
            }
        }
    }

    default public void placeWallFoliage(BlockState nord, BlockState south, BlockState west, BlockState east, boolean nordT, boolean southT, boolean westT, boolean eastT, Level level, BlockPos blockpos, BlockState blockstate) {
        if (blockstate.m_60804_((BlockGetter)level, blockpos) && (nordT || southT || westT || eastT)) {
            BlockState block3 = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("spore:wall_foliage"))).getRandomElement(RandomSource.m_216327_()).orElse((Block)Sblocks.WALL_GROWTHS.get()).m_49966_();
            Direction direction = Direction.NORTH;
            Direction direction2 = Direction.SOUTH;
            Direction direction3 = Direction.EAST;
            Direction direction4 = Direction.WEST;
            Property property = block3.m_60734_().m_49965_().m_61081_("facing");
            if (property instanceof DirectionProperty) {
                DirectionProperty directionProperty = (DirectionProperty)property;
                if (nord.m_60795_() && Math.random() < 0.5) {
                    level.m_7731_(blockpos.m_122012_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)direction), 3);
                }
                if (south.m_60795_() && Math.random() < 0.5) {
                    level.m_7731_(blockpos.m_122019_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)direction2), 3);
                }
                if (west.m_60795_() && Math.random() < 0.5) {
                    level.m_7731_(blockpos.m_122024_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)direction4), 3);
                }
                if (east.m_60795_() && Math.random() < 0.5) {
                    level.m_7731_(blockpos.m_122029_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)direction3), 3);
                }
            }
        }
    }

    default public void placeBranches(Level level, BlockPos blockpos, BlockState blockstate) {
        if (blockstate.m_60804_((BlockGetter)level, blockpos)) {
            BlockState block3 = ((Block)Sblocks.ROTTEN_BRANCH.get()).m_49966_();
            BlockState nord = level.m_8055_(blockpos.m_122012_());
            BlockState south = level.m_8055_(blockpos.m_122019_());
            BlockState west = level.m_8055_(blockpos.m_122024_());
            BlockState east = level.m_8055_(blockpos.m_122029_());
            Property property = block3.m_60734_().m_49965_().m_61081_("facing");
            if (property instanceof DirectionProperty) {
                DirectionProperty directionProperty = (DirectionProperty)property;
                if (nord.m_60734_() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.m_7731_(blockpos.m_122012_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)Direction.NORTH), 3);
                }
                if (south.m_60734_() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.m_7731_(blockpos.m_122019_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)Direction.SOUTH), 3);
                }
                if (west.m_60734_() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.m_7731_(blockpos.m_122024_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)Direction.WEST), 3);
                }
                if (east.m_60734_() instanceof LeavesBlock && Math.random() < 0.3) {
                    level.m_7731_(blockpos.m_122029_(), (BlockState)block3.m_61124_((Property)directionProperty, (Comparable)Direction.EAST), 3);
                }
            }
        }
    }

    default public void convertBlocks(BlockState blockstate, Level level, BlockPos blockpos) {
        for (String str : (List)SConfig.DATAGEN.block_infection.get()) {
            String[] string = str.split("\\|");
            Block blockCon1 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string[0]));
            Block blockCon2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string[1]));
            if (blockCon1 == null || blockCon2 == null || blockCon1 != blockstate.m_60734_()) continue;
            level.m_7731_(blockpos, blockCon2.m_49966_(), 3);
        }
    }

    default public void convertWood(Level level, BlockState blockstate, BlockPos blockpos) {
        Property _property;
        BlockState _bs;
        if (blockstate.m_204336_(BlockTags.f_13106_)) {
            _bs = ((Block)Sblocks.ROTTEN_LOG.get()).m_49966_();
            for (Map.Entry entry : blockstate.m_61148_().entrySet()) {
                _property = _bs.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
                if (_property == null || _bs.m_61143_(_property) == null) continue;
                try {
                    _bs = (BlockState)_bs.m_61124_(_property, (Comparable)entry.getValue());
                }
                catch (Exception exception) {}
            }
            level.m_7731_(blockpos, _bs, 3);
            this.placeBranches(level, blockpos, blockstate);
        }
        if (blockstate.m_204336_(BlockTags.f_13096_)) {
            _bs = ((Block)Sblocks.ROTTEN_STAIR.get()).m_49966_();
            for (Map.Entry entry : blockstate.m_61148_().entrySet()) {
                _property = _bs.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
                if (_property == null || _bs.m_61143_(_property) == null) continue;
                try {
                    _bs = (BlockState)_bs.m_61124_(_property, (Comparable)entry.getValue());
                }
                catch (Exception exception) {}
            }
            if (Math.random() < (double)0.3f) {
                FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos, (BlockState)_bs);
            } else {
                level.m_7731_(blockpos, _bs, 3);
            }
        }
        if (blockstate.m_204336_(BlockTags.f_13090_)) {
            _bs = ((Block)Sblocks.ROTTEN_PLANKS.get()).m_49966_();
            if (Math.random() < (double)0.3f && level.m_8055_(blockpos.m_7495_()).m_60795_()) {
                FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos, (BlockState)_bs);
            } else {
                level.m_7731_(blockpos, _bs, 3);
            }
        }
        if (blockstate.m_204336_(BlockTags.f_13097_)) {
            _bs = ((Block)Sblocks.ROTTEN_SLAB.get()).m_49966_();
            for (Map.Entry entry : blockstate.m_61148_().entrySet()) {
                _property = _bs.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
                if (_property == null || _bs.m_61143_(_property) == null) continue;
                try {
                    _bs = (BlockState)_bs.m_61124_(_property, (Comparable)entry.getValue());
                }
                catch (Exception exception) {}
            }
            level.m_7731_(blockpos, _bs, 3);
        }
        if (blockstate.m_204336_(BlockTags.f_13095_) || blockstate.m_204336_(BlockTags.f_13102_) || blockstate.m_204336_(BlockTags.f_13098_) || blockstate.m_204336_(BlockTags.f_13100_)) {
            _bs = ((Block)Sblocks.ROTTEN_SCRAPS.get()).m_49966_();
            FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos, (BlockState)_bs);
        }
    }
}

