/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.ProtectorModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class ProtectorRenderer<Type extends Protector>
extends BaseInfectedRenderer<Type, ProtectorModel<Type>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/protector.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/protector.png");

    public ProtectorRenderer(EntityRendererProvider.Context context) {
        super(context, new ProtectorModel(context.m_174023_(ProtectorModel.LAYER_LOCATION), false), 0.5f);
        this.m_115326_(new ProtectorArmorRenderer(this, context.m_266367_()));
        this.m_115326_(new PearlsLayer(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    private static class ProtectorArmorRenderer<T extends Protector>
    extends RenderLayer<T, ProtectorModel<T>> {
        public final List<ModelPart> helmetModels = new ArrayList<ModelPart>();
        public final List<ModelPart> bootsModels = new ArrayList<ModelPart>();
        private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
        private final TextureAtlas armorTrimAtlas;
        private static final ResourceLocation BLOOD_LAYER1 = new ResourceLocation("spore", "textures/overlay/blood_overlay.png");

        public ProtectorArmorRenderer(RenderLayerParent<T, ProtectorModel<T>> modelRenderLayerParent, ModelManager manager) {
            super(modelRenderLayerParent);
            this.armorTrimAtlas = manager.m_119428_(Sheets.f_265912_);
            this.helmetModels.add(((ProtectorModel)this.m_117386_()).headWear);
            this.bootsModels.add(((ProtectorModel)this.m_117386_()).RightBoot);
            this.bootsModels.add(((ProtectorModel)this.m_117386_()).LeftBoot);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            this.renderArmorPart(t, EquipmentSlot.HEAD, this.helmetModels, poseStack, multiBufferSource, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.renderArmorPart(t, EquipmentSlot.FEET, this.bootsModels, poseStack, multiBufferSource, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        private void renderArmorPart(T entity, EquipmentSlot slot, List<ModelPart> parts, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            ItemStack itemStack = entity.m_6844_(slot);
            boolean flag = itemStack.m_41790_();
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (armorItem instanceof DyeableLeatherItem) {
                    int i = ((DyeableLeatherItem)armorItem).m_41121_(itemStack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderArmor(parts, stack, bufferSource, packedLight, OverlayTexture.f_118083_, f, f1, f2, 1.0f, this.getArmorResource((Entity)entity, itemStack, slot, null), flag, slot);
                } else {
                    this.renderArmor(parts, stack, bufferSource, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)entity, itemStack, slot, null), flag, slot);
                }
                ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemStack).ifPresent(p_289638_ -> this.renderTrim(armorItem.m_40401_(), stack, bufferSource, packedLight, (ArmorTrim)p_289638_, parts, flag));
            }
        }

        private void renderArmor(List<ModelPart> parts, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, ResourceLocation location, boolean glint, EquipmentSlot slot) {
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)location));
            ((ProtectorModel)this.m_117386_()).Protector.m_171331_().forEach(modelPart -> this.setInvisible((ModelPart)modelPart, parts));
            ((ProtectorModel)this.m_117386_()).Protector.m_104306_(stack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
            if (glint) {
                ((ProtectorModel)this.m_117386_()).Protector.m_104306_(stack, bufferSource.m_6299_(RenderType.m_110496_()), packedLight, packedOverlay, red, green, blue, alpha);
            }
            this.renderBloodLayer(((ProtectorModel)this.m_117386_()).Protector, stack, bufferSource, packedLight);
        }

        private void setInvisible(ModelPart part, List<ModelPart> parts) {
            part.f_233556_ = !parts.contains(part);
        }

        private void renderTrim(ArmorMaterial material, PoseStack stack, MultiBufferSource source, int light, ArmorTrim armorTrim, List<ModelPart> parts, boolean flag) {
            TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(flag ? armorTrim.m_267774_(material) : armorTrim.m_267606_(material));
            VertexConsumer vertexconsumer = textureatlassprite.m_118381_(source.m_6299_(Sheets.m_266442_()));
            ((ProtectorModel)this.m_117386_()).Protector.m_171331_().forEach(modelPart -> this.setInvisible((ModelPart)modelPart, parts));
            ((ProtectorModel)this.m_117386_()).Protector.m_104306_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
            ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s1);
                ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
            }
            return resourcelocation;
        }

        private void renderBloodLayer(ModelPart part, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)BLOOD_LAYER1));
            part.m_104301_(stack, consumer, packedLight, OverlayTexture.f_118083_);
        }
    }

    private static class PearlsLayer<T extends Protector, M extends ProtectorModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;
        private final ProtectorModel<T> model;

        public PearlsLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
            this.model = (ProtectorModel)this.m_117386_();
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (((Protector)t).getPearls() > 0) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42584_);
                poseStack.m_85836_();
                this.model.LeftArm.m_104299_(poseStack);
                poseStack.m_85837_(0.0, 0.75, 0.0);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                this.itemInHandRenderer.m_269530_(t, stack, ItemDisplayContext.FIXED, true, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }
    }
}

