/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FallenMultipart.SiegerTail;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class Sieger
extends Calamity
implements RangedAttackMob,
TrueCalamity {
    public static final EntityDataAccessor<Float> TAIL_HP = SynchedEntityData.m_135353_(Sieger.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> ADAPTATION = SynchedEntityData.m_135353_(Sieger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart lowerbody;
    public final CalamityMultipart head;
    public final CalamityMultipart tail;
    public final CalamityMultipart tail2;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.SIEGER_BODY, HitboxesForParts.SIEGER_JAW, HitboxesForParts.SIEGER_RIGHT_LEG, HitboxesForParts.SIEGER_LEFT_LEG, HitboxesForParts.SIEGER_BACK_RIGHT_LEG, HitboxesForParts.SIEGER_BACK_LEFT_LEG);

    public Sieger(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.lowerbody = new CalamityMultipart(this, "lowerbody", 3.0f, 3.0f);
        this.tail = new CalamityMultipart(this, "tail", 1.5f, 1.5f);
        this.tail2 = new CalamityMultipart(this, "tail", 1.5f, 1.5f);
        this.head = new CalamityMultipart(this, "head", 1.4f, 1.4f);
        this.subEntities = new CalamityMultipart[]{this.lowerbody, this.tail, this.tail2, this.head};
        this.m_274367_(1.5f);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.sieger_loot.get();
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    @Override
    public double setInflation() {
        return 1.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() >= this.m_21233_() && this.getTailHp() < this.getMaxTailHp() && this.f_19797_ % 40 == 0) {
            this.setTailHp(this.getTailHp() + 1.0f);
        }
        if (this.f_19797_ % 20 == 0 && this.m_21223_() < this.m_21233_()) {
            this.f_19804_.m_135381_(ADAPTATION, (Object)((Integer)this.f_19804_.m_135370_(ADAPTATION) + 1));
        }
    }

    public void m_8107_() {
        float f14 = this.m_146908_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14031_((float)f14);
        float f15 = Mth.m_14089_((float)f14);
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        if (this.getTailHp() > 0.0f) {
            this.tickPart(this.tail, new Vec3(-1.5, 7.0, 0.0));
        } else {
            this.tickPart(this.tail, f2 * 2.0f, 1.0, -f15 * 2.0f);
        }
        if (this.getTailHp() > 0.0f) {
            this.tickPart(this.tail2, new Vec3(-3.0, 4.0, 0.0));
        } else {
            this.tickPart(this.tail2, f2 * 2.0f, 1.0, -f15 * 2.0f);
        }
        this.tickPart(this.head, f2 * -2.5f, 1.4, -f15 * -2.5f);
        this.tickPart(this.lowerbody, f2 * 3.0f, 0.0, -f15 * 3.0f);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        super.m_8107_();
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    boolean calculateHeight() {
        return this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && Math.abs(Math.abs(this.m_5448_().m_20186_()) - Math.abs(this.m_20186_())) > 5.0;
    }

    boolean calculateDistance() {
        return this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 400.0;
    }

    public boolean m_142582_(Entity entity) {
        if (this.calculateDistance() || this.calculateHeight()) {
            return true;
        }
        return super.m_142582_(entity);
    }

    private int[] ammoAmount() {
        int[] values = new int[2];
        if (this.isAdapted()) {
            values[0] = 5;
            values[1] = 8;
        } else {
            values[0] = 3;
            values[1] = 6;
        }
        return values;
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new ScatterShotRangedGoal(this, 1.5, 80, 48.0f, this.ammoAmount()[0], this.ammoAmount()[1]){

            @Override
            public boolean m_8036_() {
                if (Sieger.this.getTailHp() <= 0.0f) {
                    return false;
                }
                return super.m_8036_() && (Sieger.this.calculateHeight() || Sieger.this.calculateDistance());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AOEMeleeAttackGoal(this, 1.5, false, 2.5, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Sieger.this.m_20205_();
                return f * 3.0f * f * 3.0f + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new CalamityInfectedCommand(this));
        this.f_21345_.m_25352_(7, (Goal)new SummonScentInCombat(this));
        this.f_21345_.m_25352_(8, (Goal)new SporeBurstSupport(this));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        super.m_8099_();
    }

    public boolean m_213824_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.sieger_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.sieger_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.sieger_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_((Attribute)SAttributes.TOXICITY.get(), 0.0).m_22268_((Attribute)SAttributes.REJUVENATION.get(), 0.0).m_22268_((Attribute)SAttributes.LOCALIZATION.get(), 0.0).m_22268_((Attribute)SAttributes.LACERATION.get(), 0.0).m_22268_((Attribute)SAttributes.CORROSIVES.get(), 0.0).m_22268_((Attribute)SAttributes.BALLISTIC.get(), 0.0).m_22268_((Attribute)SAttributes.GRINDING.get(), 0.0);
    }

    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) > 200.0) {
            return null;
        }
        return (SoundEvent)Ssounds.SIEGER_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12361_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, this.isAdapted() ? amount * 0.7f : amount);
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.sieger_dpsr.get();
    }

    public void m_6504_(LivingEntity livingEntity, float p_33318_) {
        if (!this.m_9236_().f_46443_) {
            ThrownTumor tumor = new ThrownTumor(this.m_9236_(), (LivingEntity)this);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() + 5.0;
            double dz = livingEntity.m_20189_() - this.m_20189_();
            if (SConfig.SERVER.sieger_explosive_effects != null) {
                List ev = (List)SConfig.SERVER.sieger_explosive_effects.get();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = this.f_19796_.m_188503_(ev.size());
                    ResourceLocation randomElement1 = new ResourceLocation((String)ev.get(randomIndex));
                    MobEffect randomElement = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(randomElement1);
                    tumor.setMobEffect(randomElement);
                }
            }
            tumor.setExplode(Level.ExplosionInteraction.MOB);
            tumor.m_6027_(this.m_20185_(), this.m_20186_() + 8.2, this.m_20189_());
            tumor.m_6686_(dx, dy - tumor.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
            this.m_9236_().m_7967_((Entity)tumor);
        }
    }

    public boolean isAdapted() {
        return (Integer)this.f_19804_.m_135370_(ADAPTATION) >= 900;
    }

    @Override
    public void ActivateAdaptation() {
        this.f_19804_.m_135381_(ADAPTATION, (Object)900);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.m_216990_((SoundEvent)Ssounds.SIEGER_BITE.get());
        return super.m_7327_(entity);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAIL_HP, (Object)Float.valueOf(this.getMaxTailHp()));
        this.f_19804_.m_135372_(ADAPTATION, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("tail_hp", ((Float)this.f_19804_.m_135370_(TAIL_HP)).floatValue());
        tag.m_128405_("adaptation", ((Integer)this.f_19804_.m_135370_(ADAPTATION)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TAIL_HP, (Object)Float.valueOf(tag.m_128457_("tail_hp")));
        this.f_19804_.m_135381_(ADAPTATION, (Object)tag.m_128451_("adaptation"));
    }

    public float getTailHp() {
        return ((Float)this.f_19804_.m_135370_(TAIL_HP)).floatValue();
    }

    public void setTailHp(float i) {
        this.f_19804_.m_135381_(TAIL_HP, (Object)Float.valueOf(i));
    }

    public float getMaxTailHp() {
        return (float)((Double)SConfig.SERVER.sieger_hp.get() / 4.0);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.tail || calamityMultipart == this.tail2) {
            if (this.getTailHp() > 0.0f && value > this.getTailHp()) {
                this.m_216990_((SoundEvent)Ssounds.LIMB_SLASH.get());
                this.SummonDetashedTail();
            }
            this.m_6469_(source, this.isAdapted() ? value : value * 2.0f);
            this.setTailHp(value > this.getTailHp() ? 0.0f : this.getTailHp() - value);
        }
        if (calamityMultipart == this.head) {
            this.m_6469_(source, value * 0.75f);
        } else {
            this.m_6469_(source, value);
        }
        return true;
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.sieger_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.sieger_debuffs.get();
    }

    private void SummonDetashedTail() {
        SiegerTail siegerTail = new SiegerTail((EntityType<? extends PathfinderMob>)((EntityType)Sentities.SIEGER_TAIL.get()), this.m_9236_());
        Vec3 vec3 = new Vec3(-1.7, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        siegerTail.setWar(this.isAdapted());
        siegerTail.m_6027_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + 1.6, this.m_20189_() + vec3.f_82481_);
        this.m_9236_().m_7967_((Entity)siegerTail);
    }

    @Override
    public String getMutation() {
        if (this.isAdapted()) {
            return "spore.entity.variant.war_torn";
        }
        return super.getMutation();
    }

    @Override
    public boolean getAdaptation() {
        return this.isAdapted();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        if (this.getTailHp() > 0.0f) {
            values.add(HitboxesForParts.SIEGER_TAIL);
        }
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.75f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }
}

