/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.event.CameraSetupEvent;
import com.tacz.guns.client.event.FirstPersonRenderGunEvent;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.TransformScale;
import com.tacz.guns.util.RenderDistance;
import com.tacz.guns.util.math.MathUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ViewportEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GunItemRendererWrapper
extends AnimateGeoItemRenderer<BedrockGunModel, GunAnimationStateContext> {
    private static final SlotModel SLOT_GUN_MODEL = new SlotModel();
    private static BedrockGunModel lastModel = null;
    public static final Vector3f muzzleRenderOffset = new Vector3f();

    @Override
    public GunAnimationStateContext initContext(ItemStack stack, Player player, float partialTick) {
        GunAnimationStateContext context = new GunAnimationStateContext();
        this.updateContext(context, stack, player, partialTick);
        return context;
    }

    @Override
    public void updateContext(GunAnimationStateContext context, ItemStack stack, Player player, float partialTick) {
        context.setPartialTicks(partialTick);
        context.setCurrentGunItem(stack);
    }

    @Override
    public void tryInit(ItemStack stack, Player player, float partialTick) {
        super.tryInit(stack, player, partialTick);
    }

    @Override
    public void tryExit(ItemStack stack, long putAwayTime) {
        LuaAnimationStateMachine<GunAnimationStateContext> stateMachine = this.getStateMachine(stack);
        if (stateMachine == null) {
            return;
        }
        stateMachine.processContextIfExist(context -> {
            context.setPutAwayTime((float)putAwayTime / 1000.0f);
            context.setCurrentGunItem(stack);
        });
        if (stateMachine.isInitialized()) {
            stateMachine.trigger("put_away");
            KeepingItemRenderer.getRenderer().keep(stack, putAwayTime);
            stateMachine.exit();
            stateMachine.setExitingTime(putAwayTime + 50L);
        }
    }

    @Override
    public long getPutAwayTime(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(stack)).map(index -> (long)(index.getGunData().getPutAwayTime() * 1000.0f)).orElse(0L);
        }
        return 0L;
    }

    @Override
    @Nullable
    public LuaAnimationStateMachine<GunAnimationStateContext> getStateMachine(ItemStack stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getAnimationStateMachine).orElse(null);
    }

    @Override
    public BedrockGunModel getModel(ItemStack stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getGunModel).orElse(null);
    }

    @Override
    public ResourceLocation getTextureLocation(ItemStack stack) {
        return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getModelTexture).orElse(null);
    }

    @Override
    public void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event, ItemStack stack, LocalPlayer player) {
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        Optional.ofNullable(this.getModel(stack)).ifPresent(model -> {
            if (lastModel != model) {
                model.cleanCameraAnimationTransform();
                lastModel = model;
            }
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            this.applyLevelCameraAnimation(event, stack, multiplier);
        });
    }

    @Override
    public void applyItemInHandCameraAnimation(BeforeRenderHandEvent event, ItemStack stack, LocalPlayer player) {
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        Optional.ofNullable(this.getModel(stack)).ifPresent(model -> {
            PoseStack poseStack = event.getPoseStack();
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            Quaternionf quaternion = MathUtil.multiplyQuaternion(model.getCameraAnimationObject().rotationQuaternion, multiplier);
            poseStack.m_252781_(quaternion);
            model.cleanCameraAnimationTransform();
        });
    }

    @Override
    public void renderFirstPerson(LocalPlayer player, ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource bufferSource, int light, float partialTick) {
        if (!(stack.m_41720_() instanceof IGun)) {
            return;
        }
        TimelessAPI.getGunDisplay(stack).ifPresent(display -> {
            BedrockGunModel gunModel = display.getGunModel();
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (gunModel == null) {
                return;
            }
            animationStateMachine.processContextIfExist(context -> this.updateContext((GunAnimationStateContext)context, stack, (Player)player, partialTick));
            animationStateMachine.update();
            poseStack.m_85836_();
            float xRotOffset = Mth.m_14179_((float)partialTick, (float)player.f_108588_, (float)player.f_108586_);
            float yRotOffset = Mth.m_14179_((float)partialTick, (float)player.f_108587_, (float)player.f_108585_);
            float xRot = player.m_5686_(partialTick) - xRotOffset;
            float yRot = player.m_5675_(partialTick) - yRotOffset;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot * -0.1f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot * -0.1f));
            BedrockPart rootNode = gunModel.getRootNode();
            if (rootNode != null) {
                xRot = (float)Math.tanh(xRot / 25.0f) * 25.0f;
                yRot = (float)Math.tanh(yRot / 25.0f) * 25.0f;
                rootNode.offsetX += yRot * 0.1f / 16.0f / 3.0f;
                rootNode.offsetY += -xRot * 0.1f / 16.0f / 3.0f;
                rootNode.additionalQuaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(xRot * 0.05f));
                rootNode.additionalQuaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(yRot * 0.05f));
            }
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            FirstPersonRenderGunEvent.applyFirstPersonGunTransform(player, stack, poseStack, gunModel, partialTick);
            MuzzleFlashRender.isSelf = true;
            ShellRender.isSelf = true;
            boolean renderHand = gunModel.getRenderHand();
            if (RefitTransform.getOpeningProgress() != 0.0f) {
                gunModel.setRenderHand(false);
            }
            RenderType renderType = RenderType.m_110452_((ResourceLocation)display.getModelTexture());
            gunModel.render(poseStack, stack, ctx, renderType, light, OverlayTexture.f_118083_);
            GunItemRendererWrapper.cacheMuzzlePosition(poseStack, gunModel);
            gunModel.setRenderHand(renderHand);
            poseStack.m_85849_();
            gunModel.cleanAnimationTransform();
            MuzzleFlashRender.isSelf = false;
            ShellRender.isSelf = false;
        });
    }

    private static void cacheMuzzlePosition(PoseStack poseStack, BedrockGunModel gunModel) {
        if (gunModel.getMuzzleFlashPosPath() != null) {
            poseStack.m_85836_();
            for (BedrockPart bedrockPart : gunModel.getMuzzleFlashPosPath()) {
                bedrockPart.translateAndRotateAndScale(poseStack);
            }
            Matrix4f pose = poseStack.m_85850_().m_252922_();
            double itemRenderFov = CameraSetupEvent.ITEM_MODEL_FOV_DYNAMICS.get();
            double levelRenderFov = CameraSetupEvent.WORLD_FOV_DYNAMICS.get();
            poseStack.m_85849_();
            muzzleRenderOffset.set((double)pose.m30(), (double)pose.m31(), (double)pose.m32() * Math.tan(itemRenderFov / 2.0 * Math.PI / 180.0) / Math.tan(levelRenderFov / 2.0 * Math.PI / 180.0));
        }
    }

    @Override
    public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (!(stack.m_41720_() instanceof IGun)) {
            return;
        }
        poseStack.m_85836_();
        TimelessAPI.getGunDisplay(stack).ifPresentOrElse(gunIndex -> {
            ResourceLocation gunTexture;
            BedrockGunModel gunModel;
            if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return;
            }
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                return;
            }
            if (transformType == ItemDisplayContext.GUI) {
                poseStack.m_85837_(0.5, 1.5, 0.5);
                poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
                VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)gunIndex.getSlotTexture()));
                SLOT_GUN_MODEL.m_7695_(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            Pair<BedrockGunModel, ResourceLocation> lodModel = gunIndex.getLodModel();
            if (lodModel == null || RenderDistance.inRenderHighPolyModelDistance(poseStack)) {
                gunModel = gunIndex.getGunModel();
                gunTexture = gunIndex.getModelTexture();
            } else {
                gunModel = (BedrockGunModel)lodModel.getLeft();
                gunTexture = (ResourceLocation)lodModel.getRight();
            }
            poseStack.m_85837_(0.5, 2.0, 0.5);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            GunItemRendererWrapper.applyPositioningTransform(transformType, gunIndex.getTransform().getScale(), gunModel, poseStack);
            GunItemRendererWrapper.applyScaleTransform(transformType, gunIndex.getTransform().getScale(), poseStack);
            RenderType renderType = RenderType.m_110452_((ResourceLocation)gunTexture);
            gunModel.render(poseStack, stack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)MissingTextureAtlasSprite.m_118071_()));
            SLOT_GUN_MODEL.m_7695_(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        });
        poseStack.m_85849_();
    }

    private static void applyPositioningTransform(ItemDisplayContext transformType, TransformScale scale, BedrockGunModel model, PoseStack poseStack) {
        switch (transformType) {
            case FIXED: {
                GunItemRendererWrapper.applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
                break;
            }
            case GROUND: {
                GunItemRendererWrapper.applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                GunItemRendererWrapper.applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
            }
        }
    }

    private static void applyScaleTransform(ItemDisplayContext transformType, TransformScale scale, PoseStack poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case FIXED: {
                vector3f = scale.getFixed();
                break;
            }
            case GROUND: {
                vector3f = scale.getGround();
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                vector3f = scale.getThirdPerson();
            }
        }
        if (vector3f != null) {
            poseStack.m_85837_(0.0, 1.5, 0.0);
            poseStack.m_85841_(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.m_85837_(0.0, -1.5, 0.0);
        }
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, PoseStack poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85837_(0.0, 1.5, 0.0);
        for (int i = nodePath.size() - 1; i >= 0; --i) {
            BedrockPart t = nodePath.get(i);
            poseStack.m_252781_(Axis.f_252495_.m_252961_(t.xRot));
            poseStack.m_252781_(Axis.f_252392_.m_252961_(t.yRot));
            poseStack.m_252781_(Axis.f_252393_.m_252961_(t.zRot));
            if (t.getParent() != null) {
                poseStack.m_252880_(-t.x * scale.x() / 16.0f, -t.y * scale.y() / 16.0f, -t.z * scale.z() / 16.0f);
                continue;
            }
            poseStack.m_252880_(-t.x * scale.x() / 16.0f, (1.5f - t.y / 16.0f) * scale.y(), -t.z * scale.z() / 16.0f);
        }
        poseStack.m_85837_(0.0, -1.5, 0.0);
    }
}

