/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.google.common.collect.Maps;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAmmoIndex;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientBlockIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.AmmoIndexPOJO;
import com.tacz.guns.resource.pojo.AttachmentIndexPOJO;
import com.tacz.guns.resource.pojo.BlockIndexPOJO;
import com.tacz.guns.resource.pojo.GunIndexPOJO;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientIndexManager {
    public static final Map<ResourceLocation, GunDisplayInstance> GUN_DISPLAY = Maps.newHashMap();
    public static final Map<ResourceLocation, ClientGunIndex> GUN_INDEX = Maps.newHashMap();
    public static final Map<ResourceLocation, ClientAmmoIndex> AMMO_INDEX = Maps.newHashMap();
    public static final Map<ResourceLocation, ClientAttachmentIndex> ATTACHMENT_INDEX = Maps.newHashMap();
    public static final Map<ResourceLocation, ClientBlockIndex> BLOCK_INDEX = Maps.newHashMap();

    public static void reload() {
        GUN_DISPLAY.clear();
        GUN_INDEX.clear();
        AMMO_INDEX.clear();
        ATTACHMENT_INDEX.clear();
        BLOCK_INDEX.clear();
        ClientIndexManager.loadGunDisplay();
        ClientIndexManager.loadGunIndex();
        ClientIndexManager.loadAmmoIndex();
        ClientIndexManager.loadAttachmentIndex();
        ClientIndexManager.loadBlockIndex();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && IGun.mainHandHoldGun((LivingEntity)player)) {
            AttachmentPropertyManager.postChangeEvent((LivingEntity)player, player.m_21205_());
            IClientPlayerGunOperator.fromLocalPlayer(player).draw(ItemStack.f_41583_);
        }
    }

    public static void loadGunDisplay() {
        ClientAssetsManager.INSTANCE.getGunDisplays().forEach(entry -> {
            try {
                GUN_DISPLAY.put((ResourceLocation)entry.getKey(), GunDisplayInstance.create((GunDisplay)entry.getValue()));
            }
            catch (IllegalArgumentException exception) {
                GunMod.LOGGER.warn("{} display init read fail!", entry.getKey(), (Object)exception);
            }
        });
    }

    public static void loadGunIndex() {
        TimelessAPI.getAllCommonGunIndex().forEach(index -> {
            ResourceLocation id = (ResourceLocation)index.getKey();
            GunIndexPOJO pojo = ((CommonGunIndex)index.getValue()).getPojo();
            try {
                GUN_INDEX.put(id, ClientGunIndex.getInstance(pojo));
            }
            catch (IllegalArgumentException exception) {
                GunMod.LOGGER.warn("{} index file read fail!", (Object)id, (Object)exception);
            }
        });
    }

    public static void loadAmmoIndex() {
        TimelessAPI.getAllCommonAmmoIndex().forEach(index -> {
            ResourceLocation id = (ResourceLocation)index.getKey();
            AmmoIndexPOJO pojo = ((CommonAmmoIndex)index.getValue()).getPojo();
            try {
                AMMO_INDEX.put(id, ClientAmmoIndex.getInstance(pojo));
            }
            catch (IllegalArgumentException exception) {
                GunMod.LOGGER.warn("{} index file read fail!", (Object)id, (Object)exception);
            }
        });
    }

    public static void loadAttachmentIndex() {
        TimelessAPI.getAllCommonAttachmentIndex().forEach(index -> {
            ResourceLocation id = (ResourceLocation)index.getKey();
            AttachmentIndexPOJO pojo = ((CommonAttachmentIndex)index.getValue()).getPojo();
            try {
                ATTACHMENT_INDEX.put(id, ClientAttachmentIndex.getInstance(id, pojo));
            }
            catch (IllegalArgumentException exception) {
                GunMod.LOGGER.warn("{} index file read fail!", (Object)id, (Object)exception);
            }
        });
    }

    public static void loadBlockIndex() {
        TimelessAPI.getAllCommonBlockIndex().forEach(index -> {
            ResourceLocation id = (ResourceLocation)index.getKey();
            BlockIndexPOJO pojo = ((CommonBlockIndex)index.getValue()).getPojo();
            try {
                BLOCK_INDEX.put(id, ClientBlockIndex.getInstance(pojo));
            }
            catch (IllegalArgumentException exception) {
                GunMod.LOGGER.warn("{} index file read fail!", (Object)id, (Object)exception);
            }
        });
    }

    public static Set<Map.Entry<ResourceLocation, ClientGunIndex>> getAllGuns() {
        return GUN_INDEX.entrySet();
    }

    public static Set<Map.Entry<ResourceLocation, ClientAmmoIndex>> getAllAmmo() {
        return AMMO_INDEX.entrySet();
    }

    public static Set<Map.Entry<ResourceLocation, ClientAttachmentIndex>> getAllAttachments() {
        return ATTACHMENT_INDEX.entrySet();
    }

    public static Set<Map.Entry<ResourceLocation, ClientBlockIndex>> getAllBlocks() {
        return BLOCK_INDEX.entrySet();
    }
}

