/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tacz.guns.config.sync.SyncConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.server.command.EnumArgument;

public class ConfigCommand {
    private static final String CONFIG_NAME = "config";
    private static final String KEY = "key";
    private static final String ENABLE = "state";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder config = Commands.m_82127_((String)CONFIG_NAME);
        RequiredArgumentBuilder configKey = Commands.m_82129_((String)KEY, (ArgumentType)EnumArgument.enumArgument(ConfigKey.class));
        RequiredArgumentBuilder state = Commands.m_82129_((String)ENABLE, (ArgumentType)BoolArgumentType.bool());
        return (LiteralArgumentBuilder)config.then(configKey.then(state.executes(ConfigCommand::setConfig)));
    }

    private static int setConfig(CommandContext<CommandSourceStack> context) {
        ConfigKey key = (ConfigKey)((Object)context.getArgument(KEY, ConfigKey.class));
        boolean state = BoolArgumentType.getBool(context, (String)ENABLE);
        if (key == null) {
            return 0;
        }
        switch (key) {
            case defaultTableLimit: {
                SyncConfig.ENABLE_TABLE_FILTER.set((Object)state);
                break;
            }
            case serverShootNetworkCheck: {
                SyncConfig.SERVER_SHOOT_NETWORK_V.set((Object)state);
                break;
            }
            case serverShootCooldownCheck: {
                SyncConfig.SERVER_SHOOT_COOLDOWN_V.set((Object)state);
            }
        }
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237115_((String)(key.lang + "." + (state ? "enabled" : "disabled"))));
        return 1;
    }

    public static enum ConfigKey {
        defaultTableLimit("commands.tacz.config.default_table_limit"),
        serverShootNetworkCheck("commands.tacz.config.server_shoot_network_check"),
        serverShootCooldownCheck("commands.tacz.config.server_shoot_cooldown_check");

        public final String lang;

        private ConfigKey(String lang) {
            this.lang = lang;
        }
    }
}

