/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.sync.core;

import com.tacz.guns.entity.sync.core.DataEntry;
import com.tacz.guns.entity.sync.core.DataHolder;
import com.tacz.guns.entity.sync.core.SyncedClassKey;
import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DataHolderCapabilityProvider
implements ICapabilitySerializable<ListTag> {
    public static final Capability<DataHolder> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DataHolder>(){});
    private final DataHolder holder = new DataHolder();
    private final LazyOptional<DataHolder> optional = LazyOptional.of(() -> this.holder);

    public void invalidate() {
        this.optional.invalidate();
    }

    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        this.holder.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                CompoundTag keyTag = new CompoundTag();
                keyTag.m_128359_("ClassKey", key.classKey().id().toString());
                keyTag.m_128359_("DataKey", key.id().toString());
                keyTag.m_128365_("Value", entry.writeValue());
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    public void deserializeNBT(ListTag listTag) {
        this.holder.dataMap.clear();
        listTag.forEach(entryTag -> {
            CompoundTag keyTag = (CompoundTag)entryTag;
            ResourceLocation classKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("ClassKey"));
            ResourceLocation dataKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("DataKey"));
            Tag value = keyTag.m_128423_("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = SyncedEntityData.instance().getKey(syncedClassKey, dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(syncedDataKey);
            entry.readValue(value);
            this.holder.dataMap.put(syncedDataKey, entry);
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, this.optional);
    }
}

