/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.electric_pump;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.ElectricNetworkManager;
import com.drmangotea.tfmg.content.electricity.base.ElectricalGroup;
import com.drmangotea.tfmg.content.electricity.base.ElectricalNetwork;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.NetworkUpdatePacket;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class ElectricPumpBlockEntity
extends PumpBlockEntity
implements IElectric {
    public ElectricBlockValues data = new ElectricBlockValues(this.getPos());
    int powerPercentage = 100;

    public ElectricPumpBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
        this.data.connectNextTick = true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new ElectricPumpTransferBehavior((SmartBlockEntity)this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PUMP});
    }

    protected void distributePressureTo(Direction side) {
        BlockFace start = new BlockFace(this.f_58858_, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair> pipeGraph = new HashMap<BlockPos, Pair>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks((Level)this.f_58857_, (BlockPos)this.f_58858_, (Direction)side.m_122424_());
        }
        if (!this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.f_58858_, $ -> Pair.of((Object)0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of((Object)1, new IdentityHashMap())).getSecond()).put(side.m_122424_(), !pull);
            ArrayList<Pair> frontier = new ArrayList<Pair>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            int maxDistance = (int)((double)FluidPropagator.getPumpRange() * Math.min((double)6.7f, (double)this.data.getVoltage() * 0.02));
            frontier.add(Pair.of((Object)1, (Object)start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.f_58857_.m_46749_(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.f_58857_.m_8055_(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections((BlockState)currentState, (FluidTransportBehaviour)pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.f_58857_.m_46749_(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof ElectricPumpTransferBehavior || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of((Object)(distance + 1), new IdentityHashMap())).getSecond()).put(face.m_122424_(), !pull);
                    frontier.add(Pair.of((Object)(distance + 1), (Object)connectedPos));
                }
            }
        }
        HashMap validFaces = new HashMap();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = this.getPowerUsage() == 0 ? 0.0f : (float)Math.min(1500, this.data.getVoltage() * 2);
        for (Set set : validFaces.values()) {
            int parallelBranches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.f_58858_)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    private boolean hasReachedValidEndpoint(LevelAccessor world, BlockFace blockFace, boolean pull) {
        LazyOptional capability;
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.m_8055_(connectedPos);
        BlockEntity blockEntity = world.m_7702_(connectedPos);
        Direction face = blockFace.getFace();
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == face.m_122434_() && blockEntity instanceof ElectricPumpBlockEntity) {
            ElectricPumpBlockEntity pumpBE = (ElectricPumpBlockEntity)blockEntity;
            return pumpBE.isPullingOnSide(pumpBE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, (BlockPos)connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (blockEntity != null && (capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_())).isPresent()) {
            return true;
        }
        return FluidPropagator.isOpenEnd((BlockGetter)world, (BlockPos)blockFace.getPos(), (Direction)face);
    }

    protected boolean isFront(Direction side) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PumpBlock)) {
            return false;
        }
        Direction front = (Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Override
    public LevelAccessor getLevelAccessor() {
        return this.f_58857_;
    }

    @Override
    public boolean destroyed() {
        return this.data.destroyed;
    }

    @Override
    public ElectricalNetwork getOrCreateElectricNetwork() {
        if (this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.data.electricalNetworkId)) instanceof IElectric) {
            return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.data.electricalNetworkId)));
        }
        ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.data.electricalNetworkId);
        return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
    }

    public void lazyTick() {
        super.lazyTick();
    }

    @Override
    public ElectricBlockValues getData() {
        return this.data;
    }

    @Override
    public float resistance() {
        return 100.0f;
    }

    @Override
    public int voltageGeneration() {
        int voltageGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof VoltageAlteringBlockEntity) || (be = (VoltageAlteringBlockEntity)blockEntity).getData().getId() == this.getData().getId() || be.getData().getVoltage() == 0 || !be.hasElectricitySlot(direction)) continue;
            voltageGeneration = Math.max(voltageGeneration, be.getOutputVoltage());
            this.data.getsOutsidePower = true;
        }
        if (voltageGeneration == 0) {
            this.data.getsOutsidePower = false;
        }
        return voltageGeneration;
    }

    @Override
    public int powerGeneration() {
        int powerGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof VoltageAlteringBlockEntity) || (be = (VoltageAlteringBlockEntity)blockEntity).getData().getId() == this.getData().getId() || be.getData().getVoltage() == 0 || !be.hasElectricitySlot(direction)) continue;
            powerGeneration = Math.max(powerGeneration, be.getPowerUsage()) + 1;
        }
        return powerGeneration;
    }

    @Override
    public int frequencyGeneration() {
        return 0;
    }

    @Override
    public void updateNextTick() {
        this.data.updateNextTick = true;
    }

    @Override
    public void updateNetwork() {
        this.getOrCreateElectricNetwork().updateNetwork();
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(BlockPos.m_122022_((long)this.getPos())));
        }
        this.sendData();
    }

    @Override
    public void sendStuff() {
        this.sendData();
    }

    @Override
    public void setVoltage(int newVoltage) {
        if (this.canBeInGroups()) {
            this.data.voltage = (int)(this.resistance() / this.data.group.resistance * (float)this.data.voltageSupply);
            return;
        }
        this.data.voltage = newVoltage;
    }

    @Override
    public void setFrequency(int newFrequency) {
        this.data.frequency = newFrequency;
    }

    @Override
    public void setNetworkResistance(int newUsage) {
        this.data.networkResistance = newUsage;
    }

    @Override
    public int getNetworkResistance() {
        return this.data.networkResistance;
    }

    @Override
    public void setNetwork(long network) {
        this.data.electricalNetworkId = network;
        if (network != this.getPos()) {
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.getPos());
        }
    }

    @Override
    public long getPos() {
        return this.m_58899_().m_121878_();
    }

    public void remove() {
        super.remove();
        this.data.destroyed = true;
        for (Direction d : Direction.values()) {
            IElectric be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(d) || !((blockEntity = this.getLevelAccessor().m_7702_(BlockPos.m_122022_((long)this.getPos()).m_121945_(d))) instanceof IElectric) || !(be = (IElectric)blockEntity).hasElectricitySlot(d.m_122424_())) continue;
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(be.getPos());
            be.setNetwork(be.getPos());
            be.onPlaced();
            be.updateNextTick();
        }
        if (this.data.electricalNetworkId != this.getPos()) {
            this.getOrCreateElectricNetwork().getMembers().remove(this);
        }
        if (this.data.electricalNetworkId == this.getPos()) {
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.getData().getId());
        }
    }

    public void tick() {
        super.tick();
        if (this.data.connectNextTick) {
            this.onPlaced();
            this.data.connectNextTick = false;
        }
        if (this.data.updateNextTick) {
            this.updateNetwork();
            this.data.updateNextTick = false;
        }
        if (this.data.setVoltageNextTick) {
            this.setVoltage(this.data.voltageSupply);
            this.data.setVoltageNextTick = false;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("GroupId", this.data.group.id);
        compound.m_128350_("GroupResistance", this.data.group.resistance);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.data.group = new ElectricalGroup(compound.m_128451_("GroupId"));
        this.data.group.resistance = compound.m_128457_("GroupResistance");
        if (!clientPacket) {
            this.data.connectNextTick = true;
        }
    }

    class ElectricPumpTransferBehavior
    extends FluidTransportBehaviour {
        public ElectricPumpTransferBehavior(SmartBlockEntity be) {
            super(be);
        }

        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = ElectricPumpBlockEntity.this.isPullingOnSide(ElectricPumpBlockEntity.this.isFront((Direction)entry.getKey()));
                Couple pressure = ((PipeConnection)entry.getValue()).getPressure();
                pressure.set(pull, (Object)Float.valueOf(ElectricPumpBlockEntity.this.getPowerUsage() == 0 ? 0.0f : Math.min(1500.0f, (float)ElectricPumpBlockEntity.this.data.getVoltage() * 2.0f)));
                pressure.set(!pull, (Object)Float.valueOf(0.0f));
            }
        }

        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return ElectricPumpBlockEntity.this.isSideAccessible(direction);
        }

        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

