/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class BlastFurnaceHatchBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public FluidTank tank;
    public SmartInventory inventory;
    public LazyOptional<IFluidHandler> fluidCapability;
    public LazyOptional<IItemHandlerModifiable> itemCapability;

    public BlastFurnaceHatchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.tank = TFMGUtils.createTank(4000, true, this::onFluidChanged);
        this.inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(64);
        this.fluidCapability = LazyOptional.of(() -> this.tank);
        this.itemCapability = LazyOptional.of(() -> this.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    public void lazyTick() {
        super.lazyTick();
        this.dropItems();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
    }

    public void dropItems() {
        if (this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60795_()) {
            Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, -0.75, 0.0);
            ItemEntity dropped = new ItemEntity(this.f_58857_, dropVec.f_82479_, dropVec.f_82480_, dropVec.f_82481_, this.inventory.m_8020_(0).m_41777_());
            dropped.m_32060_();
            dropped.m_20334_(0.0, -0.25, 0.0);
            this.f_58857_.m_7967_((Entity)dropped);
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("TankContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    private void onFluidChanged(FluidStack stack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }
}

