/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PlayMessages;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEntities;

public final class SpectralBite
extends EvokerFangs {
    private boolean isSpectral = false;
    private int damage = 1;

    public SpectralBite(EntityType<? extends SpectralBite> entityType, Level level) {
        super(entityType, level);
    }

    public SpectralBite(Level level, double x, double y, double z, float rotRad, int warmupDelayTicks, LivingEntity owner) {
        this(ModEntities.spectral_bite, level);
        this.f_36916_ = warmupDelayTicks;
        this.m_36938_(owner);
        this.m_146922_(rotRad * 57.295776f);
        this.m_6034_(x, y, z);
    }

    public SpectralBite(PlayMessages.SpawnEntity ignoredSpawn, Level level) {
        this(ModEntities.spectral_bite, level);
    }

    public void m_36944_(LivingEntity target) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LivingEntity owner = this.m_19749_();
            if (target.m_6084_() && !target.m_20147_() && target != owner) {
                int oldDuration;
                if (Optional.ofNullable(owner).map(o -> o.m_7307_((Entity)target)).orElse(false).booleanValue()) {
                    return;
                }
                if (this.isSpectral && (oldDuration = EffectHelper.getDuration(target, MobEffects.f_19615_, 0)) >= 0) {
                    target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 5 + oldDuration, 0), (Entity)owner);
                }
                if (owner == null) {
                    Helper.hurtWithoutCooldown(target, this.m_269291_().m_269425_(), this.damage);
                } else if (!owner.m_7307_((Entity)target)) {
                    Helper.hurtWithoutCooldown(target, this.m_269291_().m_269104_((Entity)this, (Entity)owner), this.damage);
                }
                target.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 5), (Entity)owner);
            }
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("damage", this.damage);
        compoundTag.m_128379_("is_spectral", this.isSpectral);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("damage", 3)) {
            this.damage = compoundTag.m_128451_("damage");
        }
        if (compoundTag.m_128425_("is_spectral", 1)) {
            this.isSpectral = compoundTag.m_128471_("is_spectral");
        }
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setSpectral(boolean isSpectral) {
        this.isSpectral = isSpectral;
    }
}

