/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessagePlayerPreference;

public record CMessageLogin(TimeHelper.SpecialEvent specialEvent, long globalTime, ListTag clientCooldowns) {
    static CMessageLogin fromBytes(FriendlyByteBuf buf) {
        return new CMessageLogin(TimeHelper.SpecialEvent.byId(buf.readShort()), buf.readLong(), Optional.ofNullable(buf.m_130260_()).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, "tb_cooldowns")).orElse(new ListTag()));
    }

    static void toBytes(CMessageLogin msg, FriendlyByteBuf buf) {
        buf.writeShort(msg.specialEvent().ordinal());
        buf.writeLong(msg.globalTime());
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("tb_cooldowns", (Tag)msg.clientCooldowns());
        buf.m_130079_(compound);
    }

    public static class Handler {
        static void handle(final CMessageLogin message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        TimeHelper.setSpecialEvent(message.specialEvent());
                        GlobalClock.INSTANCE.setClientTime(message.globalTime());
                        CooldownHandler.INSTANCE.updateAllClientCooldowns(message.clientCooldowns());
                        PacketHandler.sendToServer(new SMessagePlayerPreference(ModTombstone.PROXY.initPlayerPreference(), true));
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

