/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.task.SpellCombatFarTask;
import com.github.yimeng261.maidspell.task.SpellCombatMeleeTask;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.DoubleValue MAX_SPELL_RANGE = BUILDER.comment("\u6700\u5927\u6cd5\u672f\u653b\u51fb\u8303\u56f4 (\u9ed8\u8ba4: 24.0)").comment("Maximum spell attack range").defineInRange("maxSpellRange", 24.0, 8.0, 64.0);
    private static final ForgeConfigSpec.DoubleValue MELEE_RANGE = BUILDER.comment("\u8fd1\u6218\u653b\u51fb\u8303\u56f4 (\u9ed8\u8ba4: 2.5)").comment("Melee attack range").defineInRange("meleeRange", 2.5, 1.0, 5.0);
    private static final ForgeConfigSpec.DoubleValue FAR_RANGE = BUILDER.comment("\u8fdc\u7a0b\u653b\u51fb\u8303\u56f4 (\u9ed8\u8ba4: 8.5)").comment("Far attack range").defineInRange("farRange", 8.5, 1.0, 20.0);
    private static final ForgeConfigSpec.DoubleValue SPELL_DAMAGE_MULTIPLIER = BUILDER.comment("\u5973\u4ec6\u4f24\u5bb3\u500d\u7387 (\u9ed8\u8ba4: 1.0\uff0c\u4ec5\u5728\u6cd5\u672f\u6218\u6597\u4efb\u52a1\u4e0b\u751f\u6548)").comment("Maid damage multiplier(default:1.0,only effective on spellCombatTask)").defineInRange("maidDamageMultiplier", 1.0, 0.0, 50.0);
    private static final ForgeConfigSpec.DoubleValue COOLDOWN_MULITIPLIER = BUILDER.comment("\u5973\u4ec6\u6cd5\u672f\u51b7\u5374\u500d\u7387 (\u9ed8\u8ba4: 1.0\uff0c\u4ec5\u5728\u6cd5\u672f\u6218\u6597\u4efb\u52a1\u4e0b\u751f\u6548)").comment("Maid cooldown multiplier(default:1.0,only effective on spellCombatTask)").defineInRange("maidCooldownMultiplier", 1.0, 0.0, 50.0);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static double maxSpellRange;
    public static double meleeRange;
    public static double farRange;
    public static double spellDamageMultiplier;
    public static double coolDownMultiplier;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        maxSpellRange = (Double)MAX_SPELL_RANGE.get();
        meleeRange = (Double)MELEE_RANGE.get();
        spellDamageMultiplier = (Double)SPELL_DAMAGE_MULTIPLIER.get();
        coolDownMultiplier = (Double)COOLDOWN_MULITIPLIER.get();
        farRange = (Double)FAR_RANGE.get();
        SpellCombatMeleeTask.setSpellRange(Float.valueOf((float)maxSpellRange));
        SpellCombatFarTask.setSpellRange(Float.valueOf((float)maxSpellRange));
        SimplifiedSpellCaster.MELEE_RANGE = (float)meleeRange;
        SimplifiedSpellCaster.FAR_RANGE = (float)farRange;
        Global.common_damageProcessors.add((hurtEvent, maid) -> {
            if (maid.getTask().getUid().toString().startsWith("maidspell")) {
                hurtEvent.setAmount((float)((double)hurtEvent.getAmount() * spellDamageMultiplier));
            }
            return null;
        });
        Global.common_coolDownProcessors.add(coolDown -> {
            coolDown.cooldownticks = (int)((double)coolDown.cooldownticks * coolDownMultiplier);
            return null;
        });
    }
}

