/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.blueNote.contianer;

import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BlueNoteSpellManager {
    private static final String SCROLLS_TAG = "StoredScrolls";
    private static final String SPELL_IDS_TAG = "SpellIds";

    public static void loadScrollsFromItem(ItemStack blueNoteStack, ItemStackHandler scrollHandler) {
        int i;
        if (blueNoteStack.m_41619_()) {
            return;
        }
        CompoundTag tag = blueNoteStack.m_41784_();
        if (!tag.m_128441_(SCROLLS_TAG)) {
            return;
        }
        ListTag scrollsList = tag.m_128437_(SCROLLS_TAG, 10);
        for (i = 0; i < scrollHandler.getSlots(); ++i) {
            scrollHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < scrollsList.size() && i < scrollHandler.getSlots(); ++i) {
            CompoundTag scrollTag = scrollsList.m_128728_(i);
            ItemStack scroll = ItemStack.m_41712_((CompoundTag)scrollTag);
            if (scroll.m_41619_()) continue;
            scrollHandler.setStackInSlot(i, scroll);
        }
    }

    public static void saveScrollsToItem(ItemStack blueNoteStack, ItemStackHandler scrollHandler) {
        if (blueNoteStack.m_41619_()) {
            return;
        }
        CompoundTag tag = blueNoteStack.m_41784_();
        ListTag scrollsList = new ListTag();
        for (int i = 0; i < scrollHandler.getSlots(); ++i) {
            ItemStack scroll = scrollHandler.getStackInSlot(i);
            if (!scroll.m_41619_()) {
                CompoundTag scrollTag = new CompoundTag();
                scroll.m_41739_(scrollTag);
                scrollsList.add((Object)scrollTag);
                continue;
            }
            scrollsList.add((Object)new CompoundTag());
        }
        tag.m_128365_(SCROLLS_TAG, (Tag)scrollsList);
        BlueNoteSpellManager.saveSpellIdsToItem(blueNoteStack, scrollHandler);
    }

    public static void saveSpellIdsToItem(ItemStack blueNoteStack, ItemStackHandler scrollHandler) {
        if (blueNoteStack.m_41619_()) {
            return;
        }
        List<String> spellIds = BlueNoteSpellManager.extractSpellIdsFromScrolls(scrollHandler);
        CompoundTag tag = blueNoteStack.m_41784_();
        ListTag spellIdsList = new ListTag();
        for (String spellId : spellIds) {
            if (spellId == null || spellId.isEmpty()) continue;
            spellIdsList.add((Object)StringTag.m_129297_((String)spellId));
        }
        tag.m_128365_(SPELL_IDS_TAG, (Tag)spellIdsList);
    }

    private static List<String> extractSpellIdsFromScrolls(ItemStackHandler scrollHandler) {
        ArrayList<String> spellIds = new ArrayList<String>();
        for (int i = 0; i < scrollHandler.getSlots(); ++i) {
            SpellData[] scrollSpells;
            ISpellContainer container;
            ItemStack stack = scrollHandler.getStackInSlot(i);
            if (stack.m_41619_() || !ISpellContainer.isSpellContainer((ItemStack)stack) || (container = ISpellContainer.get((ItemStack)stack)).isEmpty()) continue;
            for (SpellData spellData : scrollSpells = container.getAllSpells()) {
                if (spellData == null || spellData.getSpell() == null) continue;
                spellIds.add(spellData.getSpell().getSpellId());
            }
        }
        return spellIds;
    }

    public static List<String> getStoredSpellIds(ItemStack blueNoteStack) {
        ArrayList<String> spellIds = new ArrayList<String>();
        if (blueNoteStack.m_41619_()) {
            return spellIds;
        }
        CompoundTag tag = blueNoteStack.m_41783_();
        if (tag == null || !tag.m_128441_(SPELL_IDS_TAG)) {
            return spellIds;
        }
        ListTag spellIdsList = tag.m_128437_(SPELL_IDS_TAG, 8);
        for (int i = 0; i < spellIdsList.size(); ++i) {
            String spellId = spellIdsList.m_128778_(i);
            if (spellId.isEmpty()) continue;
            spellIds.add(spellId);
        }
        return spellIds;
    }

    public static void clearStoredData(ItemStack blueNoteStack) {
        if (!blueNoteStack.m_41619_()) {
            CompoundTag tag = blueNoteStack.m_41784_();
            tag.m_128473_(SCROLLS_TAG);
            tag.m_128473_(SPELL_IDS_TAG);
        }
    }
}

