/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.AbstractSpellData;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MaidArsNouveauSpellData
extends AbstractSpellData {
    private static final Map<UUID, MaidArsNouveauSpellData> MAID_DATA_MAP = new ConcurrentHashMap<UUID, MaidArsNouveauSpellData>();
    private int castingTicks = 0;
    private Spell currentSpell = null;
    private ISpellCaster currentCaster = null;
    private static final int CASTING_DURATION = 10;

    private MaidArsNouveauSpellData() {
    }

    public static MaidArsNouveauSpellData getOrCreate(UUID maidUuid) {
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidArsNouveauSpellData());
    }

    public static MaidArsNouveauSpellData getOrCreate(EntityMaid maidEntity) {
        UUID maidUuid = maidEntity.m_20148_();
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidArsNouveauSpellData());
    }

    public static MaidArsNouveauSpellData get(UUID maidUuid) {
        return MAID_DATA_MAP.get(maidUuid);
    }

    public static void remove(UUID maidUuid) {
        MAID_DATA_MAP.remove(maidUuid);
    }

    public int getCastingTicks() {
        return this.castingTicks;
    }

    public void setCastingTicks(int castingTicks) {
        this.castingTicks = castingTicks;
    }

    public void incrementCastingTicks() {
        ++this.castingTicks;
    }

    public Spell getCurrentSpell() {
        return this.currentSpell;
    }

    public void setCurrentSpell(Spell spell) {
        this.currentSpell = spell;
    }

    public ISpellCaster getCurrentCaster() {
        return this.currentCaster;
    }

    public void setCurrentCaster(ISpellCaster caster) {
        this.currentCaster = caster;
    }

    public int getCastingDuration() {
        return 10;
    }

    public boolean isCastingComplete() {
        return this.castingTicks >= 10;
    }

    @Override
    public void resetCastingState() {
        this.isCasting = false;
        this.castingTicks = 0;
        this.currentSpell = null;
    }
}

