/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.manager;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import com.github.yimeng261.maidspell.api.IExtendBauble;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class BaubleStateManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, List<ItemStack>> maidBaublePrevious = new ConcurrentHashMap<UUID, List<ItemStack>>();
    private static final Map<UUID, List<ItemStack>> maidBaubleCurrent = new ConcurrentHashMap<UUID, List<ItemStack>>();

    public static void updateAndCheckBaubleState(EntityMaid maid) {
        if (maid == null || maid.m_9236_().m_5776_()) {
            return;
        }
        UUID maidUUID = maid.m_20148_();
        List<ItemStack> currentBaubles = BaubleStateManager.getCurrentBaubles(maid);
        List<ItemStack> previousBaubles = BaubleStateManager.getPreviousBaubles(maidUUID);
        maidBaubleCurrent.put(maid.m_20148_(), currentBaubles);
        if (previousBaubles != null) {
            List<ItemStack> removedBaubles = previousBaubles.stream().filter(item -> !currentBaubles.contains(item)).toList();
            for (ItemStack removedBauble : removedBaubles) {
                IMaidBauble bauble = BaubleManager.getBauble((ItemStack)removedBauble);
                if (!(bauble instanceof IExtendBauble)) continue;
                ((IExtendBauble)bauble).onRemove(maid);
            }
        }
        maidBaublePrevious.put(maidUUID, new ArrayList<ItemStack>(currentBaubles));
    }

    private static List<ItemStack> getPreviousBaubles(UUID maidUUID) {
        return maidBaublePrevious.computeIfAbsent(maidUUID, k -> new ArrayList());
    }

    private static List<ItemStack> getCurrentBaubles(EntityMaid maid) {
        ArrayList<ItemStack> baubles = new ArrayList<ItemStack>();
        BaubleItemHandler handler = maid.getMaidBauble();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            baubles.add(stack.m_41777_());
        }
        return baubles;
    }

    public static List<ItemStack> getBaubles(EntityMaid maid) {
        return maidBaubleCurrent.computeIfAbsent(maid.m_20148_(), k -> BaubleStateManager.getCurrentBaubles(maid));
    }
}

