/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.bauble;

import com.github.yimeng261.maidspell.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;

public class BaublePageManager {
    public static final int SLOTS_PER_PAGE = 9;
    private static final Map<Integer, Integer> maidCurrentPage = new HashMap<Integer, Integer>();

    public static int getCurrentPage(Entity maid) {
        return maidCurrentPage.getOrDefault(maid.m_19879_(), 0);
    }

    public static void setCurrentPage(Entity maid, int page) {
        int maxPage = BaublePageManager.getMaxPage();
        if (page < 0) {
            page = 0;
        } else if (page > maxPage) {
            page = maxPage;
        }
        maidCurrentPage.put(maid.m_19879_(), page);
    }

    public static boolean nextPage(Entity maid) {
        int maxPage;
        int currentPage = BaublePageManager.getCurrentPage(maid);
        if (currentPage < (maxPage = BaublePageManager.getMaxPage())) {
            BaublePageManager.setCurrentPage(maid, currentPage + 1);
            return true;
        }
        return false;
    }

    public static boolean previousPage(Entity maid) {
        int currentPage = BaublePageManager.getCurrentPage(maid);
        if (currentPage > 0) {
            BaublePageManager.setCurrentPage(maid, currentPage - 1);
            return true;
        }
        return false;
    }

    public static int getMaxPage() {
        int totalSlots = Config.baubleSlotCounts;
        return Math.max(0, (totalSlots - 1) / 9);
    }

    public static int getTotalPages() {
        return BaublePageManager.getMaxPage() + 1;
    }

    public static int getPageStartSlot(Entity maid) {
        return BaublePageManager.getCurrentPage(maid) * 9;
    }

    public static int getSlotsInCurrentPage(Entity maid) {
        int currentPage = BaublePageManager.getCurrentPage(maid);
        int totalSlots = Config.baubleSlotCounts;
        int startSlot = currentPage * 9;
        int remainingSlots = totalSlots - startSlot;
        return Math.min(9, remainingSlots);
    }

    public static boolean isValidSlotInPage(Entity maid, int slotInPage) {
        return slotInPage >= 0 && slotInPage < BaublePageManager.getSlotsInCurrentPage(maid);
    }

    public static int pageSlotToGlobalSlot(Entity maid, int slotInPage) {
        return BaublePageManager.getPageStartSlot(maid) + slotInPage;
    }

    public static PageSlotInfo globalSlotToPageSlot(int globalSlot) {
        int page = globalSlot / 9;
        int slotInPage = globalSlot % 9;
        return new PageSlotInfo(page, slotInPage);
    }

    public static void cleanupMaid(Entity maid) {
        maidCurrentPage.remove(maid.m_19879_());
    }

    public static class PageSlotInfo {
        public final int page;
        public final int slotInPage;

        public PageSlotInfo(int page, int slotInPage) {
            this.page = page;
            this.slotInPage = slotInPage;
        }
    }
}

