/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.client.gui;

import com.github.yimeng261.maidspell.client.KeyBinds;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.network.message.EnderPocketMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderPocketScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("touhou_little_maid_spell", "textures/gui/ender_pocket.png");
    private List<EnderPocketService.EnderPocketMaidInfo> maidInfos;
    private static final int GUI_WIDTH = 90;
    private static final int GUI_HEIGHT = 153;

    public EnderPocketScreen(List<EnderPocketService.EnderPocketMaidInfo> maidInfos) {
        super((Component)Component.m_237115_((String)"gui.maidspell.ender_pocket.title"));
        this.maidInfos = maidInfos;
    }

    public void updateMaidInfos(List<EnderPocketService.EnderPocketMaidInfo> newMaidInfos) {
        this.maidInfos = newMaidInfos;
        this.m_7856_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int startX = (this.f_96543_ - 90) / 2;
        int startY = (this.f_96544_ - 153) / 2;
        for (int i = 0; i < this.maidInfos.size() && i < 8; ++i) {
            EnderPocketService.EnderPocketMaidInfo maidInfo = this.maidInfos.get(i);
            int buttonX = startX + 6;
            int buttonHeight = 16;
            int buttonY = startY + 16 + i * buttonHeight;
            int buttonWidth = 78;
            TransparentButton maidButton = new TransparentButton(buttonX, buttonY, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)maidInfo.maidName), button -> this.openMaidInventory(maidInfo.maidEntityId));
            this.m_142416_((GuiEventListener)maidButton);
        }
    }

    private void openMaidInventory(int maidEntityId) {
        NetworkHandler.CHANNEL.sendToServer((Object)EnderPocketMessage.openMaidInventory(maidEntityId));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || KeyBinds.OPEN_ENDER_POCKET_GUI.getKey().m_84873_() == keyCode) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.renderGui(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderGui(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.f_96543_ - 90) / 2;
        int startY = (this.f_96544_ - 153) / 2;
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, startX, startY, 0, 0, 90, 153);
        int titleX = this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2;
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, titleX, startY + 6, 0x404040, false);
    }

    public boolean m_7043_() {
        return false;
    }

    public static class TransparentButton
    extends Button {
        public TransparentButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
        }

        public void m_87963_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.m_274382_()) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -2130706433);
                guiGraphics.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, -1);
            }
            int textColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }
}

