/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidEquipEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTamedEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.network.message.EnderPocketMessage;
import com.github.yimeng261.maidspell.spell.data.MaidSlashBladeData;
import com.github.yimeng261.maidspell.spell.manager.AllianceManager;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.github.yimeng261.maidspell.spell.manager.SpellBookManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.inputstate.InputStateCapabilityProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class MaidSpellEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UUID MAID_STEP_HEIGHT_UUID = UUID.fromString("8e2c4a16-7f9d-4b45-a3e2-1c8f5d9a6b47");

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (!event.getLevel().m_5776_()) {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.setMaid(maid);
                manager.updateSpellBooks();
                LivingEntity owner = maid.m_269323_();
                Global.maidList.add(maid);
                if (owner != null) {
                    Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).put(maid.m_20148_(), maid);
                }
                MaidSpellEventHandler.addStepHeightToMaid(maid);
                BaubleStateManager.updateAndCheckBaubleState(maid);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (EntityMaid maid : Global.maidList) {
                LivingEntity owner = maid.m_269323_();
                if (owner == null) continue;
                Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).put(maid.m_20148_(), maid);
            }
            try {
                List<EnderPocketService.EnderPocketMaidInfo> maidInfos = EnderPocketService.getPlayerEnderPocketMaids(player2);
                if (!maidInfos.isEmpty()) {
                    LOGGER.debug("[MaidSpell] Pushing ender pocket data to player {} on login: {} maids", (Object)player2.m_7755_().getString(), (Object)maidInfos.size());
                    EnderPocketMessage message = EnderPocketMessage.serverPushUpdate(maidInfos);
                    NetworkHandler.CHANNEL.sendTo((Object)message, player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    LOGGER.debug("[MaidSpell] Pushed ender pocket data to player {} on login: {} maids", (Object)player2.m_7755_().getString(), (Object)maidInfos.size());
                }
            }
            catch (Exception e) {
                LOGGER.error("[MaidSpell] Failed to sync ender pocket data for player {} on login: {}", new Object[]{player2.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (!event.getLevel().m_5776_()) {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                manager.stopAllCasting();
                BaubleStateManager.removeMaidBaubles(maid);
                LivingEntity owner = maid.m_269323_();
                if (owner != null) {
                    Global.maidInfos.computeIfAbsent(owner.m_20148_(), k -> new HashMap()).remove(maid.m_20148_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMaidEquip(MaidEquipEvent event) {
        EntityMaid maid = event.getMaid();
        EquipmentSlot slot = event.getSlot();
        if (!(maid.m_9236_().m_5776_() || slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND)) {
            try {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                if (manager != null) {
                    manager.updateSpellBooks();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error handling maid equip event for maid {}: {}", new Object[]{maid.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onMaidTick(MaidTickEvent event) {
        EntityMaid maid = event.getMaid();
        if (!maid.m_9236_().m_5776_()) {
            try {
                SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
                if (manager != null) {
                    manager.tick();
                }
                if (maid.f_19797_ % 20 == 0) {
                    if (maid.m_21525_() && maid.getTask().getUid().toString().startsWith("maidspell")) {
                        maid.m_21557_(false);
                    }
                    if (maid.getTask().getUid().toString().startsWith("maidspell")) {
                        if (!AllianceManager.getAllianceStatus().containsKey(maid.m_20148_())) {
                            AllianceManager.setMaidAlliance(maid, true);
                        }
                    } else {
                        AllianceManager.setMaidAlliance(maid, false);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in maid tick handler for maid {}: {}", new Object[]{maid.m_7755_().getString(), e.getMessage(), e});
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityMaid maid;
        LivingEntity entity = event.getEntity();
        Entity direct = event.getSource().m_7640_();
        Entity source = event.getSource().m_7639_();
        if (source instanceof EntityMaid) {
            maid = (EntityMaid)source;
            MaidSpellEventHandler.processor_pre(event, maid);
        } else if (direct instanceof EntityMaid) {
            EntityMaid maid2 = (EntityMaid)direct;
            MaidSpellEventHandler.processor_pre(event, maid2);
        }
        if (entity instanceof EntityMaid) {
            maid = (EntityMaid)entity;
            Global.common_hurtProcessors.forEach((Consumer<BiFunction<LivingHurtEvent, EntityMaid, Void>>)((Consumer<BiFunction>)function -> function.apply(event, maid)));
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<LivingHurtEvent, EntityMaid, Void> func = Global.bauble_hurtProcessors_pre.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        EntityMaid maid;
        LivingEntity entity = event.getEntity();
        Entity direct = event.getSource().m_7640_();
        Entity source = event.getSource().m_7639_();
        if (source instanceof EntityMaid) {
            maid = (EntityMaid)source;
            MaidSpellEventHandler.processor_aft(event, maid);
        } else if (direct instanceof EntityMaid) {
            EntityMaid maid2 = (EntityMaid)direct;
            MaidSpellEventHandler.processor_aft(event, maid2);
        }
        if (entity instanceof EntityMaid) {
            maid = (EntityMaid)entity;
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<LivingDamageEvent, EntityMaid, Void> func = Global.bauble_hurtProcessors_aft.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            Global.player_hurtProcessors_aft.forEach((Consumer<BiFunction<LivingDamageEvent, Player, Void>>)((Consumer<BiFunction>)func -> func.apply(event, player)));
        }
    }

    @SubscribeEvent
    public static void onMaidEffectAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<MobEffectEvent.Added, EntityMaid, Void> func = Global.bauble_effectAddedProcessors.getOrDefault(bauble.m_41778_(), (mobEffectEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
        }
    }

    private static void processor_aft(LivingDamageEvent event, EntityMaid maid) {
        BaubleStateManager.getBaubles(maid).forEach(bauble -> {
            BiFunction<LivingDamageEvent, EntityMaid, Void> func = Global.bauble_damageProcessors_aft.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
            func.apply(event, maid);
        });
    }

    private static void processor_pre(LivingHurtEvent event, EntityMaid maid) {
        Global.common_damageProcessors.forEach((Consumer<BiFunction<LivingHurtEvent, EntityMaid, Void>>)((Consumer<BiFunction>)function -> function.apply(event, maid)));
        BaubleStateManager.getBaubles(maid).forEach(bauble -> {
            BiFunction<LivingHurtEvent, EntityMaid, Void> func = Global.bauble_damageProcessors_pre.getOrDefault(bauble.m_41778_(), (livingHurtEvent, entityMaid) -> null);
            func.apply(event, maid);
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_9236_().m_5776_()) {
            return;
        }
        if (event.getObject() instanceof EntityMaid) {
            if (!ModList.get().isLoaded("slashblade")) {
                return;
            }
            Entity entity = (Entity)event.getObject();
            ResourceLocation maidInputStateKey = new ResourceLocation("touhou_little_maid_spell", "maid_inputstate");
            try {
                if (!entity.getCapability(CapabilityInputState.INPUT_STATE).isPresent()) {
                    event.addCapability(maidInputStateKey, (ICapabilityProvider)new InputStateCapabilityProvider());
                    LOGGER.debug("Added INPUT_STATE capability to maid entity");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to add INPUT_STATE capability to maid: {}", (Object)e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onMaidDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            BaubleStateManager.getBaubles(maid).forEach(bauble -> {
                BiFunction<LivingDeathEvent, EntityMaid, Void> func = Global.bauble_deathProcessors.getOrDefault(bauble.m_41778_(), (livingDeathEvent, entityMaid) -> null);
                func.apply(event, maid);
            });
            if (!event.isCanceled()) {
                MaidSpellEventHandler.cleanupMaidSpellData(maid);
            }
        }
    }

    private static void cleanupMaidSpellData(EntityMaid maid) {
        try {
            SpellBookManager manager = SpellBookManager.getOrCreateManager(maid);
            if (manager != null) {
                for (ISpellBookProvider provider : manager.getProviders()) {
                    if (!provider.isCasting(maid)) continue;
                    provider.stopCasting(maid);
                }
            }
            BaubleStateManager.removeMaidBaubles(maid);
            MaidSlashBladeData.remove(maid.m_20148_());
            SpellBookManager.removeManager(maid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addStepHeightToMaid(EntityMaid maid) {
        try {
            AttributeInstance stepHeightAttribute = maid.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            if (stepHeightAttribute == null) {
                LOGGER.warn("Maid {} does not have step height attribute", (Object)maid.m_7755_().getString());
                return;
            }
            if (stepHeightAttribute.m_22111_(MAID_STEP_HEIGHT_UUID) == null) {
                AttributeModifier stepHeightModifier = new AttributeModifier(MAID_STEP_HEIGHT_UUID, "Maid Step Height Addition", 1.0, AttributeModifier.Operation.ADDITION);
                stepHeightAttribute.m_22125_(stepHeightModifier);
                LOGGER.debug("Added step height attribute to maid: {}", (Object)maid.m_7755_().getString());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add step height attribute to maid {}: {}", (Object)maid.m_7755_().getString(), (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onMaidTamed(MaidTamedEvent event) {
        Level level;
        EntityMaid maid = event.getMaid();
        Player player = event.getPlayer();
        if (!player.m_9236_().m_5776_() && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (maid.m_21827_() && !maid.isStructureSpawn() && MaidSpellEventHandler.isInHiddenRetreatStructure(level2, maid.m_20183_())) {
                player.m_213846_((Component)Component.m_237115_((String)"item.touhou_little_maid_spell.maid_tamed_event.maid_in_hidden_retreat").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
    }

    private static boolean isInHiddenRetreatStructure(ServerLevel level, BlockPos pos) {
        try {
            StructureManager structureManager = level.m_215010_();
            Optional hiddenRetreatStructureSet = level.m_9598_().m_175515_(Registries.f_256944_).m_6612_(new ResourceLocation("touhou_little_maid_spell", "hidden_retreat"));
            if (hiddenRetreatStructureSet.isPresent()) {
                StructureStart structureStart = structureManager.m_220524_(pos, (Structure)hiddenRetreatStructureSet.get());
                return structureStart.m_73603_();
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().debug("Error checking hidden_retreat structure at {}: {}", (Object)pos, (Object)e.getMessage());
        }
        return false;
    }
}

