/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.woundRimeBlade;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.IExtendBauble;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.mixin.CombatTrackerMixin;
import com.github.yimeng261.maidspell.utils.TrueDamageUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class WoundRimeBladeBauble
implements IExtendBauble {
    private static final ConcurrentHashMap<UUID, ConcurrentHashMap<LivingEntity, Float>> maidWoundRimeBladeMap = new ConcurrentHashMap();
    private static final Set<UUID> maidWoundRimeBladeSet = new HashSet<UUID>();

    public WoundRimeBladeBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onAdd(EntityMaid maid) {
    }

    @Override
    public void onRemove(EntityMaid maid) {
        maidWoundRimeBladeMap.remove(maid.m_20148_());
    }

    @SubscribeEvent
    public void onEntityHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        if (maidWoundRimeBladeSet.contains(entity.m_20148_())) {
            event.setAmount(0.0f);
        }
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maidWoundRimeBladeMap.containsKey(maid.m_20148_())) {
            ConcurrentHashMap<LivingEntity, Float> map = maidWoundRimeBladeMap.get(maid.m_20148_());
            map.forEach((entity, health) -> {
                if (!entity.m_6084_()) {
                    map.remove(entity);
                    return;
                }
                float nowHealth = entity.m_21223_();
                List<CombatEntry> entries = ((CombatTrackerMixin)entity.m_21231_()).getEntries();
                if (entries.size() > 0) {
                    CombatEntry entry = entries.get(entries.size() - 1);
                    if ((double)(nowHealth - (health.floatValue() - entry.f_19252_())) < (double)entry.f_19252_() * 0.8) {
                        map.put((LivingEntity)entity, Float.valueOf(health.floatValue() - entry.f_19252_()));
                    }
                }
                if (nowHealth > health.floatValue()) {
                    TrueDamageUtil.dealTrueDamage(entity, nowHealth - health.floatValue());
                }
            });
        }
    }

    static {
        Global.bauble_damageProcessors_pre.put(MaidSpellItems.itemDesc(MaidSpellItems.WOUND_RIME_BLADE), (event, maid) -> {
            LivingEntity entity = event.getEntity();
            maidWoundRimeBladeSet.add(entity.m_20148_());
            ConcurrentHashMap map = maidWoundRimeBladeMap.computeIfAbsent(maid.m_20148_(), uuid -> new ConcurrentHashMap());
            if (!map.containsKey(entity)) {
                map.put(entity, Float.valueOf(entity.m_21223_()));
            } else if (((Float)map.get(entity)).floatValue() > entity.m_21223_()) {
                map.put(entity, Float.valueOf(entity.m_21223_()));
            }
            return null;
        });
    }
}

