/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;

public class SearchCacheManager {
    private final Map<String, CacheEntry> structureCache = new ConcurrentHashMap<String, CacheEntry>();
    private final ConcurrentMap<String, CompletableFuture<BlockPos>> ongoingSearches = new ConcurrentHashMap<String, CompletableFuture<BlockPos>>();

    public CacheCheckResult checkCache(ServerLevel serverLevel, BlockPos playerPos) {
        this.cleanExpiredCache();
        String currentDimensionKey = serverLevel.m_46472_().m_135782_().toString();
        for (CacheEntry cache : this.structureCache.values()) {
            if (cache.isExpired() || !cache.isValidForPosition(playerPos, currentDimensionKey)) continue;
            return CacheCheckResult.withResult(cache.structurePos);
        }
        return CacheCheckResult.noCache();
    }

    public void updateCache(ServerLevel serverLevel, BlockPos searchCenter, BlockPos result) {
        String key = this.generateSearchKey(searchCenter);
        String dimensionKey = serverLevel.m_46472_().m_135782_().toString();
        CacheEntry entry = new CacheEntry(searchCenter, result, System.currentTimeMillis(), dimensionKey);
        this.structureCache.put(key, entry);
    }

    public void cleanExpiredCache() {
        this.structureCache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired());
    }

    public String generateSearchKey(BlockPos pos) {
        for (Map.Entry entry : this.ongoingSearches.entrySet()) {
            String[] coords = ((String)entry.getKey()).split(",");
            try {
                int existingZ;
                int existingX = Integer.parseInt(coords[0]);
                BlockPos existingCenter = new BlockPos(existingX, 0, existingZ = Integer.parseInt(coords[1]));
                double distance = Math.sqrt(pos.m_123331_((Vec3i)existingCenter));
                if (!(distance <= 1000.0)) continue;
                return (String)entry.getKey();
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return pos.m_123341_() + "," + pos.m_123343_();
    }

    public CompletableFuture<BlockPos> getOngoingSearch(String searchKey) {
        return (CompletableFuture)this.ongoingSearches.get(searchKey);
    }

    public void registerSearch(String searchKey, CompletableFuture<BlockPos> searchFuture) {
        this.ongoingSearches.put(searchKey, searchFuture);
    }

    public void removeSearch(String searchKey) {
        this.ongoingSearches.remove(searchKey);
    }

    public void clearAll() {
        this.structureCache.clear();
        this.ongoingSearches.clear();
    }

    private static class CacheEntry {
        final BlockPos searchCenter;
        final BlockPos structurePos;
        final long timestamp;
        final String dimensionKey;

        CacheEntry(BlockPos searchCenter, BlockPos structurePos, long time, String dimensionKey) {
            this.searchCenter = searchCenter;
            this.structurePos = structurePos;
            this.timestamp = time;
            this.dimensionKey = dimensionKey;
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 300000L;
        }

        boolean isValidForPosition(BlockPos playerPos, String currentDimensionKey) {
            if (!this.dimensionKey.equals(currentDimensionKey)) {
                return false;
            }
            double moveDistance = Math.sqrt(playerPos.m_123331_((Vec3i)this.searchCenter));
            return moveDistance <= 5000.0;
        }
    }

    public static class CacheCheckResult {
        public final boolean hasCache;
        public final BlockPos structurePos;

        private CacheCheckResult(boolean hasCache, BlockPos pos) {
            this.hasCache = hasCache;
            this.structurePos = pos;
        }

        public static CacheCheckResult noCache() {
            return new CacheCheckResult(false, null);
        }

        public static CacheCheckResult withResult(BlockPos pos) {
            return new CacheCheckResult(true, pos);
        }
    }
}

