/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.entity.WindSeekingBellEntity;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.BiomeValidator;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchCacheManager;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.StructureSearchEngine;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class WindSeekingBell
extends Item {
    private static final Component NO_STRUCTURE_MESSAGE = Component.m_237115_((String)"item.touhou_little_maid_spell.wind_seeking_bell.no_structure").m_130940_(ChatFormatting.RED);
    private static final Component CLICK_SUGGEST_MESSAGE = Component.m_237115_((String)"item.touhou_little_maid_spell.wind_seeking_bell.click_to_suggest").m_130940_(ChatFormatting.YELLOW);
    private static final SearchCacheManager cacheManager = new SearchCacheManager();
    private static final BiomeValidator biomeValidator = new BiomeValidator();
    private static final StructureSearchEngine searchEngine = new StructureSearchEngine(biomeValidator, cacheManager);

    public WindSeekingBell() {
        super(new Item.Properties().m_41487_(16).m_41497_(Rarity.UNCOMMON));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos playerPos = player.m_20183_();
            this.findNearestHiddenRetreatAsync(serverLevel, playerPos, player, itemStack);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    private void findNearestHiddenRetreatAsync(ServerLevel serverLevel, BlockPos playerPos, Player player, ItemStack itemStack) {
        long searchStartTime = System.currentTimeMillis();
        searchEngine.searchAsync(serverLevel, playerPos).thenAccept(result -> {
            long searchTime = System.currentTimeMillis() - searchStartTime;
            this.handleSearchResult(serverLevel, playerPos, player, itemStack, (BlockPos)result, searchTime);
        });
    }

    private void handleSearchResult(ServerLevel serverLevel, BlockPos playerPos, Player player, ItemStack itemStack, BlockPos structurePos, long searchTime) {
        serverLevel.m_7654_().execute(() -> {
            if (structurePos != null) {
                ServerPlayer serverPlayer;
                int count;
                int height = serverLevel.m_7726_().m_8481_().m_223235_(structurePos.m_123341_(), structurePos.m_123343_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, serverLevel.m_46865_(structurePos).m_183618_(), serverLevel.m_7726_().m_214994_());
                BlockPos structurePosVec3i = new BlockPos(structurePos.m_123341_(), 0, structurePos.m_123343_());
                BlockPos playerPosVec3i = new BlockPos(playerPos.m_123341_(), 0, playerPos.m_123343_());
                WindSeekingBellEntity windSeekingBell = new WindSeekingBellEntity((Level)serverLevel, player);
                ItemStack newItemStack = itemStack.m_41777_();
                newItemStack.m_41764_(1);
                windSeekingBell.setItem(newItemStack);
                windSeekingBell.signalTo(structurePosVec3i.m_6630_(height + 3));
                serverLevel.m_7967_((Entity)windSeekingBell);
                int distance = (int)Math.sqrt(structurePosVec3i.m_123331_((Vec3i)playerPosVec3i));
                String tpCommand = String.format("/tp %f %d %f", (double)structurePos.m_123341_() + 0.5, height + 3, (double)structurePos.m_123343_() + 0.5);
                MutableComponent coordinateMessage = Component.m_237110_((String)"item.touhou_little_maid_spell.wind_seeking_bell.found_structure", (Object[])new Object[]{structurePos.m_123341_(), height, structurePos.m_123343_(), distance}).m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, tpCommand)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)CLICK_SUGGEST_MESSAGE)));
                MutableComponent timingMessage = Component.m_237110_((String)"item.touhou_little_maid_spell.wind_seeking_bell.search_time", (Object[])new Object[]{searchTime}).m_130940_(ChatFormatting.AQUA);
                player.m_213846_((Component)coordinateMessage);
                player.m_213846_((Component)timingMessage);
                if (player instanceof ServerPlayer && (count = (serverPlayer = (ServerPlayer)player).m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)this))) == 0) {
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"item.touhou_little_maid_spell.wind_seeking_bell.first_use").m_130940_(ChatFormatting.LIGHT_PURPLE));
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            } else {
                MutableComponent timingMessage = Component.m_237110_((String)"item.touhou_little_maid_spell.wind_seeking_bell.search_time", (Object[])new Object[]{searchTime}).m_130940_(ChatFormatting.GREEN);
                player.m_5661_(NO_STRUCTURE_MESSAGE, true);
                player.m_213846_((Component)timingMessage);
            }
        });
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.touhou_little_maid_spell.wind_seeking_bell.desc1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"item.touhou_little_maid_spell.wind_seeking_bell.desc2").m_130940_(ChatFormatting.GOLD));
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return true;
    }

    public static void clearAllCaches() {
        cacheManager.clearAll();
        StructureSearchEngine.clearCaches();
        Global.LOGGER.debug("WindSeekingBell: All caches cleared");
    }

    @Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
    public static class ServerEventHandler {
        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent event) {
            WindSeekingBell.clearAllCaches();
            Global.LOGGER.info("WindSeekingBell: Cleared caches on server startup");
            Global.LOGGER.info("WindSeekingBell: Using striped lock with {} segments for improved concurrency", (Object)64);
        }

        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            WindSeekingBell.clearAllCaches();
            Global.LOGGER.info("WindSeekingBell: Cleared caches on server shutdown");
        }
    }
}

