/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.yimeng261.maidspell.inventory.MaidAwareBaubleItemHandler;
import com.github.yimeng261.maidspell.inventory.SpellBookAwareMaidBackpackHandler;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityMaid.class}, remap=false)
public class EntityMaidMixin {
    @Shadow
    private boolean structureSpawn;
    @Mutable
    @Final
    @Shadow
    private ItemStackHandler maidInv;
    @Mutable
    @Final
    @Shadow
    private BaubleItemHandler maidBauble;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void replaceHandlers(EntityType<EntityMaid> type, Level world, CallbackInfo ci) {
        LogUtils.getLogger().info("Replacing maid handlers in constructor");
        this.maidInv = new SpellBookAwareMaidBackpackHandler(36, (EntityMaid)this);
        LogUtils.getLogger().info("Successfully replaced maidInv with SpellBookAwareMaidBackpackHandler");
        this.maidBauble = new MaidAwareBaubleItemHandler(9, (EntityMaid)this);
        LogUtils.getLogger().info("Successfully replaced maidBauble with MaidAwareBaubleItemHandler");
    }

    @Inject(method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/entity/SpawnGroupData;"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onFinalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        try {
            EntityMaid maid;
            BlockPos maidPos;
            if (reason == MobSpawnType.STRUCTURE && this.isInHiddenRetreatStructure(worldIn, maidPos = (maid = (EntityMaid)this).m_20183_())) {
                this.structureSpawn = false;
                LogUtils.getLogger().info("Prevented finalizeSpawn processing for maid in hidden_retreat structure at {}", (Object)maidPos);
                cir.setReturnValue((Object)spawnDataIn);
                return;
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Failed to prevent finalizeSpawn processing for hidden_retreat maid", (Throwable)e);
        }
    }

    private boolean isInHiddenRetreatStructure(ServerLevelAccessor worldIn, BlockPos pos) {
        try {
            StructureManager structureManager = worldIn.m_6018_().m_215010_();
            Optional hiddenRetreatStructureSet = worldIn.m_9598_().m_175515_(Registries.f_256944_).m_6612_(new ResourceLocation("touhou_little_maid_spell", "hidden_retreat"));
            if (hiddenRetreatStructureSet.isPresent()) {
                StructureStart structureStart = structureManager.m_220524_(pos, (Structure)hiddenRetreatStructureSet.get());
                return structureStart.m_73603_();
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().debug("Error checking hidden_retreat structure at {}: {}", (Object)pos, (Object)e.getMessage());
        }
        return false;
    }
}

