/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.network.message;

import com.github.yimeng261.maidspell.bauble.BaublePageManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class BaublePageChangeMessage {
    private final int maidId;
    private final int newPage;

    public BaublePageChangeMessage(int maidId, int newPage) {
        this.maidId = maidId;
        this.newPage = newPage;
    }

    public BaublePageChangeMessage(FriendlyByteBuf buf) {
        this.maidId = buf.readInt();
        this.newPage = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.maidId);
        buf.writeInt(this.newPage);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity maid;
            ServerPlayer player = context.getSender();
            if (player != null && (maid = player.m_9236_().m_6815_(this.maidId)) != null) {
                BaublePageManager.setCurrentPage(maid, this.newPage);
            }
        });
        return true;
    }
}

