/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.api.magic.IChargingSpell;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.common.items.handler.FocusBagItemHandler;
import com.Polarice3.Goety.common.items.handler.SoulUsingItemHandler;
import com.Polarice3.Goety.common.items.magic.FocusBag;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidGoetySpellData;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.slf4j.Logger;

public class GoetyProvider
implements ISpellBookProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_INFINITE_CASTING_TIME = 45;
    private static final boolean DEBUG = true;

    private MaidGoetySpellData getData(EntityMaid maid) {
        if (maid == null) {
            return null;
        }
        return MaidGoetySpellData.getOrCreate(maid.m_20148_());
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && itemStack.m_41720_() instanceof IWand;
    }

    @Override
    public void setTarget(EntityMaid maid, LivingEntity target) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null) {
            data.setTarget(target);
        }
    }

    @Override
    public LivingEntity getTarget(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        return data != null ? data.getTarget() : null;
    }

    @Override
    public void setSpellBook(EntityMaid maid, ItemStack spellBook) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null) {
            ItemStack newSpellBook;
            ItemStack oldSpellBook = data.getSpellBook() == null ? ItemStack.f_41583_ : data.getSpellBook();
            ItemStack itemStack = newSpellBook = spellBook == null ? ItemStack.f_41583_ : spellBook;
            if (!ItemStack.m_150942_((ItemStack)oldSpellBook, (ItemStack)newSpellBook)) {
                this.stopCasting(maid);
                data.setSpellBook(spellBook);
            }
        }
    }

    @Override
    public boolean isCasting(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        return data != null && data.isCasting();
    }

    @Override
    public boolean initiateCasting(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return false;
        }
        ItemStack spellBook = data.getSpellBook();
        if (!this.isSpellBook(spellBook)) {
            return false;
        }
        if (!this.canStartCasting(maid)) {
            return false;
        }
        ISpell spell = this.extractSpellFromWand(maid);
        if (spell == null) {
            return false;
        }
        this.ensureWandEquipped(maid);
        this.prepareForCasting(maid);
        return this.startSpellCasting(maid, spell);
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentSpell() == null || !this.isSpellBook(data.getSpellBook())) {
            return;
        }
        data.incrementCastingTime();
        if (!this.isValidTarget(data)) {
            this.stopCasting(maid);
            return;
        }
        this.updateMaidOrientation(maid, data);
        ISpell iSpell = data.getCurrentSpell();
        if (iSpell instanceof IChargingSpell) {
            IChargingSpell chargingSpell = (IChargingSpell)iSpell;
            this.processChargingSpell(maid, chargingSpell);
        } else {
            this.processNormalSpell(maid);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidGoetySpellData data;
        if (maid.m_6117_()) {
            maid.m_5810_();
        }
        if ((data = this.getData(maid)) == null || !data.isCasting() || data.getCurrentSpell() == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            data.getCurrentSpell().stopSpell(serverLevel, (LivingEntity)maid, data.getSpellBook(), data.getMaxCastingTime() - data.getCastingTime());
        }
        this.setCooldown(maid, data.getCurrentSpell());
        this.resetCastingState(maid, data);
    }

    @Override
    public boolean castSpell(EntityMaid maid) {
        return this.initiateCasting(maid);
    }

    @Override
    public void updateCooldown(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null) {
            data.updateCooldowns();
        }
    }

    private boolean canStartCasting(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null || data.isCasting()) {
            return false;
        }
        return this.isValidTarget(data);
    }

    private boolean isValidTarget(MaidGoetySpellData data) {
        LivingEntity target = data.getTarget();
        return target != null && target.m_6084_();
    }

    private ISpell extractSpellFromWand(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return null;
        }
        ItemStack spellBook = data.getSpellBook();
        if (spellBook == null || spellBook.m_41619_()) {
            return null;
        }
        ItemStack focusBag = this.findFocusBag(maid);
        List<Pair<ItemStack, Integer>> availableFoci = this.collectAllAvailableFoci(maid, data, spellBook, focusBag);
        if (availableFoci.isEmpty()) {
            return null;
        }
        int randomIndex = (int)(Math.random() * (double)availableFoci.size());
        Pair<ItemStack, Integer> selected = availableFoci.get(randomIndex);
        if ((Integer)selected.getSecond() != -1) {
            if (this.switchFocus(maid, spellBook, focusBag, (Integer)selected.getSecond())) {
                ItemStack selectedFocus = (ItemStack)selected.getFirst();
                focusBag.m_41784_();
                Item item = selectedFocus.m_41720_();
                if (item instanceof IFocus) {
                    IFocus magicFocus = (IFocus)item;
                    return magicFocus.getSpell();
                }
            }
        } else {
            ItemStack currentFocus = (ItemStack)selected.getFirst();
            Item item = currentFocus.m_41720_();
            if (item instanceof IFocus) {
                IFocus magicFocus = (IFocus)item;
                return magicFocus.getSpell();
            }
        }
        return null;
    }

    private List<Pair<ItemStack, Integer>> collectAllAvailableFoci(EntityMaid maid, MaidGoetySpellData data, ItemStack spellBook, ItemStack focusBag) {
        IFocus focus;
        ISpell spell;
        Item item;
        ArrayList<Pair<ItemStack, Integer>> availableFoci = new ArrayList<Pair<ItemStack, Integer>>();
        ItemStack currentFocus = IWand.getFocus((ItemStack)spellBook);
        if (!currentFocus.m_41619_() && (item = currentFocus.m_41720_()) instanceof IFocus && (spell = (focus = (IFocus)item).getSpell()) != null && !data.isSpellOnCooldown(this.getSpellId(spell))) {
            availableFoci.add((Pair<ItemStack, Integer>)new Pair((Object)currentFocus.m_41777_(), (Object)-1));
        }
        if (!focusBag.m_41619_()) {
            try {
                FocusBagItemHandler bagHandler = FocusBagItemHandler.get((ItemStack)focusBag);
                for (int i = 1; i < bagHandler.getSlots(); ++i) {
                    IFocus focus2;
                    ISpell spell2;
                    Item item2;
                    ItemStack focusStack = bagHandler.getStackInSlot(i);
                    if (focusStack.m_41619_() || !((item2 = focusStack.m_41720_()) instanceof IFocus) || (spell2 = (focus2 = (IFocus)item2).getSpell()) == null || data.isSpellOnCooldown(this.getSpellId(spell2))) continue;
                    availableFoci.add((Pair<ItemStack, Integer>)new Pair((Object)focusStack, (Object)i));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to access focus bag handler for maid: {}", (Object)maid.m_20148_(), (Object)e);
            }
        }
        return availableFoci;
    }

    private ItemStack findFocusBag(EntityMaid maid) {
        if (maid == null) {
            return ItemStack.f_41583_;
        }
        CombinedInvWrapper availableInv = maid.getAvailableInv(false);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack stack = availableInv.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof FocusBag)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private boolean switchFocus(EntityMaid maid, ItemStack spellBook, ItemStack focusBag, int bagSlot) {
        try {
            List<String> beforeState = this.captureFocusState(spellBook, focusBag);
            this.logFocusSwitchBefore(maid, spellBook, focusBag, bagSlot);
            FocusBagItemHandler bagHandler = FocusBagItemHandler.get((ItemStack)focusBag);
            SoulUsingItemHandler wandHandler = SoulUsingItemHandler.get((ItemStack)spellBook);
            ItemStack currentFocus = wandHandler.extractItem();
            ItemStack selectedFocus = bagHandler.getStackInSlot(bagSlot);
            bagHandler.setStackInSlot(bagSlot, currentFocus);
            wandHandler.insertItem(selectedFocus);
            this.logFocusSwitchAfter(maid, spellBook, focusBag);
            List<String> afterState = this.captureFocusState(spellBook, focusBag);
            this.checkFocusStateChanges(maid, beforeState, afterState, bagSlot);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to switch focus for maid: {}", (Object)maid.m_20148_(), (Object)e);
            return false;
        }
    }

    private void prepareForCasting(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null && data.getTarget() != null) {
            BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)data.getTarget());
        }
        maid.m_6674_(InteractionHand.MAIN_HAND);
    }

    private boolean startSpellCasting(EntityMaid maid, ISpell spell) {
        if (spell.CastingSound() != null) {
            this.playSpellSound(maid, spell);
        }
        if (spell instanceof IChargingSpell) {
            IChargingSpell chargingSpell = (IChargingSpell)spell;
            return this.startChargingSpell(maid, chargingSpell);
        }
        return this.startNormalSpell(maid, spell);
    }

    private boolean startNormalSpell(EntityMaid maid, ISpell spell) {
        int castDuration = spell.defaultCastDuration();
        if (castDuration <= 0) {
            this.executeInstantSpell(maid, spell);
            this.setCooldown(maid, spell);
        } else {
            this.initiateCastingState(maid, spell, castDuration);
            this.startSpellExecution(maid, spell);
        }
        return true;
    }

    private boolean startChargingSpell(EntityMaid maid, IChargingSpell chargingSpell) {
        int maxDuration = chargingSpell.defaultCastDuration();
        if (chargingSpell.everCharge()) {
            maxDuration = Math.min(maxDuration, 45);
        }
        this.initiateCastingState(maid, (ISpell)chargingSpell, maxDuration);
        this.resetChargingCounters(maid);
        this.startSpellExecution(maid, (ISpell)chargingSpell);
        return true;
    }

    private void executeInstantSpell(EntityMaid maid, ISpell spell) {
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            spell.startSpell(serverLevel, (LivingEntity)maid, this.getData(maid).getSpellBook(), spell.defaultStats());
            spell.SpellResult(serverLevel, (LivingEntity)maid, this.getData(maid).getSpellBook(), spell.defaultStats());
        }
    }

    private void initiateCastingState(EntityMaid maid, ISpell spell, int duration) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null) {
            data.initiateCastingState(spell, duration);
        }
    }

    private void resetChargingCounters(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null) {
            data.resetChargingCounters();
        }
    }

    private void startSpellExecution(EntityMaid maid, ISpell spell) {
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            spell.startSpell(serverLevel, (LivingEntity)maid, this.getData(maid).getSpellBook(), spell.defaultStats());
        }
    }

    private void updateMaidOrientation(EntityMaid maid, MaidGoetySpellData data) {
        if (data.getTarget() != null) {
            BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)data.getTarget());
            if (data.getCurrentSpell() instanceof IChargingSpell) {
                this.updatePreciseOrientation(maid, data);
            }
        }
    }

    private void updatePreciseOrientation(EntityMaid maid, MaidGoetySpellData data) {
        LivingEntity target = data.getTarget();
        if (target == null) {
            return;
        }
        double dx = target.m_20185_() - maid.m_20185_();
        double dy = target.m_20188_() - maid.m_20188_();
        double dz = target.m_20189_() - maid.m_20189_();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
        maid.m_146922_(yaw);
        maid.m_146926_(pitch);
        maid.f_19859_ = yaw;
        maid.f_19860_ = pitch;
    }

    private void processNormalSpell(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!data.spellUsed()) {
                data.getCurrentSpell().useSpell(serverLevel, (LivingEntity)maid, data.getSpellBook(), data.getCastingTime(), data.getCurrentSpell().defaultStats());
                data.setSpellUsed(true);
            }
        }
        if (data.getCastingTime() >= data.getMaxCastingTime()) {
            this.completeCasting(maid);
        }
    }

    private void processChargingSpell(EntityMaid maid, IChargingSpell chargingSpell) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!data.spellUsed()) {
                chargingSpell.useSpell(serverLevel, (LivingEntity)maid, data.getSpellBook(), data.getCastingTime(), chargingSpell.defaultStats());
                data.setSpellUsed(true);
            }
        }
        if (data.getCastingTime() >= data.getMaxCastingTime()) {
            this.completeCasting(maid);
        }
        this.handleChargingLogic(maid, chargingSpell);
    }

    private void handleChargingLogic(EntityMaid maid, IChargingSpell chargingSpell) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        int castUpTime = this.getCastUpTime(maid, chargingSpell);
        if (data.getCastingTime() < castUpTime && castUpTime > 0) {
            return;
        }
        data.incrementCoolCounter();
        int requiredCooldown = chargingSpell.Cooldown((LivingEntity)maid, data.getSpellBook(), data.getShotsFired());
        if (data.getCoolCounter() >= requiredCooldown) {
            data.setCoolCounter(0);
            this.executeChargingShot(maid, chargingSpell);
            if (chargingSpell.shotsNumber((LivingEntity)maid, data.getSpellBook()) <= data.getShotsFired()) {
                this.completeCasting(maid);
            }
        }
    }

    private int getCastUpTime(EntityMaid maid, IChargingSpell chargingSpell) {
        try {
            return chargingSpell.castUp((LivingEntity)maid, this.getData(maid).getSpellBook());
        }
        catch (NoSuchMethodError e) {
            try {
                return chargingSpell.defaultCastUp();
            }
            catch (Exception ex) {
                return 0;
            }
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void executeChargingShot(EntityMaid maid, IChargingSpell chargingSpell) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            chargingSpell.SpellResult(serverLevel, (LivingEntity)maid, data.getSpellBook(), chargingSpell.defaultStats());
        }
    }

    private void playSpellSound(EntityMaid maid, ISpell spell) {
        maid.m_9236_().m_6263_(null, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), Objects.requireNonNull(spell.CastingSound()), SoundSource.HOSTILE, spell.castingVolume(), spell.castingPitch());
    }

    private void ensureWandEquipped(EntityMaid maid) {
        InteractionHand wandHand;
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        ItemStack mainHandItem = maid.m_21205_();
        ItemStack originalOffHand = maid.m_21206_();
        boolean hasWandInMainHand = this.isSpellBook(mainHandItem);
        boolean hasWandInOffHand = this.isSpellBook(originalOffHand);
        InteractionHand interactionHand = wandHand = hasWandInMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (!this.isSpellBook(data.getSpellBook())) {
            return;
        }
        if (!hasWandInMainHand && !hasWandInOffHand) {
            this.swapItem(maid, data.getSpellBook(), originalOffHand);
        }
        maid.m_6672_(wandHand);
    }

    private void swapItem(EntityMaid maid, ItemStack spellBook, ItemStack handItem) {
        if (maid == null) {
            return;
        }
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack stackInSlot = availableInv.getStackInSlot(i);
            if (!ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)spellBook)) continue;
            availableInv.setStackInSlot(i, handItem);
            maid.m_21008_(InteractionHand.OFF_HAND, spellBook);
            return;
        }
    }

    private void completeCasting(EntityMaid maid) {
        MaidGoetySpellData data = this.getData(maid);
        if (data == null || data.getCurrentSpell() == null) {
            return;
        }
        Level level = maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            data.getCurrentSpell().stopSpell(serverLevel, (LivingEntity)maid, data.getSpellBook(), 0);
            data.getCurrentSpell().SpellResult(serverLevel, (LivingEntity)maid, data.getSpellBook(), data.getCurrentSpell().defaultStats());
        }
        this.setCooldown(maid, data.getCurrentSpell());
        this.resetCastingState(maid, data);
    }

    private void resetCastingState(EntityMaid maid, MaidGoetySpellData data) {
        data.resetCastingState();
        maid.m_5810_();
    }

    private String getSpellId(ISpell spell) {
        return spell.getClass().getSimpleName();
    }

    private void setCooldown(EntityMaid maid, ISpell spell) {
        MaidGoetySpellData data = this.getData(maid);
        if (data != null && spell != null) {
            String spellId = this.getSpellId(spell);
            int cooldown = spell.defaultSpellCooldown();
            data.setSpellCooldown(spellId, cooldown, maid);
        }
    }

    private void logFocusSwitchBefore(EntityMaid maid, ItemStack spellBook, ItemStack focusBag, int bagSlot) {
        Item item;
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        LOGGER.debug("==== \u805a\u6676\u5207\u6362\u524d\u72b6\u6001 - \u5973\u4ec6: {} ====", (Object)maid.m_20148_());
        ItemStack currentFocus = IWand.getFocus((ItemStack)spellBook);
        if (!currentFocus.m_41619_() && (item = currentFocus.m_41720_()) instanceof IFocus) {
            IFocus focus = (IFocus)item;
            ISpell spell = focus.getSpell();
            String spellName = spell != null ? spell.getClass().getSimpleName() : "\u672a\u77e5";
            boolean onCooldown = spell != null && data.isSpellOnCooldown(this.getSpellId(spell));
            int cooldownRemaining = spell != null ? data.getSpellCooldown(this.getSpellId(spell)) : 0;
            LOGGER.debug("\u5f53\u524d\u6cd5\u6756\u805a\u6676: {} | \u6cd5\u672f: {} | \u51b7\u5374\u4e2d: {} | \u5269\u4f59\u51b7\u5374: {}\u523b", new Object[]{currentFocus.m_41611_().getString(), spellName, onCooldown, cooldownRemaining});
        } else {
            LOGGER.debug("\u5f53\u524d\u6cd5\u6756\u805a\u6676: \u65e0");
        }
        if (!focusBag.m_41619_()) {
            try {
                FocusBagItemHandler bagHandler = FocusBagItemHandler.get((ItemStack)focusBag);
                LOGGER.debug("\u805a\u6676\u5305\u4e2d\u7684\u805a\u6676:");
                for (int i = 0; i < bagHandler.getSlots(); ++i) {
                    Item cooldownRemaining;
                    ItemStack focusStack = bagHandler.getStackInSlot(i);
                    if (!focusStack.m_41619_() && (cooldownRemaining = focusStack.m_41720_()) instanceof IFocus) {
                        IFocus focus = (IFocus)cooldownRemaining;
                        ISpell spell = focus.getSpell();
                        String spellName = spell != null ? spell.getClass().getSimpleName() : "\u672a\u77e5";
                        boolean onCooldown = spell != null && data.isSpellOnCooldown(this.getSpellId(spell));
                        int cooldownRemaining2 = spell != null ? data.getSpellCooldown(this.getSpellId(spell)) : 0;
                        String isSelected = i == bagSlot ? " [\u5373\u5c06\u5207\u6362]" : "";
                        LOGGER.debug("  \u69fd\u4f4d{}: {} | \u6cd5\u672f: {} | \u51b7\u5374\u4e2d: {} | \u5269\u4f59\u51b7\u5374: {}\u523b{}", new Object[]{i, focusStack.m_41611_().getString(), spellName, onCooldown, cooldownRemaining2, isSelected});
                        continue;
                    }
                    LOGGER.debug("  \u69fd\u4f4d{}: \u7a7a", (Object)i);
                }
            }
            catch (Exception e) {
                LOGGER.warn("\u65e0\u6cd5\u8bfb\u53d6\u805a\u6676\u5305\u72b6\u6001: {}", (Object)e.getMessage());
            }
        } else {
            LOGGER.debug("\u805a\u6676\u5305: \u65e0");
        }
        LOGGER.debug("\u51c6\u5907\u5207\u6362: \u69fd\u4f4d{} -> \u6cd5\u6756", (Object)bagSlot);
    }

    private void logFocusSwitchAfter(EntityMaid maid, ItemStack spellBook, ItemStack focusBag) {
        Item item;
        MaidGoetySpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        LOGGER.debug("==== \u805a\u6676\u5207\u6362\u540e\u72b6\u6001 - \u5973\u4ec6: {} ====", (Object)maid.m_20148_());
        ItemStack currentFocus = IWand.getFocus((ItemStack)spellBook);
        if (!currentFocus.m_41619_() && (item = currentFocus.m_41720_()) instanceof IFocus) {
            IFocus focus = (IFocus)item;
            ISpell spell = focus.getSpell();
            String spellName = spell != null ? spell.getClass().getSimpleName() : "\u672a\u77e5";
            boolean onCooldown = spell != null && data.isSpellOnCooldown(this.getSpellId(spell));
            int cooldownRemaining = spell != null ? data.getSpellCooldown(this.getSpellId(spell)) : 0;
            LOGGER.debug("\u65b0\u7684\u6cd5\u6756\u805a\u6676: {} | \u6cd5\u672f: {} | \u51b7\u5374\u4e2d: {} | \u5269\u4f59\u51b7\u5374: {}\u523b", new Object[]{currentFocus.m_41611_().getString(), spellName, onCooldown, cooldownRemaining});
        } else {
            LOGGER.debug("\u65b0\u7684\u6cd5\u6756\u805a\u6676: \u65e0");
        }
        if (!focusBag.m_41619_()) {
            try {
                FocusBagItemHandler bagHandler = FocusBagItemHandler.get((ItemStack)focusBag);
                LOGGER.debug("\u5207\u6362\u540e\u805a\u6676\u5305\u72b6\u6001:");
                for (int i = 0; i < bagHandler.getSlots(); ++i) {
                    Item cooldownRemaining;
                    ItemStack focusStack = bagHandler.getStackInSlot(i);
                    if (!focusStack.m_41619_() && (cooldownRemaining = focusStack.m_41720_()) instanceof IFocus) {
                        IFocus focus = (IFocus)cooldownRemaining;
                        ISpell spell = focus.getSpell();
                        String spellName = spell != null ? spell.getClass().getSimpleName() : "\u672a\u77e5";
                        boolean onCooldown = spell != null && data.isSpellOnCooldown(this.getSpellId(spell));
                        int cooldownRemaining2 = spell != null ? data.getSpellCooldown(this.getSpellId(spell)) : 0;
                        LOGGER.debug("  \u69fd\u4f4d{}: {} | \u6cd5\u672f: {} | \u51b7\u5374\u4e2d: {} | \u5269\u4f59\u51b7\u5374: {}\u523b", new Object[]{i, focusStack.m_41611_().getString(), spellName, onCooldown, cooldownRemaining2});
                        continue;
                    }
                    LOGGER.debug("  \u69fd\u4f4d{}: \u7a7a", (Object)i);
                }
            }
            catch (Exception e) {
                LOGGER.warn("\u65e0\u6cd5\u8bfb\u53d6\u5207\u6362\u540e\u805a\u6676\u5305\u72b6\u6001: {}", (Object)e.getMessage());
            }
        } else {
            LOGGER.debug("\u805a\u6676\u5305: \u65e0");
        }
        LOGGER.debug("==== \u805a\u6676\u5207\u6362\u5b8c\u6210 ====");
    }

    private List<String> captureFocusState(ItemStack spellBook, ItemStack focusBag) {
        Item item;
        ArrayList<String> state = new ArrayList<String>();
        ItemStack currentFocus = IWand.getFocus((ItemStack)spellBook);
        if (!currentFocus.m_41619_() && (item = currentFocus.m_41720_()) instanceof IFocus) {
            IFocus focus = (IFocus)item;
            ISpell spell = focus.getSpell();
            String spellName = spell != null ? spell.getClass().getSimpleName() : "\u672a\u77e5";
            state.add("WAND:" + currentFocus.m_41611_().getString() + ":" + spellName);
        } else {
            state.add("WAND:EMPTY");
        }
        if (!focusBag.m_41619_()) {
            try {
                FocusBagItemHandler bagHandler = FocusBagItemHandler.get((ItemStack)focusBag);
                for (int i = 0; i < bagHandler.getSlots(); ++i) {
                    Item item2;
                    ItemStack focusStack = bagHandler.getStackInSlot(i);
                    if (!focusStack.m_41619_() && (item2 = focusStack.m_41720_()) instanceof IFocus) {
                        IFocus focus = (IFocus)item2;
                        ISpell spell = focus.getSpell();
                        String spellName = spell != null ? spell.getClass().getSimpleName() : "\u672a\u77e5";
                        state.add("BAG" + i + ":" + focusStack.m_41611_().getString() + ":" + spellName);
                        continue;
                    }
                    state.add("BAG" + i + ":EMPTY");
                }
            }
            catch (Exception e) {
                state.add("BAG:ERROR:" + e.getMessage());
            }
        }
        return state;
    }

    private void checkFocusStateChanges(EntityMaid maid, List<String> beforeState, List<String> afterState, int switchedSlot) {
        ArrayList<String> expectedAfterState = new ArrayList<String>(beforeState);
        String wandBefore = beforeState.stream().filter(s -> s.startsWith("WAND:")).findFirst().orElse("WAND:EMPTY");
        String bagSlotBefore = beforeState.stream().filter(s -> s.startsWith("BAG" + switchedSlot + ":")).findFirst().orElse("BAG" + switchedSlot + ":EMPTY");
        for (int i = 0; i < expectedAfterState.size(); ++i) {
            String item = (String)expectedAfterState.get(i);
            if (item.startsWith("WAND:")) {
                expectedAfterState.set(i, bagSlotBefore.replace("BAG" + switchedSlot + ":", "WAND:"));
                continue;
            }
            if (!item.startsWith("BAG" + switchedSlot + ":")) continue;
            expectedAfterState.set(i, wandBefore.replace("WAND:", "BAG" + switchedSlot + ":"));
        }
        boolean hasUnexpectedChanges = false;
        ArrayList<CallSite> warnings = new ArrayList<CallSite>();
        if (afterState.size() != expectedAfterState.size()) {
            hasUnexpectedChanges = true;
            warnings.add((CallSite)((Object)("\u805a\u6676\u603b\u6570\u53d1\u751f\u53d8\u5316: \u9884\u671f" + expectedAfterState.size() + "\u4e2a, \u5b9e\u9645" + afterState.size() + "\u4e2a")));
        } else {
            for (int i = 0; i < afterState.size(); ++i) {
                String expected;
                String actual = afterState.get(i);
                if (actual.equals(expected = (String)expectedAfterState.get(i))) continue;
                hasUnexpectedChanges = true;
                warnings.add((CallSite)((Object)("\u4f4d\u7f6e\u5f02\u5e38\u53d8\u5316: " + expected + " -> " + actual)));
            }
        }
        List<String> beforeFoci = beforeState.stream().filter(s -> !s.endsWith(":EMPTY") && !s.contains(":ERROR:")).map(s -> s.substring(s.indexOf(":") + 1)).sorted().toList();
        List<String> afterFoci = afterState.stream().filter(s -> !s.endsWith(":EMPTY") && !s.contains(":ERROR:")).map(s -> s.substring(s.indexOf(":") + 1)).sorted().toList();
        if (!beforeFoci.equals(afterFoci)) {
            hasUnexpectedChanges = true;
            ArrayList<String> lost = new ArrayList<String>(beforeFoci);
            lost.removeAll(afterFoci);
            if (!lost.isEmpty()) {
                warnings.add((CallSite)((Object)("\u805a\u6676\u4e22\u5931: " + String.join((CharSequence)", ", lost))));
            }
            ArrayList<String> arrayList = new ArrayList<String>(afterFoci);
            arrayList.removeAll(beforeFoci);
            if (!arrayList.isEmpty()) {
                warnings.add((CallSite)((Object)("\u805a\u6676\u610f\u5916\u51fa\u73b0: " + String.join((CharSequence)", ", arrayList))));
            }
        }
        if (hasUnexpectedChanges) {
            LOGGER.warn("\u26a0\ufe0f \u8b66\u544a\uff1a\u5973\u4ec6 {} \u7684\u805a\u6676\u5207\u6362\u8fc7\u7a0b\u4e2d\u53d1\u751f\u610f\u5916\u53d8\u5316\uff01", (Object)maid.m_20148_());
            for (String string : warnings) {
                LOGGER.warn("  - {}", (Object)string);
            }
            LOGGER.warn("\u5207\u6362\u524d\u72b6\u6001: {}", beforeState);
            LOGGER.warn("\u5207\u6362\u540e\u72b6\u6001: {}", afterState);
            LOGGER.warn("\u9884\u671f\u72b6\u6001: {}", expectedAfterState);
        } else {
            LOGGER.debug("\u2705 \u805a\u6676\u5207\u6362\u6b63\u5e38\u5b8c\u6210\uff0c\u65e0\u5f02\u5e38\u53d8\u5316");
        }
    }
}

