/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.BlueNoteSpellManager;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.weapons.StaffItem;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class IronsSpellbooksProvider
implements ISpellBookProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<String> spellBlacklist = Arrays.asList("irons_spellbooks:spectral_hammer");

    private MaidIronsSpellData getData(EntityMaid maid) {
        if (maid == null) {
            return null;
        }
        return MaidIronsSpellData.getOrCreate(maid.m_20148_());
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (itemStack.m_41720_() instanceof SpellBook) {
            return true;
        }
        if (itemStack.m_41720_() instanceof CastingItem) {
            return true;
        }
        if (itemStack.m_41720_() instanceof MagicSwordItem) {
            return true;
        }
        return ISpellContainer.isSpellContainer((ItemStack)itemStack);
    }

    @Override
    public void setTarget(EntityMaid maid, LivingEntity target) {
        MaidIronsSpellData data = this.getData(maid);
        if (data != null) {
            data.setTarget(target);
        }
    }

    @Override
    public LivingEntity getTarget(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        return data != null ? data.getTarget() : null;
    }

    @Override
    public void setSpellBook(EntityMaid maid, ItemStack spellBook) {
        MaidIronsSpellData data = this.getData(maid);
        if (data != null && spellBook != null && !spellBook.m_41619_()) {
            if (spellBook.m_41720_() instanceof SpellBook) {
                data.setSpellBook(spellBook);
            } else if (spellBook.m_41720_() instanceof MagicSwordItem) {
                data.setMagicSword(spellBook);
            } else if (spellBook.m_41720_() instanceof StaffItem || spellBook.m_41720_() instanceof CastingItem) {
                data.setStaff(spellBook);
            } else {
                data.setSpellBook(spellBook);
            }
        }
    }

    @Override
    public boolean isCasting(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        return data != null && data.isCasting();
    }

    @Override
    public boolean initiateCasting(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        if (data == null) {
            return false;
        }
        if (!data.hasAnySpellContainer()) {
            return false;
        }
        ArrayList<SpellData> availableSpells = new ArrayList<SpellData>();
        data.getAllSpellContainers().forEach(container -> {
            ISpellContainer spellContainer = ISpellContainer.get((ItemStack)container);
            if (!spellContainer.isEmpty()) {
                availableSpells.addAll(Arrays.asList(spellContainer.getAllSpells()));
            }
        });
        availableSpells.removeIf(spellData -> {
            if (spellData == null || spellData.getSpell() == null) {
                return true;
            }
            String spellId = spellData.getSpell().getSpellId();
            if (data.isSpellOnCooldown(spellId)) {
                return true;
            }
            if (spellBlacklist.contains(spellId)) {
                LOGGER.debug("\u6cd5\u672f {} \u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u5973\u4ec6 {} \u8df3\u8fc7\u65bd\u653e", (Object)spellId, (Object)maid.m_20148_());
                return true;
            }
            return false;
        });
        if (availableSpells.isEmpty()) {
            return false;
        }
        int index = (int)(Math.random() * (double)availableSpells.size());
        SpellData spellData2 = (SpellData)availableSpells.get(index);
        BaubleStateManager.getBaubles(maid).forEach(bauble -> {
            if (!bauble.m_41778_().equals(MaidSpellItems.itemDesc(MaidSpellItems.BLUE_NOTE))) {
                return;
            }
            LOGGER.debug("storedSpells:");
            BlueNoteSpellManager.getStoredSpellIds(bauble).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            if (BlueNoteSpellManager.getStoredSpellIds(bauble).contains(spellData2.getSpell().getSpellId())) {
                LOGGER.debug("should cast to owner : {}", (Object)spellData2.getSpell().getSpellId());
                data.switchTargetToOwner(maid);
            } else {
                data.switchTargetToOrigin(maid);
            }
        });
        return this.initiateCasting(maid, spellData2);
    }

    private boolean initiateCasting(EntityMaid maid, SpellData spellData) {
        MaidIronsSpellData data = this.getData(maid);
        if (spellData == null || spellData.getSpell() == null || maid == null || data == null) {
            return false;
        }
        if (data.isCasting()) {
            return false;
        }
        try {
            AbstractSpell spell = spellData.getSpell();
            LivingEntity target = data.getTarget();
            if (target != null) {
                if (target == maid.m_269323_()) {
                    LOGGER.debug("look at owner");
                }
                BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
                maid.m_146922_(Mth.m_14094_((float)maid.m_146908_(), (float)maid.f_20885_, (float)0.0f));
                maid.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            }
            this.setupSpellTargetData(maid, spell, spellData.getLevel());
            MagicData magicData = data.getMagicData();
            if (!spell.checkPreCastConditions(maid.m_9236_(), spellData.getLevel(), (LivingEntity)maid, magicData)) {
                return false;
            }
            int effectiveCastTime = spell.getEffectiveCastTime(spellData.getLevel(), (LivingEntity)maid);
            CastSource castSource = this.getCastSource(data.getSpellBook());
            magicData.initiateCast(spell, spellData.getLevel(), effectiveCastTime, castSource, "offhand");
            spell.onServerPreCast(maid.m_9236_(), spellData.getLevel(), (LivingEntity)maid, magicData);
            data.setCurrentCastingSpell(spellData);
            data.setCasting(true);
            maid.m_6674_(maid.m_7655_());
            return true;
        }
        catch (Exception e) {
            data.resetCastingState();
            return false;
        }
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        int remaining;
        MaidIronsSpellData data = this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentCastingSpell() == null) {
            return;
        }
        AbstractSpell spell = data.getCurrentCastingSpell().getSpell();
        MagicData magicData = data.getMagicData();
        LivingEntity target = data.getTarget();
        if (target != null) {
            if (target == maid.m_269323_()) {
                LOGGER.debug("look at owner");
            }
            BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
            maid.m_146922_(Mth.m_14094_((float)maid.m_146908_(), (float)maid.f_20885_, (float)0.0f));
            maid.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
        }
        magicData.handleCastDuration();
        if (magicData.isCasting()) {
            spell.onServerCastTick(maid.m_9236_(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, magicData);
        }
        if ((remaining = magicData.getCastDurationRemaining()) <= 0) {
            this.completeCasting(maid);
        } else if (spell.getCastType() == CastType.CONTINUOUS && (remaining + 1) % 10 == 0) {
            CastSource castSource = this.getCastSource(data.getSpellBook());
            spell.onCast(maid.m_9236_(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, castSource, magicData);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentCastingSpell() == null) {
            return;
        }
        this.forceCompleteCasting(maid);
    }

    @Override
    public boolean castSpell(EntityMaid maid) {
        return this.initiateCasting(maid);
    }

    @Override
    public void updateCooldown(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        if (data != null) {
            data.updateCooldowns();
        }
    }

    private CastSource getCastSource(ItemStack spellContainer) {
        if (spellContainer == null || spellContainer.m_41619_()) {
            return CastSource.SPELLBOOK;
        }
        if (spellContainer.m_41720_() instanceof MagicSwordItem) {
            return CastSource.SWORD;
        }
        return CastSource.SPELLBOOK;
    }

    private void setCooldown(EntityMaid maid, AbstractSpell spell) {
        MaidIronsSpellData data = this.getData(maid);
        if (data == null || spell == null) {
            return;
        }
        double cooldownModifier = maid.m_21133_((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get());
        int cooldownTicks = (int)((double)spell.getSpellCooldown() * (2.0 - Utils.softCapFormula((double)cooldownModifier)));
        String spellId = spell.getSpellId();
        data.setSpellCooldown(spellId, cooldownTicks, maid);
    }

    private void forceCompleteCasting(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        if (data == null || data.getCurrentCastingSpell() == null) {
            return;
        }
        AbstractSpell spell = data.getCurrentCastingSpell().getSpell();
        this.setCooldown(maid, spell);
        data.resetCastingState();
    }

    private void completeCasting(EntityMaid maid) {
        MaidIronsSpellData data = this.getData(maid);
        if (data == null || data.getCurrentCastingSpell() == null) {
            return;
        }
        AbstractSpell spell = data.getCurrentCastingSpell().getSpell();
        MagicData magicData = data.getMagicData();
        if (spell.getCastType() == CastType.LONG || spell.getCastType() == CastType.INSTANT) {
            CastSource castSource = this.getCastSource(data.getSpellBook());
            spell.onCast(maid.m_9236_(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, castSource, magicData);
        }
        spell.onServerCastComplete(maid.m_9236_(), data.getCurrentCastingSpell().getLevel(), (LivingEntity)maid, magicData, false);
        this.setCooldown(maid, spell);
        data.resetCastingState();
    }

    private void setupSpellTargetData(EntityMaid maid, AbstractSpell spell, int spellLevel) {
        MaidIronsSpellData data = this.getData(maid);
        if (data == null) {
            return;
        }
        LivingEntity target = data.getTarget();
        if (target == null) {
            return;
        }
        MagicData magicData = data.getMagicData();
        String spellId = spell.getSpellId();
        if (spellId.equals("irons_spellbooks:teleport") || spellId.contains("step")) {
            this.setTeleportLocationBehindTarget(maid, target, magicData, spell, spellLevel);
        } else if (spellId.equals("irons_spellbooks:starfall") || spellId.equals("irons_spellbooks:scorch") || spellId.contains("storm") || spellId.contains("surge")) {
            Vec3 targetPosition = target.m_20182_();
            if (spellId.equals("irons_spellbooks:starfall")) {
                targetPosition = Utils.moveToRelativeGroundLevel((Level)maid.m_9236_(), (Vec3)targetPosition, (int)12);
                TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)maid.m_9236_(), (Vec3)targetPosition, (float)6.0f, (int)6291596);
                magicData.setAdditionalCastData((ICastData)new TargetAreaCastData(targetPosition, area));
            } else if (spellId.equals("irons_spellbooks:scorch")) {
                float radius = 2.5f;
                TargetedAreaEntity area = TargetedAreaEntity.createTargetAreaEntity((Level)maid.m_9236_(), (Vec3)targetPosition, (float)radius, (int)Utils.packRGB((Vector3f)spell.getTargetingColor()));
                magicData.setAdditionalCastData((ICastData)new TargetAreaCastData(targetPosition, area));
            }
        }
    }

    private void setTeleportLocationBehindTarget(EntityMaid maid, LivingEntity target, MagicData magicData, AbstractSpell spell, int spellLevel) {
        if (target == null || maid == null) {
            magicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(maid.m_20182_()));
            return;
        }
        int distance = 10;
        Vec3 teleportPos = target.m_20182_();
        boolean validPositionFound = false;
        for (int i = 0; i < 24; ++i) {
            Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).m_82542_(1.0, 0.0, 1.0);
            teleportPos = Utils.moveToRelativeGroundLevel((Level)maid.m_9236_(), (Vec3)target.m_20182_().m_82546_(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180))).m_82549_(randomness), (int)5);
            teleportPos = new Vec3(teleportPos.f_82479_, teleportPos.f_82480_ + (double)0.1f, teleportPos.f_82481_);
            AABB reposBB = maid.m_20191_().m_82383_(teleportPos.m_82546_(maid.m_20182_()));
            if (maid.m_9236_().m_186437_((Entity)maid, reposBB.m_82400_((double)-0.05f))) continue;
            validPositionFound = true;
            break;
        }
        if (!validPositionFound) {
            teleportPos = target.m_20182_();
        }
        magicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
    }
}

